/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.DeviceExplorerViewProgressListener;
import com.intellij.openapi.Disposable;
import org.jetbrains.annotations.NotNull;

abstract class LongRunningOperationTracker
implements Disposable {
    @NotNull
    private DeviceExplorerView myView;
    @NotNull
    private final DeviceExplorerViewProgressListener myProgressListener;
    private boolean myIsCancelled;
    private long myStartNanoTime;

    public LongRunningOperationTracker(@NotNull DeviceExplorerView view) {
        this.myView = view;
        this.myProgressListener = () -> {
            this.myIsCancelled = true;
        };
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    public long getDurationMillis() {
        return (System.nanoTime() - this.myStartNanoTime) / 1000000L;
    }

    public void start() {
        this.myView.addProgressListener(this.myProgressListener);
        this.myView.startProgress();
        this.myStartNanoTime = System.nanoTime();
        this.myIsCancelled = false;
    }

    public void stop() {
        this.myView.removeProgressListener(this.myProgressListener);
        this.myView.stopProgress();
    }

    public void dispose() {
        this.stop();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myView.setProgressIndeterminate(indeterminate);
    }

    public void setProgress(double fraction) {
        this.myView.setProgressValue(fraction);
    }

    public void setStatusText(@NotNull String text2) {
        this.myView.setProgressText(text2);
    }

    public void setWarningColor() {
        this.myView.setProgressWarningColor();
    }
}

