/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.FileTransferSummary;
import com.android.tools.idea.explorer.FileTransferWorkEstimate;
import com.android.tools.idea.explorer.FileTransferWorkEstimator;
import com.android.tools.idea.explorer.LongRunningOperationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.NotNull;

public class FileTransferOperationTracker
extends LongRunningOperationTracker {
    private static final int MAX_PATH_DISPLAY_LENGTH = 50;
    @NotNull
    private final FileTransferSummary mySummary = new FileTransferSummary();
    private long myFinishedWorkUnits;
    private long myTotalWorkUnits;
    private int myCurrentFileCount;
    private int myTotalFileCount;
    private int myCurrentDirectoryCount;
    private int myTotalDirectoryCount;

    public FileTransferOperationTracker(@NotNull DeviceExplorerView view) {
        super(view);
    }

    @NotNull
    public FileTransferSummary getSummary() {
        return this.mySummary;
    }

    @Override
    public void stop() {
        super.stop();
        this.mySummary.setDurationMillis(this.getDurationMillis());
    }

    public void addProblem(@NotNull Throwable error) {
        if (ExceptionUtil.getRootCause((Throwable)error) instanceof CancellationException) {
            return;
        }
        this.mySummary.getProblems().add(error);
        this.setWarningColor();
    }

    public void showProgress() {
        if (this.myTotalWorkUnits == 0L) {
            return;
        }
        this.setProgress((double)this.myFinishedWorkUnits / (double)this.myTotalWorkUnits);
    }

    public void processDirectory() {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getDirectoryWorkUnits();
        ++this.myCurrentDirectoryCount;
        this.showProgress();
    }

    public void processFile() {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getFileWorkUnits();
        ++this.myCurrentFileCount;
        this.showProgress();
    }

    public void processFileBytes(long byteCount) {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getFileContentsWorkUnits(byteCount);
        this.showProgress();
    }

    public void setUploadFileText(@NotNull VirtualFile file2, long currentBytes, long totalBytes) {
        String text2 = this.myTotalFileCount > 1 ? String.format(Locale.US, "Uploading file %,d of %,d: \"%s\"", this.myCurrentFileCount, this.myTotalFileCount, StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)50)) : String.format("Uploading file \"%s\"", StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)50));
        if (totalBytes > 0L) {
            text2 = text2 + String.format(" (%s / %s)", HumanReadableUtil.getHumanizedSize((long)currentBytes), HumanReadableUtil.getHumanizedSize((long)totalBytes));
        }
        this.setStatusText(text2);
    }

    public void setDownloadFileText(@NotNull String entryFullPath, long currentBytes, long totalBytes) {
        String text2 = this.myTotalFileCount > 1 ? String.format(Locale.US, "Downloading file %,d of %,d: \"%s\"", this.myCurrentFileCount, this.myTotalFileCount, StringUtil.shortenPathWithEllipsis((String)entryFullPath.toString(), (int)50)) : String.format("Downloading file \"%s\"", StringUtil.shortenPathWithEllipsis((String)entryFullPath.toString(), (int)50));
        if (totalBytes > 0L) {
            text2 = text2 + String.format(" (%s / %s)", HumanReadableUtil.getHumanizedSize((long)currentBytes), HumanReadableUtil.getHumanizedSize((long)totalBytes));
        }
        this.setStatusText(text2);
    }

    public void addWorkEstimate(FileTransferWorkEstimate estimate) {
        this.myTotalFileCount += estimate.getFileCount();
        this.myTotalDirectoryCount += estimate.getDirectoryCount();
        this.myTotalWorkUnits += estimate.getWorkUnits();
    }

    public void setCalculatingText(int fileCount2, int directoryCount) {
        String text2 = "Calculating...";
        if ((fileCount2 += this.myTotalFileCount) > 0 || (directoryCount += this.myTotalDirectoryCount) > 0) {
            text2 = text2 + String.format(Locale.US, " %,d %s, %,d %s", fileCount2, StringUtil.pluralize((String)"file", (int)fileCount2), directoryCount, StringUtil.pluralize((String)"directory", (int)directoryCount));
        }
        this.setStatusText(text2);
    }
}

