/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.annotations.concurrency.AnyThread;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class DeviceExplorerFilesUtils {
    @AnyThread
    @NotNull
    public static ListenableFuture<VirtualFile> findFile(@NotNull Path localPath) {
        SettableFuture futureFile = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile localFile = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (localFile == null) {
                futureFile.setException((Throwable)new RuntimeException(String.format("Unable to locate file \"%s\"", localPath)));
            } else {
                futureFile.set((Object)localFile);
            }
        }, ApplicationManager.getApplication().getDisposed());
        return futureFile;
    }
}

