/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.utils;

import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.callgraph.Callgraph;
import com.android.tools.idea.experimental.codeanalysis.callgraph.CallgraphBuilder;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGField;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.MethodGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.utils.CFGUtil;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGDebugUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiCFGAnalysisUtil {
    private PsiCFGScene mScene;
    private PsiClass mLangOjectClass;

    public PsiCFGAnalysisUtil(PsiCFGScene scene) {
        this.mScene = scene;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.mScene.getProject());
        this.mLangOjectClass = facade.findClass("java.lang.Object", GlobalSearchScope.allScope((Project)this.mScene.getProject()));
    }

    public void performStage0() {
    }

    public void performStage1() {
        PsiCFGClass[] appClasses;
        for (PsiCFGClass curClass : appClasses = this.mScene.getAllApplicationClasses()) {
            this.parseFields(curClass);
            this.parseMethods(curClass);
        }
    }

    public void performStage2() {
        PsiCFGClass[] appClasses;
        for (PsiCFGClass cfgClazz : appClasses = this.mScene.getAllApplicationClasses()) {
            this.setClassHierarchyForApplicationClass(cfgClazz);
        }
    }

    public void performStage3() {
        PsiCFGClass[] appClasses = this.mScene.getAllApplicationClasses();
        this.mScene.workingList.clear();
        this.mScene.workingList.addAll(Arrays.asList(appClasses));
        while (!this.mScene.workingList.isEmpty()) {
            PsiCFGMethod[] allMethods;
            PsiCFGClass currentClass = this.mScene.workingList.removeFirst();
            for (PsiCFGMethod currentMethod : allMethods = currentClass.getAllMethods()) {
                PsiMethod methodRef;
                if (currentMethod.isAbstract() || currentMethod.isLambda() || (methodRef = currentMethod.getMethodRef()) == null) continue;
                PsiCodeBlock codeBlock = methodRef.getBody();
                if (codeBlock == null) {
                    PsiCFGDebugUtil.LOG.info("In " + currentClass.getQualifiedClassName() + "." + currentMethod.getName() + "Code block is null");
                    continue;
                }
                MethodGraph cfg = CFGUtil.constructMethodGraph(this.mScene, codeBlock, currentMethod);
                currentMethod.setControlFlowGraph(cfg);
            }
        }
    }

    public void performStage4() {
        PsiCFGClass[] libraryClasses2 = this.mScene.getAllLibraryClasses();
        Set<PsiClass> LibraryClassSet = this.mScene.getAllLibraryClassPsiSet();
        for (PsiCFGClass curLibClass : libraryClasses2) {
            PsiClass psiRef = curLibClass.getPsiClass();
            if (psiRef == null) continue;
            PsiClass superRef = psiRef.getSuperClass();
            PsiClass[] interfaceRefs = psiRef.getInterfaces();
            if (LibraryClassSet.contains(superRef)) {
                PsiCFGClass superCFGClass = this.mScene.getOrCreateCFGClass(superRef);
                curLibClass.setSuperClass(superCFGClass);
                superCFGClass.addSubClass(curLibClass);
            }
            this.setInterfacesIfInLibrary(curLibClass, interfaceRefs, LibraryClassSet);
        }
    }

    public void performStage5() {
        CallgraphBuilder cgBuilder = new CallgraphBuilder(this.mScene, this);
        cgBuilder.build();
        Callgraph cg = cgBuilder.getCallGraph();
        this.mScene.setCallGraph(cg);
        CFGUtil.outputCallGraphDotFile(cg);
    }

    public void performStage6() {
    }

    public void summarizeStage() {
        PsiCFGClass[] applicationClasses = this.mScene.getAllApplicationClasses();
        PsiCFGClass[] libraryClasses2 = this.mScene.getAllLibraryClasses();
        PsiCFGClass[] lamdbdaClasses = this.mScene.getAllLambdaClass();
        GraphNode[] invocationNodes = this.mScene.getAllInvocationNode();
        System.out.println("Application Classes: ");
        this.printCFGClassArray(applicationClasses);
        System.out.println();
        System.out.println("Library Classes: ");
        this.printCFGClassArray(libraryClasses2);
        System.out.println();
        System.out.println("Lambda Classes: ");
        this.printCFGClassArray(lamdbdaClasses);
        System.out.println();
        System.out.println("InvocationNodes: " + invocationNodes.length);
    }

    public void setInterfacesIfInLibrary(PsiCFGClass curLibraryClass, PsiClass[] interfazes, Set<PsiClass> interfaceSet) {
        for (PsiClass curInterface : interfazes) {
            if (!interfaceSet.contains(curInterface)) continue;
            PsiCFGClass curCFGInterface = this.mScene.getOrCreateCFGClass(curInterface);
            curLibraryClass.setSuperClass(curCFGInterface);
            curCFGInterface.addSubClass(curLibraryClass);
        }
    }

    public void printCFGClassArray(PsiCFGClass[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            System.out.println(classArray[i2].getQualifiedClassName());
        }
    }

    public void setClassHierarchyForApplicationClass(@NotNull PsiCFGClass clazz) {
        if (clazz.getPsiClass() != null) {
            PsiClass psiClassRef = clazz.getPsiClass();
            PsiClass directSuperClass = psiClassRef.getSuperClass();
            PsiClass[] implementedInterface = psiClassRef.getInterfaces();
            if (directSuperClass == null && this.mLangOjectClass != null) {
                PsiCFGDebugUtil.LOG.warning("Super class is null for class " + clazz.getQualifiedClassName());
                directSuperClass = this.mLangOjectClass;
            }
            if (directSuperClass != null) {
                PsiCFGClass directCFGSuperClass = this.mScene.getOrCreateCFGClass(directSuperClass);
                clazz.setSuperClass(directCFGSuperClass);
                directCFGSuperClass.addSubClass(clazz);
            }
            for (PsiClass interfaze : implementedInterface) {
                PsiCFGClass cfgInterfaze = this.mScene.getOrCreateCFGClass(interfaze);
                clazz.addInterface(cfgInterfaze);
                if (clazz.isInterface()) {
                    cfgInterfaze.addSubInterface(clazz);
                    continue;
                }
                cfgInterfaze.addSubClass(clazz);
            }
        }
    }

    public void parseFields(@NotNull PsiCFGClass clazz) {
        PsiField[] fields;
        for (PsiField curField : fields = clazz.getPsiClass().getFields()) {
            PsiCFGField curCFGField = new PsiCFGField(curField, clazz);
            clazz.addField(curCFGField);
        }
    }

    public void parseMethods(@NotNull PsiCFGClass clazz) {
        PsiMethod[] methods2;
        for (PsiMethod curMethod : methods2 = clazz.getPsiClass().getMethods()) {
            PsiCFGMethod curCFGMethod = new PsiCFGMethod(curMethod, clazz);
            clazz.addMethod(curCFGMethod);
        }
    }
}

