/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental;

import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGAnalysisUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CodeAnalysisMain {
    private static Map<Project, CodeAnalysisMain> instanceMap = Maps.newHashMap();
    private Project mProject;
    private PsiCFGScene mScene;

    private CodeAnalysisMain(Project project) {
        this.mProject = project;
    }

    @NotNull
    public static CodeAnalysisMain getInstance(@NotNull Project project) {
        if (instanceMap.containsKey(project)) {
            return instanceMap.get(project);
        }
        CodeAnalysisMain instance = new CodeAnalysisMain(project);
        instanceMap.put(project, instance);
        return instance;
    }

    public void analyze(@NotNull AnalysisScope scope2) {
        this.mScene = PsiCFGScene.createFreshInstance(this.mProject);
        PsiCFGAnalysisUtil AnalysisUtil = this.mScene.analysisUtil;
        int fileCount2 = scope2.getFileCount();
        PsiFile[] allFilesInScope = this.findAllJavaFiles(this.mProject, scope2);
        this.initiateProjectClassesFromPsiFile(allFilesInScope);
        PsiCFGClass[] allClasses = this.mScene.getAllApplicationClasses();
        AnalysisUtil.performStage0();
        AnalysisUtil.performStage1();
        AnalysisUtil.performStage2();
        AnalysisUtil.performStage3();
        AnalysisUtil.performStage4();
        AnalysisUtil.performStage5();
        AnalysisUtil.performStage6();
    }

    private void outputFileNames(PsiFile[] filesArray) {
        for (PsiFile f : filesArray) {
            System.out.println(f.getName());
        }
    }

    protected PsiFile[] findAllJavaFiles(@NotNull Project project, @NotNull AnalysisScope scope2) {
        final ArrayList retList = Lists.newArrayList();
        scope2.accept(new PsiElementVisitor(){

            public void visitFile(PsiFile file2) {
                if (file2 instanceof PsiJavaFile) {
                    retList.add(file2);
                }
            }
        });
        return retList.toArray(PsiFile.EMPTY_ARRAY);
    }

    private void initiateProjectClassesFromPsiFile(@NotNull PsiFile[] files2) {
        for (PsiFile pFile : files2) {
            PsiClass[] curClassesInFile;
            if (!(pFile instanceof PsiJavaFile)) continue;
            for (PsiClass curClass : curClassesInFile = this.extractProjectClasses(pFile)) {
                this.mScene.createPsiCFGClass(curClass, pFile, true);
            }
        }
    }

    private PsiClass[] extractProjectClasses(PsiFile pFile) {
        ArrayList retList = Lists.newArrayList();
        if (!(pFile instanceof PsiJavaFile)) {
            return retList.toArray(PsiClass.EMPTY_ARRAY);
        }
        PsiJavaFile curJavaFile = (PsiJavaFile)pFile;
        PsiClass[] firstLevelClasses = curJavaFile.getClasses();
        if (firstLevelClasses.length == 0) {
            return retList.toArray(PsiClass.EMPTY_ARRAY);
        }
        for (PsiClass clazz : firstLevelClasses) {
            this.retrieveClassAndInnerClass(retList, clazz);
        }
        return retList.toArray(PsiClass.EMPTY_ARRAY);
    }

    private void retrieveClassAndInnerClass(@NotNull ArrayList<PsiClass> retList, @NotNull PsiClass psiClass) {
        retList.add(psiClass);
        PsiClass[] innerClasses = psiClass.getInnerClasses();
        if (innerClasses == null || innerClasses.length == 0) {
            return;
        }
        for (PsiClass innerClazz : innerClasses) {
            this.retrieveClassAndInnerClass(retList, innerClazz);
        }
    }
}

