/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdLaunchListener;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.EmulatorId;
import com.android.tools.idea.emulator.EmulatorToolWindowManager;
import com.android.tools.idea.emulator.EmulatorToolWindowManager$sam$java_lang_Runnable$0;
import com.android.tools.idea.emulator.EmulatorToolWindowPanel;
import com.android.tools.idea.emulator.EmulatorUtilsKt;
import com.android.tools.idea.emulator.PlaceholderPanel;
import com.android.tools.idea.emulator.RunningEmulatorCatalog;
import com.android.tools.idea.run.AppDeploymentListener;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import icons.StudioIcons;
import java.text.Collator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\b*\u0002\u000e\u0013\b\u0000\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0003JKLB\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001dH\u0002J\u0010\u00103\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000201H\u0002J\u0010\u00107\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J\u0010\u00108\u001a\u0002012\u0006\u00102\u001a\u00020\u001dH\u0017J\u0010\u00109\u001a\u0002012\u0006\u00102\u001a\u00020\u001dH\u0017J\u0012\u0010:\u001a\u0004\u0018\u00010!2\u0006\u0010;\u001a\u00020&H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010!2\u0006\u0010=\u001a\u00020,H\u0002J\b\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u000205H\u0002J\u0010\u0010A\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010B\u001a\u0002012\u0006\u0010C\u001a\u00020-H\u0003J\u001e\u0010B\u001a\u0002012\u0006\u0010C\u001a\u00020-2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001d0EH\u0002J\u0010\u0010F\u001a\u0002012\u0006\u0010;\u001a\u00020&H\u0002J\u0010\u0010G\u001a\u0002012\u0006\u00102\u001a\u00020\u001dH\u0002J\u0010\u0010H\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010I\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R$\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00118B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n \t*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010$\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010&0&\u0012\f\u0012\n \t*\u0004\u0018\u00010&0& \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010&0&\u0012\f\u0012\n \t*\u0004\u0018\u00010&0&\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00118B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u0018\"\u0004\b*\u0010\u001aR\u0018\u0010+\u001a\u00020,*\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006M"}, d2={"Lcom/android/tools/idea/emulator/EmulatorToolWindowManager;", "Lcom/android/tools/idea/emulator/RunningEmulatorCatalog$Listener;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ID_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/emulator/EmulatorId;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "alarm", "Lcom/intellij/util/Alarm;", "connectionStateListener", "com/android/tools/idea/emulator/EmulatorToolWindowManager$connectionStateListener$1", "Lcom/android/tools/idea/emulator/EmulatorToolWindowManager$connectionStateListener$1;", "contentCreated", "", "contentManagerListener", "com/android/tools/idea/emulator/EmulatorToolWindowManager$contentManagerListener$1", "Lcom/android/tools/idea/emulator/EmulatorToolWindowManager$contentManagerListener$1;", "value", "deviceFrameVisible", "getDeviceFrameVisible", "()Z", "setDeviceFrameVisible", "(Z)V", "emulators", "", "Lcom/android/tools/idea/emulator/EmulatorController;", "lastSelectedEmulatorId", "panels", "", "Lcom/android/tools/idea/emulator/EmulatorToolWindowPanel;", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "recentLaunches", "Lcom/google/common/cache/Cache;", "", "selectedPanel", "zoomToolbarIsVisible", "getZoomToolbarIsVisible", "setZoomToolbarIsVisible", "serialPort", "", "Lcom/android/ddmlib/IDevice;", "getSerialPort", "(Lcom/android/ddmlib/IDevice;)I", "addEmulatorPanel", "", "emulator", "createContent", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createPlaceholderPanel", "destroyContent", "emulatorAdded", "emulatorRemoved", "findPanelByAvdId", "avdId", "findPanelByGrpcPort", "grpcPort", "getContentManager", "Lcom/intellij/ui/content/ContentManager;", "getToolWindow", "hideLiveIndicator", "onDeploymentToEmulator", "device", "runningEmulators", "", "onEmulatorUsed", "removeEmulatorPanel", "showLiveIndicator", "viewSelectionChanged", "Companion", "ToggleDeviceFrameAction", "ToggleZoomToolbarAction", "intellij.android.emulator"})
public final class EmulatorToolWindowManager
implements RunningEmulatorCatalog.Listener,
DumbAware {
    private final Key<EmulatorId> ID_KEY;
    private boolean contentCreated;
    private final List<EmulatorToolWindowPanel> panels;
    private EmulatorToolWindowPanel selectedPanel;
    private EmulatorId lastSelectedEmulatorId;
    private final Set<EmulatorController> emulators;
    private final PropertiesComponent properties;
    private final Cache<String, String> recentLaunches;
    private final Alarm alarm;
    private final contentManagerListener.1 contentManagerListener;
    private final connectionStateListener.1 connectionStateListener;
    private final Project project;
    private static final String DEVICE_FRAME_VISIBLE_PROPERTY = "com.android.tools.idea.emulator.frame.visible";
    private static final boolean DEVICE_FRAME_VISIBLE_DEFAULT = true;
    private static final String ZOOM_TOOLBAR_VISIBLE_PROPERTY = "com.android.tools.idea.emulator.zoom.toolbar.visible";
    private static final boolean ZOOM_TOOLBAR_VISIBLE_DEFAULT = true;
    private static final int EMULATOR_DISCOVERY_INTERVAL_MILLIS = 1000;
    private static final Duration LAUNCH_INFO_EXPIRATION;
    private static final Collator COLLATOR;
    private static final Comparator<EmulatorToolWindowPanel> PANEL_COMPARATOR;
    private static final Set<Project> registeredProjects;
    public static final Companion Companion;

    private final boolean getDeviceFrameVisible() {
        return this.properties.getBoolean(DEVICE_FRAME_VISIBLE_PROPERTY, true);
    }

    private final void setDeviceFrameVisible(boolean value2) {
        this.properties.setValue(DEVICE_FRAME_VISIBLE_PROPERTY, value2, true);
        for (EmulatorToolWindowPanel panel2 : this.panels) {
            panel2.setDeviceFrameVisible(value2);
        }
    }

    private final boolean getZoomToolbarIsVisible() {
        return this.properties.getBoolean(ZOOM_TOOLBAR_VISIBLE_PROPERTY, true);
    }

    private final void setZoomToolbarIsVisible(boolean value2) {
        this.properties.setValue(ZOOM_TOOLBAR_VISIBLE_PROPERTY, value2, true);
        for (EmulatorToolWindowPanel panel2 : this.panels) {
            panel2.setZoomToolbarVisible(value2);
        }
    }

    @AnyThread
    private final void onDeploymentToEmulator(IDevice device) {
        ListenableFuture<Set<EmulatorController>> future2 = RunningEmulatorCatalog.Companion.getInstance().updateNow();
        FutureUtils.addCallback(future2, (Executor)((Executor)EdtExecutorService.getInstance()), (Function1)((Function1)new Function1<Set<? extends EmulatorController>, Unit>(this, device){
            final /* synthetic */ EmulatorToolWindowManager this$0;
            final /* synthetic */ IDevice $device;

            public final void invoke(@Nullable Set<EmulatorController> emulators) {
                if (emulators != null) {
                    EmulatorToolWindowManager.access$onDeploymentToEmulator(this.this$0, this.$device, emulators);
                }
            }
            {
                this.this$0 = emulatorToolWindowManager;
                this.$device = iDevice;
                super(1);
            }
        }), (Function1)onDeploymentToEmulator.2.INSTANCE);
    }

    private final void onDeploymentToEmulator(IDevice device, Set<EmulatorController> runningEmulators) {
        Object v0;
        block3: {
            int serialPort = this.getSerialPort(device);
            Iterable iterable = runningEmulators;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                EmulatorController it = (EmulatorController)t;
                boolean bl3 = false;
                if (!(it.getEmulatorId().getSerialPort() == serialPort)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        EmulatorController emulatorController = v0;
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulator = emulatorController;
        if (emulator.getEmulatorId().isEmbedded()) {
            this.onEmulatorUsed(emulator.getEmulatorId().getAvdId());
        }
    }

    private final void onEmulatorUsed(String avdId) {
        EmulatorToolWindowPanel panel2;
        ToolWindow toolWindow = this.getToolWindow();
        if (!toolWindow.isVisible()) {
            toolWindow.show(null);
            if (!toolWindow.isActive()) {
                toolWindow.activate(null);
            }
        }
        if ((panel2 = this.findPanelByAvdId(avdId)) == null) {
            RunningEmulatorCatalog.Companion.getInstance().updateNow();
            this.recentLaunches.put((Object)avdId, (Object)avdId);
            Function0 function0 = (Function0)new Function0<Unit>(this.recentLaunches){

                public final void invoke() {
                    ((Cache)this.receiver).cleanUp();
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Cache.class);
                }

                public final String getName() {
                    return "cleanUp";
                }

                public final String getSignature() {
                    return "cleanUp()V";
                }
            };
            this.alarm.addRequest((Runnable)new EmulatorToolWindowManager$sam$java_lang_Runnable$0(function0), LAUNCH_INFO_EXPIRATION.toMillis());
        } else if (Intrinsics.areEqual((Object)((Object)this.selectedPanel), (Object)((Object)panel2)) ^ true) {
            ContentManager contentManager = toolWindow.getContentManager();
            Content content2 = contentManager.getContent(panel2.getComponent());
            contentManager.setSelectedContent(content2);
        }
    }

    private final void createContent(ToolWindow toolWindow) {
        EmulatorController emulatorController;
        if (this.contentCreated) {
            return;
        }
        this.contentCreated = true;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new ToggleZoomToolbarAction());
        actionGroup.addAction((AnAction)new ToggleDeviceFrameAction());
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowEx");
        }
        ((ToolWindowEx)toolWindow2).setAdditionalGearActions((ActionGroup)actionGroup);
        RunningEmulatorCatalog emulatorCatalog = RunningEmulatorCatalog.Companion.getInstance();
        emulatorCatalog.updateNow();
        emulatorCatalog.addListener(this, 1000);
        CollectionsKt.addAll((Collection)this.emulators, (Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)emulatorCatalog.getEmulators()), (Function1)createContent.1.INSTANCE));
        EmulatorId emulatorId = this.lastSelectedEmulatorId;
        if (emulatorId != null) {
            Object v2;
            block8: {
                EmulatorId emulatorId2 = emulatorId;
                boolean bl = false;
                boolean bl2 = false;
                EmulatorId it = emulatorId2;
                boolean bl3 = false;
                Iterable iterable = this.emulators;
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                boolean bl5 = false;
                for (Object t : iterable2) {
                    EmulatorController it2 = (EmulatorController)t;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)it2.getEmulatorId(), (Object)this.lastSelectedEmulatorId)) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            emulatorController = v2;
        } else {
            emulatorController = null;
        }
        EmulatorController activeEmulator = emulatorController;
        this.lastSelectedEmulatorId = null;
        if (activeEmulator != null && !activeEmulator.isShuttingDown()) {
            this.addEmulatorPanel(activeEmulator);
        }
        for (EmulatorController emulator : this.emulators) {
            if (!(Intrinsics.areEqual((Object)emulator, (Object)activeEmulator) ^ true) || emulator.isShuttingDown()) continue;
            this.addEmulatorPanel(emulator);
        }
        ContentManager contentManager = ((ToolWindowEx)toolWindow).getContentManager();
        if (contentManager.getContentCount() == 0) {
            this.createPlaceholderPanel();
        }
        contentManager.addContentManagerListener((ContentManagerListener)this.contentManagerListener);
        this.viewSelectionChanged(toolWindow);
    }

    private final void destroyContent(ToolWindow toolWindow) {
        if (!this.contentCreated) {
            return;
        }
        this.contentCreated = false;
        EmulatorToolWindowPanel emulatorToolWindowPanel = this.selectedPanel;
        this.lastSelectedEmulatorId = emulatorToolWindowPanel != null ? emulatorToolWindowPanel.getId() : null;
        RunningEmulatorCatalog.Companion.getInstance().removeListener(this);
        for (EmulatorController emulator : this.emulators) {
            emulator.removeConnectionStateListener(this.connectionStateListener);
        }
        this.emulators.clear();
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        contentManager.removeAllContents(true);
        EmulatorToolWindowPanel emulatorToolWindowPanel2 = this.selectedPanel;
        if (emulatorToolWindowPanel2 != null) {
            emulatorToolWindowPanel2.destroyContent();
        }
        this.selectedPanel = null;
        this.panels.clear();
        this.recentLaunches.invalidateAll();
    }

    private final void addEmulatorPanel(EmulatorController emulator) {
        emulator.addConnectionStateListener(this.connectionStateListener);
        EmulatorToolWindowPanel panel2 = new EmulatorToolWindowPanel(emulator);
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        if (this.panels.isEmpty()) {
            contentManager.removeAllContents(true);
            this.showLiveIndicator(toolWindow);
        }
        panel2.setZoomToolbarVisible(this.getZoomToolbarIsVisible());
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent(panel2.getComponent(), panel2.getTitle(), false);
        boolean bl = false;
        boolean bl2 = false;
        Content $this$apply = content2;
        boolean bl3 = false;
        $this$apply.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        $this$apply.setCloseable(true);
        $this$apply.setTabName(panel2.getTitle());
        $this$apply.setIcon(panel2.getIcon());
        $this$apply.setPopupIcon(panel2.getIcon());
        $this$apply.putUserData(this.ID_KEY, (Object)panel2.getId());
        $this$apply.setPreferredFocusedComponent((Computable)new Computable<JComponent>(this, panel2){
            final /* synthetic */ EmulatorToolWindowManager this$0;
            final /* synthetic */ EmulatorToolWindowPanel $panel$inlined;
            {
                this.this$0 = emulatorToolWindowManager;
                this.$panel$inlined = emulatorToolWindowPanel;
            }

            public final JComponent compute() {
                return this.$panel$inlined.getPreferredFocusableComponent();
            }
        });
        Content content3 = content2;
        int index2 = ~CollectionsKt.binarySearch$default(this.panels, (Object)((Object)panel2), PANEL_COMPARATOR, (int)0, (int)0, (int)12, null);
        bl = index2 >= 0;
        bl2 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (index2 >= 0) {
            this.panels.add(index2, panel2);
            contentManager.addContent(content3, index2);
            if (Intrinsics.areEqual((Object)((Object)this.selectedPanel), (Object)((Object)panel2)) ^ true) {
                String avdId = panel2.getId().getAvdId();
                if (this.recentLaunches.getIfPresent((Object)panel2.getId().getAvdId()) != null) {
                    this.recentLaunches.invalidate((Object)avdId);
                    contentManager.setSelectedContent(content3);
                }
            }
        }
    }

    private final void removeEmulatorPanel(EmulatorController emulator) {
        emulator.removeConnectionStateListener(this.connectionStateListener);
        EmulatorToolWindowPanel emulatorToolWindowPanel = this.findPanelByGrpcPort(emulator.getEmulatorId().getGrpcPort());
        if (emulatorToolWindowPanel == null) {
            return;
        }
        EmulatorToolWindowPanel panel2 = emulatorToolWindowPanel;
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        Content content2 = contentManager.getContent(panel2.getComponent());
        contentManager.removeContent(content2, true);
    }

    private final void createPlaceholderPanel() {
        PlaceholderPanel panel2 = new PlaceholderPanel(this.project);
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent((JComponent)((Object)panel2), panel2.getTitle(), false);
        boolean bl = false;
        boolean bl2 = false;
        Content $this$apply = content2;
        boolean bl3 = false;
        $this$apply.setTabName(panel2.getTitle());
        $this$apply.setCloseable(false);
        Content content3 = content2;
        ContentManager contentManager = this.getContentManager();
        contentManager.addContent(content3);
        contentManager.setSelectedContent(content3);
    }

    private final void viewSelectionChanged(ToolWindow toolWindow) {
        Content content2;
        ContentManager contentManager = toolWindow.getContentManager();
        Content content3 = content2 = contentManager.getSelectedContent();
        EmulatorId id = content3 != null ? (EmulatorId)content3.getUserData(this.ID_KEY) : null;
        EmulatorToolWindowPanel emulatorToolWindowPanel = this.selectedPanel;
        if (Intrinsics.areEqual((Object)id, (Object)(emulatorToolWindowPanel != null ? emulatorToolWindowPanel.getId() : null)) ^ true) {
            EmulatorToolWindowPanel emulatorToolWindowPanel2 = this.selectedPanel;
            if (emulatorToolWindowPanel2 != null) {
                emulatorToolWindowPanel2.destroyContent();
            }
            this.selectedPanel = null;
            if (id != null) {
                EmulatorToolWindowPanel emulatorToolWindowPanel3 = this.selectedPanel = this.findPanelByGrpcPort(id.getGrpcPort());
                if (emulatorToolWindowPanel3 != null) {
                    emulatorToolWindowPanel3.createContent(this.getDeviceFrameVisible());
                }
                ToggleToolbarAction.setToolbarVisible((ToolWindow)toolWindow, (PropertiesComponent)PropertiesComponent.getInstance((Project)this.project), null);
            }
        }
    }

    private final EmulatorToolWindowPanel findPanelByGrpcPort(int grpcPort) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EmulatorToolWindowPanel it = (EmulatorToolWindowPanel)((Object)element$iv);
                boolean bl = false;
                if (!(it.getId().getGrpcPort() == grpcPort)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final EmulatorToolWindowPanel findPanelByAvdId(String avdId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.panels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EmulatorToolWindowPanel it = (EmulatorToolWindowPanel)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId().getAvdId(), (Object)avdId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ContentManager getContentManager() {
        return this.getToolWindow().getContentManager();
    }

    private final ToolWindow getToolWindow() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Android Emulator");
        if (toolWindow == null) {
            throw (Throwable)new IllegalStateException("Could not find Emulator tool window");
        }
        return toolWindow;
    }

    private final void showLiveIndicator(ToolWindow toolWindow) {
        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.EMULATOR));
    }

    private final void hideLiveIndicator(ToolWindow toolWindow) {
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.EMULATOR);
    }

    @Override
    @AnyThread
    public void emulatorAdded(@NotNull EmulatorController emulator) {
        if (emulator.getEmulatorId().isEmbedded()) {
            EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this, emulator){
                final /* synthetic */ EmulatorToolWindowManager this$0;
                final /* synthetic */ EmulatorController $emulator;

                public final void invoke() {
                    if (EmulatorToolWindowManager.access$getContentCreated$p(this.this$0) && EmulatorToolWindowManager.access$getEmulators$p(this.this$0).add(this.$emulator)) {
                        EmulatorToolWindowManager.access$addEmulatorPanel(this.this$0, this.$emulator);
                    }
                }
                {
                    this.this$0 = emulatorToolWindowManager;
                    this.$emulator = emulatorController;
                    super(0);
                }
            }));
        }
    }

    @Override
    @AnyThread
    public void emulatorRemoved(@NotNull EmulatorController emulator) {
        if (emulator.getEmulatorId().isEmbedded()) {
            EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this, emulator){
                final /* synthetic */ EmulatorToolWindowManager this$0;
                final /* synthetic */ EmulatorController $emulator;

                public final void invoke() {
                    if (EmulatorToolWindowManager.access$getContentCreated$p(this.this$0) && EmulatorToolWindowManager.access$getEmulators$p(this.this$0).remove(this.$emulator)) {
                        EmulatorToolWindowManager.access$removeEmulatorPanel(this.this$0, this.$emulator);
                    }
                }
                {
                    this.this$0 = emulatorToolWindowManager;
                    this.$emulator = emulatorController;
                    super(0);
                }
            }));
        }
    }

    private final int getSerialPort(IDevice $this$serialPort) {
        boolean bl = $this$serialPort.isEmulator();
        boolean bl2 = false;
        int n = 0;
        n = 0;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int pos = StringsKt.indexOf$default((CharSequence)$this$serialPort.getSerialNumber(), (char)'-', (int)0, (boolean)false, (int)6, null);
        String string = $this$serialPort.getSerialNumber();
        n = pos + 1;
        bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        return StringUtil.parseInt((String)string3, (int)0);
    }

    private EmulatorToolWindowManager(Project project) {
        this.project = project;
        this.ID_KEY = Key.create((String)"emulator-id");
        boolean bl = false;
        this.panels = new ArrayList();
        bl = false;
        this.emulators = new HashSet();
        this.properties = PropertiesComponent.getInstance((Project)this.project);
        this.recentLaunches = CacheBuilder.newBuilder().expireAfterWrite(LAUNCH_INFO_EXPIRATION).build();
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, EmulatorUtilsKt.getEarlyDisposable(this.project));
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ EmulatorToolWindowManager this$0;

            @UiThread
            public void selectionChanged(@NotNull ContentManagerEvent event) {
                EmulatorToolWindowManager.access$viewSelectionChanged(this.this$0, EmulatorToolWindowManager.access$getToolWindow(this.this$0));
            }

            @UiThread
            public void contentRemoved(@NotNull ContentManagerEvent event) {
                JComponent jComponent = event.getContent().getComponent();
                if (!(jComponent instanceof EmulatorToolWindowPanel)) {
                    jComponent = null;
                }
                EmulatorToolWindowPanel emulatorToolWindowPanel = (EmulatorToolWindowPanel)((Object)jComponent);
                if (emulatorToolWindowPanel == null) {
                    return;
                }
                EmulatorToolWindowPanel panel2 = emulatorToolWindowPanel;
                panel2.getEmulator().shutdown();
                EmulatorToolWindowManager.access$getPanels$p(this.this$0).remove((Object)((Object)panel2));
                if (EmulatorToolWindowManager.access$getPanels$p(this.this$0).isEmpty()) {
                    EmulatorToolWindowManager.access$createPlaceholderPanel(this.this$0);
                    EmulatorToolWindowManager.access$hideLiveIndicator(this.this$0, EmulatorToolWindowManager.access$getToolWindow(this.this$0));
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.connectionStateListener = new EmulatorController.ConnectionStateListener(this){
            final /* synthetic */ EmulatorToolWindowManager this$0;

            @AnyThread
            public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
                if (connectionState == EmulatorController.ConnectionState.DISCONNECTED) {
                    EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this, emulator){
                        final /* synthetic */ connectionStateListener.1 this$0;
                        final /* synthetic */ EmulatorController $emulator;

                        public final void invoke() {
                            if (EmulatorToolWindowManager.access$getContentCreated$p(this.this$0.this$0) && EmulatorToolWindowManager.access$getEmulators$p(this.this$0.this$0).remove(this.$emulator)) {
                                EmulatorToolWindowManager.access$removeEmulatorPanel(this.this$0.this$0, this.$emulator);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$emulator = emulatorController;
                            super(0);
                        }
                    }));
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        Disposer.register((Disposable)EmulatorUtilsKt.getEarlyDisposable(this.project), (Disposable)new Disposable(){

            public final void dispose() {
                block0: {
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Android Emulator");
                    if (toolWindow == null) break block0;
                    ToolWindow toolWindow2 = toolWindow;
                    boolean bl = false;
                    boolean bl2 = false;
                    ToolWindow it = toolWindow2;
                    boolean bl3 = false;
                    this.destroyContent(it);
                }
            }
        });
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(EmulatorUtilsKt.getEarlyDisposable(this.project));
        messageBusConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @UiThread
            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow toolWindow = toolWindowManager.getToolWindow("Android Emulator");
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                toolWindowManager.invokeLater(new Runnable(this, toolWindow2){
                    final /* synthetic */ 2 this$0;
                    final /* synthetic */ ToolWindow $toolWindow;

                    public final void run() {
                        if (!EmulatorToolWindowManager.access$getProject$p(this.this$0.this).isDisposed()) {
                            if (this.$toolWindow.isVisible()) {
                                EmulatorToolWindowManager.access$createContent(this.this$0.this, this.$toolWindow);
                            } else {
                                EmulatorToolWindowManager.access$destroyContent(this.this$0.this, this.$toolWindow);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$toolWindow = toolWindow;
                    }
                });
            }
        });
        messageBusConnection.subscribe(AvdLaunchListener.TOPIC, (Object)new AvdLaunchListener(){

            @Override
            public final void avdLaunched(final @NotNull AvdInfo avd, @NotNull GeneralCommandLine commandLine, @Nullable Project project) {
                if (Intrinsics.areEqual((Object)project, (Object)project) && Companion.isEmbeddedEmulator(commandLine)) {
                    RunningEmulatorCatalog.Companion.getInstance().updateNow();
                    EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(){

                        public final void invoke() {
                            this.onEmulatorUsed(avd.getName());
                        }
                    }));
                }
            }
        });
        messageBusConnection.subscribe(AppDeploymentListener.TOPIC, (Object)new AppDeploymentListener(){

            @Override
            public final void appDeployedToDevice(@NotNull IDevice device, @NotNull Project project) {
                if (Intrinsics.areEqual((Object)project, (Object)project) && device.isEmulator()) {
                    this.onDeploymentToEmulator(device);
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        LAUNCH_INFO_EXPIRATION = Duration.ofSeconds(30L);
        COLLATOR = Collator.getInstance();
        Comparator comparator2 = COLLATOR;
        boolean bl = false;
        comparator2 = new Comparator<T>(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = comparator2;
            }

            public final int compare(T a, T b) {
                EmulatorToolWindowPanel it;
                Comparator comparator2 = this.$comparator;
                boolean bl = false;
                EmulatorToolWindowPanel emulatorToolWindowPanel = (EmulatorToolWindowPanel)((Object)a);
                Comparator comparator3 = comparator2;
                boolean bl2 = false;
                String string = it.getTitle();
                it = (EmulatorToolWindowPanel)((Object)b);
                bl2 = false;
                String string2 = it.getTitle();
                return comparator3.compare(string, string2);
            }
        };
        bl = false;
        PANEL_COMPARATOR = new Comparator<T>(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator2;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    EmulatorToolWindowPanel it = (EmulatorToolWindowPanel)((Object)a);
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getId().getGrpcPort());
                    it = (EmulatorToolWindowPanel)((Object)b);
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = Integer.valueOf(it.getId().getGrpcPort());
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        };
        boolean bl2 = false;
        registeredProjects = new HashSet();
    }

    public static final /* synthetic */ void access$onDeploymentToEmulator(EmulatorToolWindowManager $this, IDevice device, Set runningEmulators) {
        $this.onDeploymentToEmulator(device, runningEmulators);
    }

    public static final /* synthetic */ boolean access$getContentCreated$p(EmulatorToolWindowManager $this) {
        return $this.contentCreated;
    }

    public static final /* synthetic */ void access$setContentCreated$p(EmulatorToolWindowManager $this, boolean bl) {
        $this.contentCreated = bl;
    }

    public static final /* synthetic */ Set access$getEmulators$p(EmulatorToolWindowManager $this) {
        return $this.emulators;
    }

    public static final /* synthetic */ void access$addEmulatorPanel(EmulatorToolWindowManager $this, EmulatorController emulator) {
        $this.addEmulatorPanel(emulator);
    }

    public static final /* synthetic */ void access$removeEmulatorPanel(EmulatorToolWindowManager $this, EmulatorController emulator) {
        $this.removeEmulatorPanel(emulator);
    }

    public static final /* synthetic */ void access$viewSelectionChanged(EmulatorToolWindowManager $this, ToolWindow toolWindow) {
        $this.viewSelectionChanged(toolWindow);
    }

    public static final /* synthetic */ ToolWindow access$getToolWindow(EmulatorToolWindowManager $this) {
        return $this.getToolWindow();
    }

    public static final /* synthetic */ List access$getPanels$p(EmulatorToolWindowManager $this) {
        return $this.panels;
    }

    public static final /* synthetic */ void access$createPlaceholderPanel(EmulatorToolWindowManager $this) {
        $this.createPlaceholderPanel();
    }

    public static final /* synthetic */ void access$hideLiveIndicator(EmulatorToolWindowManager $this, ToolWindow toolWindow) {
        $this.hideLiveIndicator(toolWindow);
    }

    public static final /* synthetic */ void access$createContent(EmulatorToolWindowManager $this, ToolWindow toolWindow) {
        $this.createContent(toolWindow);
    }

    public /* synthetic */ EmulatorToolWindowManager(Project project, DefaultConstructorMarker $constructor_marker) {
        this(project);
    }

    @JvmStatic
    public static final void initializeForProject(@NotNull Project project) {
        Companion.initializeForProject(project);
    }

    @JvmStatic
    private static final boolean isEmbeddedEmulator(GeneralCommandLine commandLine) {
        return EmulatorToolWindowManager.Companion.isEmbeddedEmulator(commandLine);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/emulator/EmulatorToolWindowManager$ToggleDeviceFrameAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/android/tools/idea/emulator/EmulatorToolWindowManager;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.emulator"})
    private final class ToggleDeviceFrameAction
    extends ToggleAction
    implements DumbAware {
        public boolean isSelected(@NotNull AnActionEvent event) {
            return EmulatorToolWindowManager.this.getDeviceFrameVisible();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            EmulatorToolWindowManager.this.setDeviceFrameVisible(state);
        }

        public ToggleDeviceFrameAction() {
            super("Show Device Frame");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/emulator/EmulatorToolWindowManager$ToggleZoomToolbarAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/android/tools/idea/emulator/EmulatorToolWindowManager;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.emulator"})
    private final class ToggleZoomToolbarAction
    extends ToggleAction
    implements DumbAware {
        public boolean isSelected(@NotNull AnActionEvent event) {
            return EmulatorToolWindowManager.this.getZoomToolbarIsVisible();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            EmulatorToolWindowManager.this.setZoomToolbarIsVisible(state);
        }

        public ToggleZoomToolbarAction() {
            super("Show Zoom Controls");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0007J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0003R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0002R&\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u00138\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0002R\u000e\u0010\u0015\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/emulator/EmulatorToolWindowManager$Companion;", "", "()V", "COLLATOR", "Ljava/text/Collator;", "kotlin.jvm.PlatformType", "getCOLLATOR$annotations", "DEVICE_FRAME_VISIBLE_DEFAULT", "", "DEVICE_FRAME_VISIBLE_PROPERTY", "", "EMULATOR_DISCOVERY_INTERVAL_MILLIS", "", "LAUNCH_INFO_EXPIRATION", "Ljava/time/Duration;", "getLAUNCH_INFO_EXPIRATION$annotations", "PANEL_COMPARATOR", "Ljava/util/Comparator;", "Lcom/android/tools/idea/emulator/EmulatorToolWindowPanel;", "Lkotlin/Comparator;", "getPANEL_COMPARATOR$annotations", "ZOOM_TOOLBAR_VISIBLE_DEFAULT", "ZOOM_TOOLBAR_VISIBLE_PROPERTY", "registeredProjects", "", "Lcom/intellij/openapi/project/Project;", "getRegisteredProjects$annotations", "initializeForProject", "", "project", "isEmbeddedEmulator", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.android.emulator"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLAUNCH_INFO_EXPIRATION$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getCOLLATOR$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getPANEL_COMPARATOR$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getRegisteredProjects$annotations() {
        }

        @JvmStatic
        public final void initializeForProject(@NotNull Project project) {
            if (registeredProjects.add(project)) {
                Disposer.register((Disposable)EmulatorUtilsKt.getEarlyDisposable(project), (Disposable)new Disposable(project){
                    final /* synthetic */ Project $project;

                    public final void dispose() {
                        EmulatorToolWindowManager.access$getRegisteredProjects$cp().remove(this.$project);
                    }
                    {
                        this.$project = project;
                    }
                });
                new EmulatorToolWindowManager(project, null);
            }
        }

        @JvmStatic
        private final boolean isEmbeddedEmulator(GeneralCommandLine commandLine) {
            return commandLine.getParametersList().getParameters().contains("-qt-hide-window");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

