/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final ConfigurationManager myManager;
    @NotNull
    private final ResourceReference myStyleReference;

    public ThemeEditorStyle(@NotNull ConfigurationManager manager, @NotNull ResourceReference styleReference) {
        this.myManager = manager;
        this.myStyleReference = styleReference;
    }

    @NotNull
    public final ResourceReference getStyleReference() {
        return this.myStyleReference;
    }

    @NotNull
    public String getQualifiedName() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myManager.getModule());
        if (repositoryManager == null || repositoryManager.getNamespace().equals((Object)this.myStyleReference.getNamespace())) {
            return this.myStyleReference.getName();
        }
        return this.myStyleReference.getQualifiedName();
    }

    @NotNull
    public String getName() {
        return this.myStyleReference.getName();
    }

    public boolean isFramework() {
        return this.myStyleReference.getNamespace().equals((Object)ResourceNamespace.ANDROID);
    }

    public boolean isProjectStyle() {
        if (this.isFramework()) {
            return false;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myManager.getModule());
        assert (repositoryManager != null);
        LocalResourceRepository repository = repositoryManager.getProjectResources();
        return repository.hasResources(this.myStyleReference.getNamespace(), this.myStyleReference.getResourceType(), this.myStyleReference.getName());
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target = this.myManager.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myManager.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getName());
    }
}

