/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceRepository {
    private final Map<VirtualFile, LocalResourceRepository> myResourceDirectoryRepositoryMap;
    private final LocalResourceRepository myDynamicResourceRepository;

    private StringResourceRepository(@NotNull MultiResourceRepository parent) {
        ImmutableList<LocalResourceRepository> localResources = parent.getLocalResources();
        LinkedHashMap resourceDirectoryRepositoryMap = Maps.newLinkedHashMapWithExpectedSize((int)localResources.size());
        LocalResourceRepository dynamicResourceRepository = null;
        for (LocalResourceRepository child : localResources) {
            if (child instanceof ResourceFolderRepository) {
                ResourceFolderRepository repository = (ResourceFolderRepository)child;
                ReadAction.run(() -> repository.scanRecursively(StringResourceRepository::isDirectoryOrStringResourceFile));
                resourceDirectoryRepositoryMap.put(repository.getResourceDir(), child);
                continue;
            }
            assert (dynamicResourceRepository == null);
            dynamicResourceRepository = child;
        }
        this.myResourceDirectoryRepositoryMap = resourceDirectoryRepositoryMap;
        this.myDynamicResourceRepository = dynamicResourceRepository;
    }

    private StringResourceRepository(@NotNull ResourceFolderRepository repository) {
        ReadAction.run(() -> repository.scanRecursively(StringResourceRepository::isDirectoryOrStringResourceFile));
        this.myResourceDirectoryRepositoryMap = Collections.singletonMap(repository.getResourceDir(), repository);
        this.myDynamicResourceRepository = null;
    }

    private StringResourceRepository(@NotNull LocalResourceRepository repository) {
        repository.sync();
        this.myResourceDirectoryRepositoryMap = Collections.emptyMap();
        this.myDynamicResourceRepository = repository;
    }

    private static boolean isDirectoryOrStringResourceFile(@NotNull VirtualFile file2) {
        return file2.isDirectory() || file2.getName().equals("strings.xml");
    }

    @NotNull
    public static StringResourceRepository empty() {
        return new StringResourceRepository(new LocalResourceRepository.EmptyRepository(ResourceNamespace.RES_AUTO));
    }

    @NotNull
    static StringResourceRepository create(@NotNull LocalResourceRepository repository) {
        if (repository instanceof MultiResourceRepository) {
            return new StringResourceRepository((MultiResourceRepository)repository);
        }
        if (repository instanceof ResourceFolderRepository) {
            return new StringResourceRepository((ResourceFolderRepository)repository);
        }
        return new StringResourceRepository(repository);
    }

    @NotNull
    final Stream<StringResourceKey> getKeys() {
        Set<Map.Entry<VirtualFile, LocalResourceRepository>> entries = this.myResourceDirectoryRepositoryMap.entrySet();
        Stream<StringResourceKey> resourceDirectoryKeys = entries.stream().flatMap(StringResourceRepository::getKeys);
        if (this.myDynamicResourceRepository == null) {
            return resourceDirectoryKeys;
        }
        Set<String> names = this.myDynamicResourceRepository.getResourceNames(ResourceNamespace.TODO(), ResourceType.STRING);
        Stream<StringResourceKey> dynamicResourceKeys = names.stream().map(name -> new StringResourceKey((String)name, null));
        return Stream.concat(resourceDirectoryKeys, dynamicResourceKeys);
    }

    @NotNull
    private static Stream<StringResourceKey> getKeys(@NotNull Map.Entry<VirtualFile, LocalResourceRepository> entry) {
        VirtualFile directory = entry.getKey();
        return entry.getValue().getResources(ResourceNamespace.TODO(), ResourceType.STRING).keySet().stream().map(name -> new StringResourceKey((String)name, directory));
    }

    @NotNull
    public Collection<ResourceItem> getItems(@NotNull StringResourceKey key) {
        return StringResourceRepository.getItems(this.getRepository(key), key);
    }

    @Nullable
    final ResourceItem getDefaultValue(@NotNull StringResourceKey key) {
        return this.getItem(key, item -> item.getConfiguration().getLocaleQualifier() == null);
    }

    @Nullable
    final ResourceItem getTranslation(@NotNull StringResourceKey key, @NotNull Locale locale) {
        return this.getItem(key, item -> StringResourceRepository.localeEquals((Configurable)item, locale));
    }

    private static boolean localeEquals(@NotNull Configurable item, @NotNull Locale locale) {
        LocaleQualifier qualifier = item.getConfiguration().getLocaleQualifier();
        return qualifier != null && Locale.create(qualifier).equals(locale);
    }

    @Nullable
    private ResourceItem getItem(@NotNull StringResourceKey key, @NotNull Predicate<ResourceItem> predicate2) {
        LocalResourceRepository repository = this.getRepository(key);
        Optional<ResourceItem> optionalItem = StringResourceRepository.getItems(repository, key).stream().filter(predicate2).findFirst();
        return optionalItem.orElse(null);
    }

    @NotNull
    private LocalResourceRepository getRepository(@NotNull StringResourceKey key) {
        VirtualFile directory = key.getDirectory();
        return directory == null ? this.myDynamicResourceRepository : this.myResourceDirectoryRepositoryMap.get(directory);
    }

    @NotNull
    private static Collection<ResourceItem> getItems(@NotNull LocalResourceRepository repository, @NotNull StringResourceKey key) {
        repository.sync();
        return repository.getResources(ResourceNamespace.TODO(), ResourceType.STRING, key.getName());
    }
}

