/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceEditor
extends UserDataHolderBase
implements FileEditor {
    public static final Icon ICON = StudioIcons.LayoutEditor.Toolbar.LANGUAGE;
    public static final String NAME = "String Resource Editor";
    private StringResourceViewPanel myPanel;

    StringResourceEditor(@NotNull StringsVirtualFile file2) {
        AndroidFacet facet2 = file2.getFacet();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.myPanel = new StringResourceViewPanel(facet2, (Disposable)this);
            return this.myPanel;
        });
    }

    @NotNull
    public static Font getFont(@NotNull Font defaultFont) {
        return JBFont.create((Font)new Font("Dialog", 0, defaultFont.getSize()), (!(defaultFont instanceof JBFont) ? 1 : 0) != 0);
    }

    @NotNull
    public StringResourceViewPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel.getLoadingPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @NotNull
    public String toString() {
        return "StringResourceEditor " + this.myPanel.getFacet() + " " + System.identityHashCode((Object)this);
    }
}

