/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.StringResourceUnescaper;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringPsiUtils;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.VirtualFiles;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.DynamicValueResourceItem;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.PsiResourceItem;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResource {
    @NotNull
    private final StringResourceKey myKey;
    @NotNull
    private final String myResourceFolder;
    private boolean myTranslatable;
    @NotNull
    private ResourceItemEntry myDefaultValue;
    @NotNull
    private final Map<Locale, ResourceItemEntry> myLocaleToTranslationMap;
    @NotNull
    private final StringResourceData myData;

    public StringResource(@NotNull StringResourceKey key, @NotNull StringResourceData data) {
        Project project = data.getProject();
        boolean translatable = true;
        ResourceItemEntry defaultValue2 = new ResourceItemEntry();
        StringResourceUnescaper unescaper = data.getUnescaper();
        HashMap<Locale, ResourceItemEntry> localeToTranslationMap = new HashMap<Locale, ResourceItemEntry>();
        for (ResourceItem item : data.getRepository().getItems(key)) {
            LocaleQualifier qualifier;
            XmlTag tag;
            if (!(item instanceof PsiResourceItem) && !(item instanceof DynamicValueResourceItem)) {
                Logger.getInstance(StringResource.class).warn(item + " has an unexpected class " + item.getClass().getName());
            }
            if ((tag = IdeResourcesUtil.getItemTag(project, item)) != null && "false".equals(tag.getAttributeValue("translatable"))) {
                translatable = false;
            }
            if ((qualifier = item.getConfiguration().getLocaleQualifier()) == null) {
                defaultValue2 = new ResourceItemEntry(item, unescaper);
                continue;
            }
            localeToTranslationMap.put(Locale.create(qualifier), new ResourceItemEntry(item, unescaper));
        }
        this.myKey = key;
        VirtualFile folder = key.getDirectory();
        this.myResourceFolder = folder == null ? "" : VirtualFiles.toString(folder, project);
        this.myTranslatable = translatable;
        this.myDefaultValue = defaultValue2;
        this.myLocaleToTranslationMap = localeToTranslationMap;
        this.myData = data;
    }

    @NotNull
    StringResourceKey getKey() {
        return this.myKey;
    }

    @NotNull
    public String getResourceFolder() {
        return this.myResourceFolder;
    }

    @Nullable
    ResourceItem getDefaultValueAsResourceItem() {
        return this.myDefaultValue.myResourceItem;
    }

    @NotNull
    public String getDefaultValueAsString() {
        return this.myDefaultValue.myString;
    }

    public boolean setDefaultValue(@NotNull String defaultValue2) {
        if (this.myDefaultValue.myResourceItem == null) {
            ResourceItem item = this.createDefaultValue(defaultValue2);
            if (item == null) {
                return false;
            }
            this.myDefaultValue = new ResourceItemEntry(item, this.myData.getUnescaper());
            return true;
        }
        if (this.myDefaultValue.myString.equals(defaultValue2)) {
            return false;
        }
        boolean changed = StringsWriteUtils.setItemText(this.myData.getProject(), this.myDefaultValue.myResourceItem, defaultValue2);
        if (!changed) {
            return false;
        }
        if (defaultValue2.isEmpty()) {
            this.myDefaultValue = new ResourceItemEntry();
            return true;
        }
        ResourceItem item = this.myData.getRepository().getDefaultValue(this.myKey);
        assert (item != null);
        this.myDefaultValue = new ResourceItemEntry(item, this.myData.getUnescaper());
        return true;
    }

    @Nullable
    private ResourceItem createDefaultValue(@NotNull String value2) {
        if (value2.isEmpty()) {
            return null;
        }
        Project project = this.myData.getProject();
        XmlFile file2 = StringPsiUtils.getDefaultStringResourceFile(project, this.myKey);
        if (file2 == null) {
            return null;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> StringPsiUtils.addString(file2, this.myKey, this.myTranslatable, value2), (PsiFile[])new PsiFile[0]);
        return this.myData.getRepository().getDefaultValue(this.myKey);
    }

    @Nullable
    public String validateDefaultValue() {
        if (this.myDefaultValue.myResourceItem == null) {
            return "Key \"" + this.myKey.getName() + "\" is missing its default value";
        }
        if (!this.myDefaultValue.myStringValid) {
            return "Invalid XML";
        }
        return null;
    }

    public boolean isTranslatable() {
        return this.myTranslatable;
    }

    public void setTranslatable(boolean translatable) {
        this.myTranslatable = translatable;
    }

    @Nullable
    ResourceItem getTranslationAsResourceItem(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        return resourceItemEntry == null ? null : resourceItemEntry.myResourceItem;
    }

    @NotNull
    public String getTranslationAsString(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        return resourceItemEntry == null ? "" : resourceItemEntry.myString;
    }

    public boolean putTranslation(@NotNull Locale locale, @NotNull String translation) {
        if (this.getTranslationAsResourceItem(locale) == null) {
            ResourceItem item = this.createTranslation(locale, translation);
            if (item == null) {
                return false;
            }
            this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(item, this.myData.getUnescaper()));
            return true;
        }
        if (this.getTranslationAsString(locale).equals(translation)) {
            return false;
        }
        ResourceItem item = this.getTranslationAsResourceItem(locale);
        assert (item != null);
        boolean changed = StringsWriteUtils.setItemText(this.myData.getProject(), item, translation);
        if (!changed) {
            return false;
        }
        if (translation.isEmpty()) {
            this.myLocaleToTranslationMap.remove(locale);
            return true;
        }
        item = this.myData.getRepository().getTranslation(this.myKey, locale);
        assert (item != null);
        this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(item, this.myData.getUnescaper()));
        return true;
    }

    @Nullable
    private ResourceItem createTranslation(@NotNull Locale locale, @NotNull String value2) {
        if (value2.isEmpty()) {
            return null;
        }
        Project project = this.myData.getProject();
        XmlFile file2 = StringPsiUtils.getStringResourceFile(project, this.myKey, locale);
        if (file2 == null) {
            return null;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> StringPsiUtils.addString(file2, this.myKey, this.myTranslatable, value2), (PsiFile[])new PsiFile[0]);
        return this.myData.getRepository().getTranslation(this.myKey, locale);
    }

    @Nullable
    public String validateTranslation(@NotNull Locale locale) {
        ResourceItemEntry entry = this.myLocaleToTranslationMap.get(locale);
        if (entry != null && !entry.myStringValid) {
            return "Invalid XML";
        }
        if (this.myTranslatable && this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is missing its " + LocaleMenuAction.getLocaleLabel(locale, false) + " translation";
        }
        if (!this.myTranslatable && !this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is untranslatable and should not be translated to " + LocaleMenuAction.getLocaleLabel(locale, false);
        }
        return null;
    }

    @NotNull
    Collection<Locale> getTranslatedLocales() {
        return this.myLocaleToTranslationMap.keySet();
    }

    boolean isTranslationMissing(@NotNull Locale locale) {
        ResourceItemEntry item = this.myLocaleToTranslationMap.get(locale);
        if (StringResource.isTranslationMissing(item) && locale.hasRegion()) {
            String language = locale.qualifier.getLanguage();
            assert (language != null);
            locale = Locale.create(language);
            item = this.myLocaleToTranslationMap.get(locale);
        }
        return StringResource.isTranslationMissing(item);
    }

    private static boolean isTranslationMissing(@Nullable ResourceItemEntry item) {
        return item == null || item.myString.isEmpty();
    }

    private static final class ResourceItemEntry {
        @Nullable
        private final ResourceItem myResourceItem;
        @NotNull
        private final String myString;
        private final boolean myStringValid;

        private ResourceItemEntry() {
            this.myResourceItem = null;
            this.myString = "";
            this.myStringValid = true;
        }

        private ResourceItemEntry(@NotNull ResourceItem resourceItem, @NotNull StringResourceUnescaper unescaper) {
            boolean stringValid;
            this.myResourceItem = resourceItem;
            ResourceValue value2 = resourceItem.getResourceValue();
            if (value2 == null) {
                this.myString = "";
                this.myStringValid = true;
                return;
            }
            String string = value2.getRawXmlValue();
            assert (string != null);
            try {
                string = unescaper.unescapeCharacterData(string);
                stringValid = true;
            }
            catch (IllegalArgumentException exception) {
                stringValid = false;
            }
            this.myString = string;
            this.myStringValid = stringValid;
        }
    }
}

