/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import java.awt.Point;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;

final class RemoveLocaleMouseListener
implements FrozenColumnTableListener {
    private final StringResourceViewPanel myPanel;

    RemoveLocaleMouseListener(@NotNull StringResourceViewPanel panel2) {
        this.myPanel = panel2;
    }

    @Override
    public void headerPopupTriggered(@NotNull FrozenColumnTableEvent event) {
        Locale locale = ((StringResourceTableModel)event.getSource().getModel()).getLocale(event.getModelColumnIndex());
        if (locale == null) {
            return;
        }
        JBMenuItem item = new JBMenuItem("Remove Locale");
        item.setName("removeLocaleMenuItem");
        item.addActionListener(e -> {
            StringsWriteUtils.removeLocale(locale, this.myPanel.getFacet(), this);
            this.myPanel.reloadData();
        });
        JBPopupMenu menu = new JBPopupMenu();
        menu.add((JMenuItem)item);
        Point point = event.getPoint();
        menu.show(event.getSubcomponent(), point.x, point.y);
    }
}

