/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.repository.GradleVersion;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.tools.adtui.workbench.WorkBenchLoadingPanel;
import com.android.tools.idea.editors.manifest.AnnotationColors;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.BuildTypeModel;
import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.utils.FileUtils;
import com.android.utils.HtmlBuilder;
import com.android.utils.PositionXmlParser;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestPanel
extends JPanel
implements TreeSelectionListener {
    private static final String SUGGESTION_MARKER = "Suggestion: ";
    private static final Pattern ADD_SUGGESTION_FORMAT = Pattern.compile(".*? 'tools:([\\w:]+)=\"([\\w:]+)\"' to \\<(\\w+)\\> element at [^:]+:(\\d+):(\\d+)-[\\d:]+ to override\\.", 32);
    private static final Pattern NAV_FILE_PATTERN = Pattern.compile(".*/navigation(-[^/]*)?/[^/]*$");
    private static final File GRADLE_MODEL_MARKER_FILE = new File("build.gradle");
    private final AndroidFacet myFacet;
    private final Font myDefaultFont;
    private final Tree myTree;
    private final JEditorPane myDetails;
    private final WorkBenchLoadingPanel myLoadingPanel;
    private final JBSplitter mySplitter;
    private JPopupMenu myPopup;
    private JMenuItem myRemoveItem;
    private MergedManifestSnapshot myManifest;
    private boolean myManifestEditable;
    private final List<File> myFiles = new ArrayList<File>();
    private final List<File> myOtherFiles = new ArrayList<File>();
    private final HtmlLinkManager myHtmlLinkManager = new HtmlLinkManager();
    private VirtualFile myFile;
    private final Color myBackgroundColor;
    private static final Comparator<File> MANIFEST_SORTER = (o1, o2) -> {
        boolean lib2;
        String p1 = o1.getPath();
        String p2 = o2.getPath();
        boolean lib1 = p1.contains("exploded-aar");
        if (lib1 != (lib2 = p2.contains("exploded-aar"))) {
            return lib1 ? 1 : -1;
        }
        return p1.compareTo(p2);
    };

    public ManifestPanel(@NotNull AndroidFacet facet2, @NotNull Disposable parent) {
        this.myFacet = facet2;
        this.setLayout(new BorderLayout());
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        this.myBackgroundColor = scheme.getDefaultBackground();
        this.myDefaultFont = scheme.getFont(EditorFontType.PLAIN);
        this.myTree = new FileColorTree();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new SyntaxHighlightingCellRenderer()));
        TreeSelectionModel selectionModel = this.myTree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        selectionModel.addTreeSelectionListener(this);
        this.myDetails = this.createDetailsPane(facet2);
        this.addSpeedSearch();
        this.createPopupMenu();
        this.registerGotoAction();
        this.mySplitter = new JBSplitter(0.5f);
        this.mySplitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myTree));
        this.mySplitter.setSecondComponent((JComponent)new JBScrollPane((Component)this.myDetails));
        this.myLoadingPanel = new WorkBenchLoadingPanel((LayoutManager)new BorderLayout(), parent, 0);
        this.myLoadingPanel.add((Component)this.mySplitter);
        this.add((Component)this.myLoadingPanel);
    }

    @NotNull
    public JEditorPane getDetailsPane() {
        return this.myDetails;
    }

    @NotNull
    public Tree getTree() {
        return this.myTree;
    }

    private JEditorPane createDetailsPane(@NotNull AndroidFacet facet2) {
        JEditorPane details = new JEditorPane();
        details.setMargin((Insets)JBUI.insets((int)5));
        details.setEditorKit(UIUtil.getHTMLEditorKit());
        details.setEditable(false);
        details.setFont(this.myDefaultFont);
        details.setBackground(this.myBackgroundColor);
        HyperlinkListener hyperLinkListener = e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = e.getDescription();
                this.myHtmlLinkManager.handleUrl(url, facet2.getModule(), null, null, null, null);
            }
        };
        details.addHyperlinkListener(hyperLinkListener);
        return details;
    }

    private void createPopupMenu() {
        this.myPopup = new JBPopupMenu();
        JBMenuItem gotoItem = new JBMenuItem("Go to Declaration");
        gotoItem.addActionListener(e -> {
            TreePath treePath = this.myTree.getSelectionPath();
            ManifestTreeNode node2 = (ManifestTreeNode)treePath.getLastPathComponent();
            if (node2 != null) {
                this.goToDeclaration(node2.getUserObject());
            }
        });
        this.myPopup.add((JMenuItem)gotoItem);
        this.myRemoveItem = new JBMenuItem("Remove");
        this.myRemoveItem.addActionListener(e -> {
            TreePath treePath = this.myTree.getSelectionPath();
            final ManifestTreeNode node2 = (ManifestTreeNode)treePath.getLastPathComponent();
            new WriteCommandAction.Simple(this.myFacet.getModule().getProject(), "Removing manifest tag", new PsiFile[]{ManifestUtils.getMainManifest(this.myFacet)}){

                protected void run() throws Throwable {
                    ManifestUtils.toolsRemove(ManifestUtils.getMainManifest(ManifestPanel.this.myFacet), node2.getUserObject());
                }
            }.execute();
        });
        this.myPopup.add(this.myRemoveItem);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ManifestTreeNode node2;
                Node attribute;
                TreePath treePath;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && (attribute = (node2 = (ManifestTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof Attr) {
                    ManifestPanel.this.goToDeclaration(attribute);
                }
            }

            private void handlePopup(@NotNull MouseEvent e) {
                TreePath treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (treePath == null || e.getSource() == ManifestPanel.this.myDetails) {
                    treePath = ManifestPanel.this.myTree.getSelectionPath();
                }
                if (treePath != null) {
                    ManifestTreeNode node2 = (ManifestTreeNode)treePath.getLastPathComponent();
                    ManifestPanel.this.myRemoveItem.setEnabled(ManifestPanel.this.canRemove(node2.getUserObject()));
                    ManifestPanel.this.myPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)ml);
        this.myDetails.addMouseListener(ml);
    }

    private void registerGotoAction() {
        AnAction goToDeclarationAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ManifestTreeNode node2 = (ManifestTreeNode)ManifestPanel.this.myTree.getLastSelectedPathComponent();
                if (node2 != null) {
                    ManifestPanel.this.goToDeclaration(node2.getUserObject());
                }
            }
        };
        goToDeclarationAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("GotoDeclaration").getShortcutSet(), (JComponent)this.myTree);
    }

    @NotNull
    private TreeSpeedSearch addSpeedSearch() {
        return new TreeSpeedSearch((JTree)this.myTree);
    }

    public void startLoading() {
        this.mySplitter.setVisible(false);
        this.myLoadingPanel.setLoadingText("Computing merged manifest...");
        this.myLoadingPanel.startLoading();
    }

    public void showLoadingError() {
        this.myLoadingPanel.abortLoading("Unable to compute merged manifest.", AllIcons.General.Warning);
    }

    public void showManifest(MergedManifestSnapshot manifest, @NotNull VirtualFile selectedManifest, boolean isEditable) {
        this.myManifestEditable = isEditable;
        this.setManifestSnapshot(manifest, selectedManifest);
        this.myLoadingPanel.stopLoading();
        this.mySplitter.setVisible(true);
    }

    private void setManifestSnapshot(@NotNull MergedManifestSnapshot manifest, @NotNull VirtualFile selectedManifest) {
        this.myFile = selectedManifest;
        this.myManifest = manifest;
        Document document = this.myManifest.getDocument();
        Element root2 = document != null ? document.getDocumentElement() : null;
        this.myTree.setModel((TreeModel)(root2 == null ? null : new DefaultTreeModel(new ManifestTreeNode(root2))));
        this.myFiles.clear();
        this.myOtherFiles.clear();
        List<VirtualFile> manifestFiles = this.myManifest.getManifestFiles();
        this.myFiles.add(VfsUtilCore.virtualToIoFile((VirtualFile)selectedManifest));
        HashSet referenced = Sets.newHashSet();
        if (root2 != null) {
            this.recordLocationReferences(root2, referenced);
        }
        for (VirtualFile f : manifestFiles) {
            if (f.equals(selectedManifest)) continue;
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)f);
            if (referenced.contains(file2)) {
                this.myFiles.add(file2);
                continue;
            }
            this.myOtherFiles.add(file2);
        }
        Collections.sort(this.myFiles, MANIFEST_SORTER);
        Collections.sort(this.myOtherFiles, MANIFEST_SORTER);
        if (referenced.contains(GRADLE_MODEL_MARKER_FILE)) {
            this.myFiles.add(GRADLE_MODEL_MARKER_FILE);
        }
        if (root2 != null) {
            TreeUtil.expandAll((JTree)this.myTree);
        }
        this.updateDetails(null);
    }

    private void recordLocationReferences(@NotNull Node node2, @NotNull Set<File> files2) {
        block4: {
            short type;
            block3: {
                Actions.Record record;
                block5: {
                    XmlNode.NodeKey targetId;
                    type = node2.getNodeType();
                    if (type != 2) break block3;
                    List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node2);
                    if (records.isEmpty() || !(targetId = (record = records.get(0)).getTargetId()).toString().contains("@")) break block4;
                    if (record.getActionType() != Actions.ActionType.INJECTED) break block5;
                    files2.add(GRADLE_MODEL_MARKER_FILE);
                    break block4;
                }
                File location = record.getActionLocation().getFile().getSourceFile();
                if (location == null || files2.contains(location)) break block4;
                files2.add(location);
                break block4;
            }
            if (type == 1) {
                for (Node child = node2.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1) continue;
                    this.recordLocationReferences(child, files2);
                }
                NamedNodeMap attributes = node2.getAttributes();
                int n = attributes.getLength();
                for (int i2 = 0; i2 < n; ++i2) {
                    this.recordLocationReferences(attributes.item(i2), files2);
                }
            }
        }
    }

    @Override
    public void valueChanged(@Nullable TreeSelectionEvent e) {
        if (e != null && e.isAddedPath()) {
            TreePath treePath = e.getPath();
            ManifestTreeNode node2 = (ManifestTreeNode)treePath.getLastPathComponent();
            this.updateDetails(node2);
        } else {
            this.updateDetails(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateDetails(@Nullable ManifestTreeNode node2) {
        HtmlBuilder sb = new HtmlBuilder();
        Font font = UIUtil.getLabelFont();
        sb.addHtml("<html><body style=\"font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt;\">");
        sb.beginUnderline().beginBold();
        sb.add("Manifest Sources");
        sb.endBold().endUnderline().newline();
        sb.addHtml("<table border=\"0\">");
        String borderColor = ColorUtil.toHex((Color)JBColor.GRAY);
        for (File file2 : this.myFiles) {
            Color color = this.getFileColor(file2);
            sb.addHtml("<tr><td width=\"24\" height=\"24\" style=\"background-color:#");
            sb.addHtml(ColorUtil.toHex((Color)color));
            sb.addHtml("; border: 1px solid #");
            sb.addHtml(borderColor);
            sb.addHtml(";\">");
            sb.addHtml("</td><td>");
            this.describePosition(sb, this.myFacet, new SourceFilePosition(file2, SourcePosition.UNKNOWN));
            sb.addHtml("</td></tr>");
        }
        sb.addHtml("</table>");
        sb.newline();
        if (!this.myOtherFiles.isEmpty()) {
            sb.beginUnderline().beginBold();
            sb.add("Other Manifest Files");
            sb.endBold().endUnderline().newline();
            sb.add("(Included in merge, but did not contribute any elements)").newline();
            boolean first = true;
            for (File file3 : this.myOtherFiles) {
                if (first) {
                    first = false;
                } else {
                    sb.add(", ");
                }
                this.describePosition(sb, this.myFacet, new SourceFilePosition(file3, SourcePosition.UNKNOWN));
            }
            sb.newline().newline();
        }
        if (!this.myManifest.getLoggingRecords().isEmpty()) {
            for (MergingReport.Record record : this.myManifest.getLoggingRecords()) {
                if (record.getSeverity() != MergingReport.Record.Severity.ERROR) continue;
                node2 = null;
                break;
            }
        }
        if (node2 != null) {
            List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node2.getUserObject());
            sb.beginUnderline().beginBold();
            sb.add("Merging Log");
            sb.endBold().endUnderline().newline();
            if (records.isEmpty()) {
                sb.add("No records found. (This is a bug in the manifest merger.)");
            }
            Object var6_12 = null;
            boolean prevInjected = false;
            for (Actions.Record record : records) {
                boolean injected;
                void var6_13;
                SourceFilePosition location = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
                if (location.equals((Object)var6_13)) continue;
                SourceFilePosition sourceFilePosition = location;
                Actions.ActionType actionType = record.getActionType();
                boolean bl = injected = actionType == Actions.ActionType.INJECTED;
                if (injected && prevInjected) continue;
                prevInjected = injected;
                if (injected) {
                    sb.add("Value provided by Gradle");
                    sb.newline();
                    continue;
                }
                sb.add(StringUtil.capitalize((String)StringUtil.toLowerCase((String)String.valueOf(actionType))));
                sb.add(" from the ");
                sb.addHtml(this.getHtml(this.myFacet, location));
                String reason = record.getReason();
                if (reason != null) {
                    sb.add("; reason: ");
                    sb.add(reason);
                }
                sb.newline();
            }
        } else if (!this.myManifest.getLoggingRecords().isEmpty()) {
            sb.add("Merging Errors:").newline();
            for (MergingReport.Record record : this.myManifest.getLoggingRecords()) {
                sb.addHtml(ManifestPanel.getHtml(record.getSeverity()));
                sb.add(" ");
                try {
                    sb.addHtml(ManifestPanel.getErrorHtml(this.myFacet, record.getMessage(), record.getSourceLocation(), this.myHtmlLinkManager, LocalFileSystem.getInstance().findFileByIoFile(this.myFiles.get(0)), this.myManifestEditable));
                }
                catch (Exception ex) {
                    Logger.getInstance(ManifestPanel.class).error("error getting error html", (Throwable)ex);
                    sb.add(record.getMessage());
                }
                sb.add(" ");
                sb.addHtml(this.getHtml(this.myFacet, record.getSourceLocation()));
                sb.newline();
            }
        }
        sb.closeHtmlBody();
        this.myDetails.setText(sb.getHtml());
        this.myDetails.setCaretPosition(0);
    }

    @NotNull
    private Color getNodeColor(@NotNull Node node2) {
        Actions.Record record;
        File file2;
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node2);
        if (!records.isEmpty() && (file2 = (record = records.get(0)).getActionType() == Actions.ActionType.INJECTED ? GRADLE_MODEL_MARKER_FILE : ManifestUtils.getActionLocation(this.myFacet.getModule(), record).getFile().getSourceFile()) != null) {
            return this.getFileColor(file2);
        }
        return this.myBackgroundColor;
    }

    @NotNull
    private Color getFileColor(@NotNull File file2) {
        int index2;
        if (!this.myFiles.contains(file2)) {
            this.myFiles.add(file2);
        }
        if ((index2 = this.myFiles.indexOf(file2)) == 0) {
            return this.myBackgroundColor;
        }
        return AnnotationColors.BG_COLORS[(index2 - 1) * 3 % AnnotationColors.BG_COLORS.length];
    }

    private boolean canRemove(@NotNull Node node2) {
        if (!this.myManifestEditable) {
            return false;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node2);
        if (records.isEmpty()) {
            return false;
        }
        File mainManifest = VfsUtilCore.virtualToIoFile((VirtualFile)ManifestUtils.getMainManifest(this.myFacet).getVirtualFile());
        for (Actions.Record record : records) {
            if (!FileUtil.filesEqual((File)ManifestUtils.getActionLocation(this.myFacet.getModule(), record).getFile().getSourceFile(), (File)mainManifest)) continue;
            return false;
        }
        return true;
    }

    private void goToDeclaration(Node element2) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, element2);
        for (Actions.Record record : records) {
            File ioFile;
            SourceFilePosition sourceFilePosition = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
            SourceFile sourceFile = sourceFilePosition.getFile();
            if (SourceFile.UNKNOWN.equals((Object)sourceFile) || (ioFile = sourceFile.getSourceFile()) == null) continue;
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            assert (file2 != null);
            int line2 = -1;
            int column = 0;
            SourcePosition sourcePosition = sourceFilePosition.getPosition();
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                line2 = sourcePosition.getStartLine();
                column = sourcePosition.getStartColumn();
            }
            Project project = this.myFacet.getModule().getProject();
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, line2, column);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
            break;
        }
    }

    @NotNull
    static String getErrorHtml(@NotNull AndroidFacet facet2, @NotNull String message2, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile, boolean manifestEditable) {
        HtmlBuilder sb = new HtmlBuilder();
        int index2 = message2.indexOf(SUGGESTION_MARKER);
        if (manifestEditable && index2 >= 0) {
            String action2 = message2.substring(index2 += SUGGESTION_MARKER.length(), message2.indexOf(32, index2));
            sb.add(message2.substring(0, index2));
            message2 = message2.substring(index2);
            if ("add".equals(action2)) {
                sb.addHtml(ManifestPanel.getErrorAddHtml(facet2, message2, position, htmlLinkManager, currentlyOpenFile));
            } else if ("use".equals(action2)) {
                sb.addHtml(ManifestPanel.getErrorUseHtml(facet2, message2, position, htmlLinkManager, currentlyOpenFile));
            } else if ("remove".equals(action2)) {
                sb.addHtml(ManifestPanel.getErrorRemoveHtml(facet2, message2, position, htmlLinkManager, currentlyOpenFile));
            }
        } else {
            sb.add(message2);
        }
        return sb.getHtml();
    }

    @NotNull
    private static String getErrorAddHtml(@NotNull AndroidFacet facet2, @NotNull String message2, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        HtmlBuilder sb = new HtmlBuilder();
        Matcher matcher = ADD_SUGGESTION_FORMAT.matcher(message2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unexpected add suggestion format " + message2);
        }
        String attributeName = matcher.group(1);
        String attributeValue = matcher.group(2);
        String tagName = matcher.group(3);
        int line2 = Integer.parseInt(matcher.group(4));
        int col = Integer.parseInt(matcher.group(5));
        XmlFile mainManifest = ManifestUtils.getMainManifest(facet2);
        Element element2 = ManifestPanel.getElementAt(mainManifest, line2, col);
        if (element2 != null && tagName.equals(element2.getTagName())) {
            Element xmlTag = element2;
            sb.addLink(message2, htmlLinkManager.createRunnableLink(() -> ManifestPanel.addToolsAttribute(mainManifest, xmlTag, attributeName, attributeValue)));
        } else {
            Logger.getInstance(ManifestPanel.class).warn("can not find " + tagName + " tag " + element2);
            sb.add(message2);
        }
        return sb.getHtml();
    }

    @Nullable
    private static Element getElementAt(XmlFile mainManifest, int line2, int col) {
        Element element2 = null;
        try {
            Document document = PositionXmlParser.parse((String)mainManifest.getText());
            for (Node node2 = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)line2, (int)col); node2 != null; node2 = node2.getParentNode()) {
                if (!(node2 instanceof Element)) continue;
                element2 = (Element)node2;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element2;
    }

    @NotNull
    private static String getErrorUseHtml(@NotNull AndroidFacet facet2, @NotNull String message2, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        HtmlBuilder sb = new HtmlBuilder();
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(facet2.getModule().getProject());
        if (gradleVersion2 != null && gradleVersion2.isAtLeast(3, 0, 0)) {
            int minSdkVersion2;
            String versionPrefix = "to at least ";
            int start2 = message2.indexOf(versionPrefix) + versionPrefix.length();
            if (start2 < 0) {
                throw new IllegalArgumentException("unexpected use suggestion format " + message2);
            }
            int end = message2.indexOf(44, start2);
            if (end < 0) {
                throw new IllegalArgumentException("unexpected use suggestion format " + message2);
            }
            String minSdkVersionString = message2.substring(start2, end);
            try {
                minSdkVersion2 = Integer.parseInt(minSdkVersionString);
            }
            catch (NumberFormatException e) {
                sb.add(message2);
                return sb.getHtml();
            }
            int finalMinSdk = minSdkVersion2;
            Runnable link = () -> {
                Runnable linkAction = () -> {
                    ProjectBuildModel pbm = ProjectBuildModel.get(facet2.getModule().getProject());
                    GradleBuildModel gbm = pbm.getModuleBuildModel(facet2.getModule());
                    if (gbm == null) {
                        return;
                    }
                    gbm.android().defaultConfig().minSdkVersion().setValue(finalMinSdk);
                    ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.runWriteCommandAction((Project)facet2.getModule().getProject(), (String)"Update build file minSdkVersion", null, () -> pbm.applyChanges(), (PsiFile[])new PsiFile[]{gbm.getPsiFile()}));
                    Runnable syncRunnable = () -> ManifestPanel.requestSync(facet2.getModule().getProject());
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        syncRunnable.run();
                    } else {
                        ApplicationManager.getApplication().invokeLater(syncRunnable);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    linkAction.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(linkAction);
                }
            };
            sb.addLink(message2.substring(0, end), htmlLinkManager.createRunnableLink(link));
            sb.add(message2.substring(end));
        } else {
            int eq = message2.indexOf(61);
            if (eq < 0) {
                throw new IllegalArgumentException("unexpected use suggestion format " + message2);
            }
            int end = message2.indexOf(34, eq + 2);
            if (end < 0 || message2.charAt(eq + 1) != '\"') {
                throw new IllegalArgumentException("unexpected use suggestion format " + message2);
            }
            String suggestion = message2.substring(message2.indexOf(32) + 1, end + 1);
            if (!SourcePosition.UNKNOWN.equals((Object)position.getPosition())) {
                XmlFile mainManifest = ManifestUtils.getMainManifest(facet2);
                Element element2 = ManifestPanel.getElementAt(mainManifest, position.getPosition().getStartLine(), position.getPosition().getStartColumn());
                if (element2 != null && "uses-sdk".equals(element2.getTagName())) {
                    sb.addLink(message2.substring(0, end + 1), htmlLinkManager.createRunnableLink(() -> {
                        int eq1 = suggestion.indexOf(61);
                        String attributeName = suggestion.substring(suggestion.indexOf(58) + 1, eq1);
                        String attributeValue = suggestion.substring(eq1 + 2, suggestion.length() - 1);
                        ManifestPanel.addToolsAttribute(mainManifest, element2, attributeName, attributeValue);
                    }));
                    sb.add(message2.substring(end + 1));
                } else {
                    Logger.getInstance(ManifestPanel.class).warn("Can not find uses-sdk tag " + element2);
                    sb.add(message2);
                }
            } else {
                sb.add(message2);
            }
            sb.newlineIfNecessary().newline();
        }
        return sb.getHtml();
    }

    @NotNull
    private static String getErrorRemoveHtml(@NotNull AndroidFacet facet2, @NotNull String message2, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        int end;
        HtmlBuilder sb = new HtmlBuilder();
        int start2 = message2.indexOf(123);
        String declaration = message2.substring(start2 + 1, end = message2.indexOf(125, start2 + 1)).trim();
        if (!declaration.startsWith("applicationId")) {
            throw new IllegalArgumentException("unexpected remove suggestion format " + message2);
        }
        Runnable link = null;
        String applicationId2 = declaration.substring(declaration.indexOf(34) + 1, declaration.lastIndexOf(34));
        File manifestOverlayFile = position.getFile().getSourceFile();
        assert (manifestOverlayFile != null);
        VirtualFile manifestOverlayVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(manifestOverlayFile);
        assert (manifestOverlayVirtualFile != null);
        NamedIdeaSourceProvider sourceProvider = ManifestUtils.findManifestSourceProvider(facet2, manifestOverlayVirtualFile);
        assert (sourceProvider != null);
        String name = sourceProvider.getName();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2.getModule());
        assert (androidModuleModel != null);
        XmlFile manifestOverlayPsiFile = (XmlFile)PsiManager.getInstance((Project)facet2.getModule().getProject()).findFile(manifestOverlayVirtualFile);
        assert (manifestOverlayPsiFile != null);
        if (androidModuleModel.getBuildTypeNames().contains(name)) {
            String packageName = AndroidManifestUtils.getPackageName(facet2);
            assert (packageName != null);
            if (applicationId2.startsWith(packageName)) {
                String applicationIdSuffix2 = applicationId2.substring(packageName.length());
                link = ManifestPanel.createLinkAction(facet2, manifestOverlayPsiFile, name, currentlyOpenFile, true, applicationIdSuffix2);
            }
        } else if (androidModuleModel.getProductFlavorNames().contains(name)) {
            link = ManifestPanel.createLinkAction(facet2, manifestOverlayPsiFile, name, currentlyOpenFile, false, applicationId2);
        }
        if (link != null) {
            sb.addLink(message2.substring(0, end + 1), htmlLinkManager.createRunnableLink(link));
            sb.add(message2.substring(end + 1));
        } else {
            sb.add(message2);
        }
        return sb.getHtml();
    }

    @NotNull
    private static Runnable createLinkAction(@NotNull AndroidFacet facet2, XmlFile manifestOverlayPsiFile, String name, @Nullable VirtualFile currentlyOpenFile, boolean isBuildType, @NotNull String applicationIdOrSuffix) {
        return () -> WriteCommandAction.writeCommandAction((Project)facet2.getModule().getProject(), (PsiFile[])new PsiFile[]{manifestOverlayPsiFile}).withName("Apply manifest suggestion").run(() -> {
            ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(facet2.getModule().getProject());
            GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(facet2.getModule());
            if (gradleBuildModel == null) {
                String errorMessage = "Could not edit build file for '" + facet2.getModule().getName() + "' please apply the suggestion manually";
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)facet2.getModule().getProject(), (String)errorMessage, (String)"Apply Manifest Suggestion"));
                return;
            }
            if (currentlyOpenFile != null) {
                CommandProcessor.getInstance().addAffectedFiles(facet2.getModule().getProject(), new VirtualFile[]{currentlyOpenFile, gradleBuildModel.getVirtualFile()});
            }
            ManifestPanel.removePackageAttribute(manifestOverlayPsiFile);
            if (isBuildType) {
                BuildTypeModel buildTypeModel = gradleBuildModel.android().buildTypes().stream().filter(type -> type.name().equals(name)).findFirst().orElse(gradleBuildModel.android().addBuildType(name));
                buildTypeModel.applicationIdSuffix().setValue(applicationIdOrSuffix);
            } else {
                ProductFlavorModel flavorModel = gradleBuildModel.android().productFlavors().stream().filter(type -> type.name().equals(name)).findFirst().orElse(gradleBuildModel.android().addProductFlavor(name));
                flavorModel.applicationId().setValue(applicationIdOrSuffix);
            }
            projectBuildModel2.applyChanges();
            ManifestPanel.requestSync(facet2.getModule().getProject());
        });
    }

    private static void requestSync(Project project) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
    }

    private static void removePackageAttribute(XmlFile manifestFile) {
        XmlTag tag = manifestFile.getRootTag();
        assert (tag != null);
        tag.setAttribute("package", null);
    }

    static void addToolsAttribute(final @NotNull XmlFile file2, final @NotNull Element element2, final @NotNull String attributeName, final @NotNull String attributeValue) {
        Project project = file2.getProject();
        new WriteCommandAction.Simple(project, "Apply manifest suggestion", new PsiFile[]{file2}){

            protected void run() throws Throwable {
                ManifestUtils.addToolsAttribute(file2, element2, attributeName, attributeValue);
            }
        }.execute();
    }

    @NotNull
    static String getHtml(@NotNull MergingReport.Record.Severity severity) {
        String severityString = StringUtil.capitalize((String)StringUtil.toLowerCase((String)severity.toString()));
        if (severity == MergingReport.Record.Severity.ERROR) {
            return new HtmlBuilder().addHtml("<font color=\"#" + ColorUtil.toHex((Color)JBColor.RED) + "\">").addBold(severityString).addHtml("</font>:").getHtml();
        }
        return severityString;
    }

    @NotNull
    String getHtml(@NotNull AndroidFacet facet2, @NotNull SourceFilePosition sourceFilePosition) {
        HtmlBuilder sb = new HtmlBuilder();
        this.describePosition(sb, facet2, sourceFilePosition);
        return sb.getHtml();
    }

    private void describePosition(@NotNull HtmlBuilder sb, @NotNull AndroidFacet facet2, @NotNull SourceFilePosition sourceFilePosition) {
        SourceFile sourceFile = sourceFilePosition.getFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        File file2 = sourceFile.getSourceFile();
        if (file2 == GRADLE_MODEL_MARKER_FILE) {
            VirtualFile gradleBuildFile = GradleUtil.getGradleBuildFile(facet2.getModule());
            if (gradleBuildFile != null) {
                file2 = VfsUtilCore.virtualToIoFile((VirtualFile)gradleBuildFile);
                sb.addHtml("<a href=\"");
                sb.add(file2.toURI().toString());
                sb.addHtml("\">");
                sb.add(file2.getName());
                sb.addHtml("</a>");
                sb.add(" injection");
            } else {
                sb.add("build.gradle injection (source location unknown)");
            }
            return;
        }
        if (file2 != null && NAV_FILE_PATTERN.matcher(FileUtils.toSystemIndependentPath((String)file2.toString())).matches()) {
            VirtualFile vResDir;
            String source = "";
            File resDir = file2.getParentFile() == null ? null : file2.getParentFile().getParentFile();
            VirtualFile virtualFile = vResDir = resDir == null ? null : LocalFileSystem.getInstance().findFileByIoFile(resDir);
            if (vResDir != null) {
                for (NamedIdeaSourceProvider provider2 : SourceProviderManager.getInstance(facet2).getCurrentSourceProviders()) {
                    if (!Iterables.contains(provider2.getResDirectories(), (Object)vResDir)) continue;
                    source = source + provider2.getName() + " ";
                    break;
                }
            }
            source = source + file2.getName();
            sb.addHtml("<a href=\"");
            sb.add(file2.toURI().toString());
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(":");
                sb.add(String.valueOf(sourcePosition.getStartLine()));
                sb.add(":");
                sb.add(String.valueOf(sourcePosition.getStartColumn()));
            }
            sb.addHtml("\">");
            sb.add(source);
            sb.addHtml("</a>");
            sb.add(" navigation file");
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(", line ");
                sb.add(Integer.toString(sourcePosition.getStartLine()));
            }
            return;
        }
        if (file2 != null) {
            String source = null;
            Module[] modules = ModuleManager.getInstance((Project)facet2.getModule().getProject()).getModules();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
            if (vFile != null) {
                NamedIdeaSourceProvider provider3;
                int n;
                Module[] moduleArray;
                String path2 = file2.getPath();
                Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)facet2.getModule().getProject());
                if (module2 != null) {
                    if (modules.length >= 2) {
                        source = module2.getName();
                    }
                    if (path2.contains("exploded-aar")) {
                        source = ManifestPanel.findSourceForFileInExplodedAar(file2, facet2, module2);
                    }
                } else if (path2.contains("output") && path2.matches(".*\\w{40}[\\\\/]output.*")) {
                    Module singleModule;
                    moduleArray = modules;
                    n = moduleArray.length;
                    for (int j = 0; j < n && (source = ManifestPanel.findSourceForFileInExplodedAar(file2, facet2, singleModule = moduleArray[j])) == null; ++j) {
                    }
                } else if (path2.contains("caches")) {
                    Module singleModule;
                    moduleArray = modules;
                    n = moduleArray.length;
                    for (int j = 0; j < n && (source = ManifestPanel.findSourceForFileInExplodedAar(file2, facet2, singleModule = moduleArray[j])) == null; ++j) {
                    }
                }
                if ((provider3 = ManifestUtils.findManifestSourceProvider(facet2, vFile)) != null) {
                    String providerName = provider3.getName();
                    source = source == null ? providerName : source + " " + providerName;
                }
            }
            if (source == null) {
                source = file2.getName();
                if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                    source = source + ":" + String.valueOf(sourcePosition);
                }
            }
            sb.addHtml("<a href=\"");
            sb.add(file2.toURI().toString());
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(":");
                sb.add(String.valueOf(sourcePosition.getStartLine()));
                sb.add(":");
                sb.add(String.valueOf(sourcePosition.getStartColumn()));
            }
            sb.addHtml("\">");
            sb.add(source);
            sb.addHtml("</a>");
            sb.add(" manifest");
            if (FileUtil.filesEqual((File)file2, (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile))) {
                sb.add(" (this file)");
            }
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                sb.add(", line ");
                sb.add(Integer.toString(sourcePosition.getStartLine()));
            }
        }
    }

    @Nullable
    private static String findSourceForFileInExplodedAar(@NotNull File file2, @NotNull AndroidFacet facet2, @NotNull Module module2) {
        IdeLibrary library;
        String source = null;
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel != null && (library = GradleUtil.findLibrary(file2.getParentFile(), androidModel.getSelectedVariant())) != null) {
            source = DependenciesExtractor.getDependencyDisplayName(library);
        }
        return source;
    }

    @NotNull
    public static Color harder(@NotNull Color color) {
        if (color.getBlue() == color.getRed() && color.getRed() == color.getGreen()) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], 1.0f, hsb[2]);
    }

    private class FileColorTree
    extends Tree {
        public FileColorTree() {
            this.setFont(ManifestPanel.this.myDefaultFont);
            this.setBackground(ManifestPanel.this.myBackgroundColor);
        }

        public boolean isFileColorsEnabled() {
            if (this.isOpaque()) {
                this.setOpaque(false);
            }
            return true;
        }

        @Nullable
        public Color getFileColorFor(Object object) {
            return object == null ? null : ManifestPanel.this.getNodeColor((Node)object);
        }
    }

    private class SyntaxHighlightingCellRenderer
    extends ColoredTreeCellRenderer {
        private final SimpleTextAttributes myTagNameAttributes;
        private final SimpleTextAttributes myNameAttributes;
        private final SimpleTextAttributes myValueAttributes;
        private final SimpleTextAttributes myPrefixAttributes;

        public SyntaxHighlightingCellRenderer() {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color tagNameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_TAG_NAME).getForegroundColor();
            Color nameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_NAME).getForegroundColor();
            Color valueColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_VALUE).getForegroundColor();
            Color prefixColor = globalScheme.getAttributes(XmlHighlighterColors.XML_NS_PREFIX).getForegroundColor();
            this.myTagNameAttributes = new SimpleTextAttributes(1, tagNameColor);
            this.myNameAttributes = new SimpleTextAttributes(0, nameColor);
            this.myValueAttributes = new SimpleTextAttributes(0, valueColor);
            this.myPrefixAttributes = new SimpleTextAttributes(0, prefixColor);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof ManifestTreeNode) {
                ManifestTreeNode node2 = (ManifestTreeNode)value2;
                this.setIcon(null);
                if (node2.getUserObject() instanceof Element) {
                    Element element2 = (Element)node2.getUserObject();
                    this.append("<");
                    this.append(element2.getTagName(), this.myTagNameAttributes);
                    if (!expanded) {
                        this.append(" ... " + this.getCloseTag(node2));
                    }
                }
                if (node2.getUserObject() instanceof Attr) {
                    Attr attr = (Attr)node2.getUserObject();
                    ManifestTreeNode parent = node2.getParent();
                    assert (parent != null);
                    if (attr.getPrefix() != null) {
                        this.append(attr.getPrefix(), this.myPrefixAttributes);
                        this.append(":");
                        this.append(attr.getLocalName(), this.myNameAttributes);
                    } else {
                        this.append(attr.getName(), this.myNameAttributes);
                    }
                    this.append("=\"");
                    this.append(attr.getValue(), this.myValueAttributes);
                    this.append("\"");
                    if (parent.lastAttribute() == node2) {
                        this.append(" " + this.getCloseTag(node2));
                    }
                }
            }
        }

        private String getCloseTag(ManifestTreeNode node2) {
            return node2.hasElementChildren() ? ">" : "/>";
        }
    }

    static class ManifestTreeNode
    extends DefaultMutableTreeNode {
        public ManifestTreeNode(@NotNull Node obj) {
            super(obj);
        }

        @Override
        @NotNull
        public Node getUserObject() {
            return (Node)super.getUserObject();
        }

        @Override
        public int getChildCount() {
            Node obj = this.getUserObject();
            if (obj instanceof Element) {
                Element element2 = (Element)obj;
                NamedNodeMap attributes = element2.getAttributes();
                int count = attributes.getLength();
                NodeList childNodes2 = element2.getChildNodes();
                int n = childNodes2.getLength();
                for (int i2 = 0; i2 < n; ++i2) {
                    Node child = childNodes2.item(i2);
                    if (child.getNodeType() != 1) continue;
                    ++count;
                }
                return count;
            }
            return 0;
        }

        @Override
        @NotNull
        public ManifestTreeNode getChildAt(int index2) {
            Node obj = this.getUserObject();
            if (this.children == null && obj instanceof Element) {
                Element element2 = (Element)obj;
                NamedNodeMap attributes = element2.getAttributes();
                int n = attributes.getLength();
                for (int i2 = 0; i2 < n; ++i2) {
                    this.add(new ManifestTreeNode(attributes.item(i2)));
                }
                NodeList childNodes2 = element2.getChildNodes();
                int n2 = childNodes2.getLength();
                for (int i3 = 0; i3 < n2; ++i3) {
                    Node child = childNodes2.item(i3);
                    if (child.getNodeType() != 1) continue;
                    this.add(new ManifestTreeNode(child));
                }
            }
            return (ManifestTreeNode)super.getChildAt(index2);
        }

        @Override
        public void add(@NotNull MutableTreeNode newChild) {
            this.insert(newChild, this.children == null ? 0 : this.children.size());
        }

        @Override
        @NotNull
        public String toString() {
            Node obj = this.getUserObject();
            if (obj instanceof Attr) {
                Attr xmlAttribute = (Attr)obj;
                return xmlAttribute.getName() + " = " + xmlAttribute.getValue();
            }
            if (obj instanceof Element) {
                Element xmlTag = (Element)obj;
                return xmlTag.getTagName();
            }
            return obj.toString();
        }

        @Override
        @Nullable
        public ManifestTreeNode getParent() {
            return (ManifestTreeNode)super.getParent();
        }

        @NotNull
        public ManifestTreeNode lastAttribute() {
            Node xmlTag = this.getUserObject();
            return this.getChildAt(xmlTag.getAttributes().getLength() - 1);
        }

        public boolean hasElementChildren() {
            Node node2 = this.getUserObject();
            if (node2 instanceof Attr) {
                ManifestTreeNode parent = this.getParent();
                assert (parent != null);
                return parent.hasElementChildren();
            }
            return node2.getChildNodes().getLength() > 0;
        }
    }
}

