/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layeredimage;

import com.android.tools.idea.editors.layeredimage.EmptyVirtualFile;
import com.android.tools.idea.editors.layeredimage.LayeredImageEditor;
import com.android.utils.SdkUtils;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LayeredImageEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String EDITOR_TYPE_ID = "layeredimageeditor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        return SdkUtils.endsWithIgnoreCase((String)file2.getPath(), (String)".psd");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        FileEditorProvider provider2 = FileEditorProviderManager.getInstance().getProvider("images");
        assert (provider2 != null);
        FileEditor editor2 = provider2.createEditor(project, (VirtualFile)new EmptyVirtualFile(file2));
        return new LayeredImageEditor(project, file2, editor2);
    }

    @NotNull
    public String getEditorTypeId() {
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

