/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.annotations.concurrency.Slow;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.diagnostics.windows.VirusCheckerStatusProvider;
import com.android.tools.idea.diagnostics.windows.WindowsDefenderPowerShellStatusProvider;
import com.android.tools.idea.diagnostics.windows.WindowsDefenderRegistryStatusProvider;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.WindowsDefenderStatus;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsPerformanceHintsChecker {
    private static final Logger LOG = Logger.getInstance(WindowsPerformanceHintsChecker.class);
    private static final String ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY = "antivirus.scan.notification.last.shown.time";
    private static final Duration ANTIVIRUS_MIN_INTERVAL_BETWEEN_NOTIFICATIONS = Duration.ofDays(1L);
    private static final Pattern WINDOWS_ENV_VAR_PATTERN = Pattern.compile("%([^%]+?)%");
    private static final Pattern WINDOWS_DEFENDER_WILDCARD_PATTERN = Pattern.compile("[?*]");
    private AndroidStudioSystemHealthMonitor systemHealthMonitor = AndroidStudioSystemHealthMonitor.getInstance();
    private VirusCheckerStatusProvider myVirusCheckerStatusProvider = (Boolean)StudioFlags.ANTIVIRUS_CHECK_USE_REGISTRY.get() != false ? new WindowsDefenderRegistryStatusProvider() : new WindowsDefenderPowerShellStatusProvider();

    public void run() {
        if (SystemInfo.isWindows && (((Boolean)StudioFlags.ANTIVIRUS_METRICS_ENABLED.get()).booleanValue() || ((Boolean)StudioFlags.ANTIVIRUS_NOTIFICATION_ENABLED.get()).booleanValue())) {
            final Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(final @NotNull Project project) {
                    application.executeOnPooledThread(() -> WindowsPerformanceHintsChecker.this.checkWindowsDefender(project, false));
                    GradleBuildState.subscribe(project, new GradleBuildListener(){

                        @Override
                        public void buildExecutorCreated(@NotNull GradleBuildInvoker.Request request) {
                        }

                        @Override
                        public void buildStarted(@NotNull BuildContext context) {
                        }

                        @Override
                        public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
                            BuildMode mode;
                            BuildMode buildMode = mode = context != null ? context.getBuildMode() : null;
                            if (status.isBuildSuccessful() && (mode == BuildMode.ASSEMBLE || mode == BuildMode.ASSEMBLE_TRANSLATE || mode == BuildMode.REBUILD || mode == BuildMode.BUNDLE || mode == BuildMode.APK_FROM_BUNDLE)) {
                                application.executeOnPooledThread(() -> WindowsPerformanceHintsChecker.this.checkWindowsDefender(project, true));
                            }
                        }
                    });
                }
            });
        }
    }

    @Slow
    private void checkWindowsDefender(@NotNull Project project, boolean showNotification2) {
        VirusCheckerStatusProvider.RealtimeScanningStatus status;
        try {
            status = this.myVirusCheckerStatusProvider.getRealtimeScanningStatus();
        }
        catch (IOException exception) {
            LOG.warn("Error retrieving status of virus checker", (Throwable)exception);
            WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.UNKNOWN_STATUS, false, project);
            return;
        }
        switch (status) {
            case SCANNING_ENABLED: {
                WindowsDefenderStatus.Status overallStatus;
                List<Pattern> excludedPatterns = this.getExcludedPatterns();
                if (excludedPatterns == null) {
                    WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.UNKNOWN_STATUS, false, project);
                    break;
                }
                Map<Path, Boolean> pathStatuses = WindowsPerformanceHintsChecker.checkPathsExcluded(WindowsPerformanceHintsChecker.getImportantPaths(project), excludedPatterns);
                if (pathStatuses.containsValue(Boolean.FALSE)) {
                    if (showNotification2 && ((Boolean)StudioFlags.ANTIVIRUS_NOTIFICATION_ENABLED.get()).booleanValue() && !WindowsPerformanceHintsChecker.shownRecently()) {
                        this.showAntivirusNotification(project, WindowsPerformanceHintsChecker.getNotificationTextForNonExcludedPaths(pathStatuses));
                        WindowsPerformanceHintsChecker.setLastShownTime();
                    }
                    overallStatus = pathStatuses.containsValue(Boolean.TRUE) ? WindowsDefenderStatus.Status.SOME_EXCLUDED : WindowsDefenderStatus.Status.NONE_EXCLUDED;
                } else {
                    overallStatus = WindowsDefenderStatus.Status.ALL_EXCLUDED;
                }
                String projectDir = project.getBasePath();
                boolean projectPathExcluded = false;
                if (projectDir != null) {
                    projectPathExcluded = pathStatuses.getOrDefault(Paths.get(projectDir, new String[0]), false);
                }
                WindowsPerformanceHintsChecker.logWindowsDefenderStatus(overallStatus, projectPathExcluded, project);
                break;
            }
            case SCANNING_DISABLED: {
                WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.SCANNING_DISABLED, true, project);
            }
        }
    }

    private void showAntivirusNotification(@NotNull Project project, @NotNull String pathDetails) {
        final String key = "virus.scanning.warn.message";
        boolean ignored = false;
        final PropertiesComponent applicationProperties = PropertiesComponent.getInstance();
        final PropertiesComponent projectProperties = PropertiesComponent.getInstance((Project)project);
        if (applicationProperties != null) {
            ignored = applicationProperties.isValueSet("ignore." + key);
        }
        if (projectProperties != null) {
            ignored |= projectProperties.isValueSet("ignore." + key);
        }
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        AndroidStudioSystemHealthMonitor androidStudioSystemHealthMonitor = this.systemHealthMonitor;
        ((Object)((Object)androidStudioSystemHealthMonitor)).getClass();
        AndroidStudioSystemHealthMonitor.MyNotification notification = androidStudioSystemHealthMonitor.new AndroidStudioSystemHealthMonitor.MyNotification(AndroidBundle.message(key, pathDetails));
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("virus.scanning.dont.show.again", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
                if (applicationProperties != null) {
                    applicationProperties.setValue("ignore." + key, "true");
                }
            }
        });
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("virus.scanning.dont.show.again.this.project", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
                if (projectProperties != null) {
                    projectProperties.setValue("ignore." + key, "true");
                }
            }
        });
        notification.addAction((AnAction)AndroidStudioSystemHealthMonitor.detailsAction("https://d.android.com/r/studio-ui/antivirus-check"));
        notification.setImportant(true);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private static boolean shownRecently() {
        if ("true".equals(System.getProperty("disable.antivirus.notification.rate.limit"))) {
            return false;
        }
        String lastShownTime = PropertiesComponent.getInstance().getValue(ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY);
        if (lastShownTime == null) {
            return false;
        }
        try {
            Instant lastShown = Instant.parse(lastShownTime);
            return lastShown.plus(ANTIVIRUS_MIN_INTERVAL_BETWEEN_NOTIFICATIONS).isAfter(Instant.now());
        }
        catch (DateTimeException e) {
            WindowsPerformanceHintsChecker.setLastShownTime();
            return false;
        }
    }

    private static void setLastShownTime() {
        PropertiesComponent.getInstance().setValue(ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY, Instant.now().toString());
    }

    private static void logWindowsDefenderStatus(WindowsDefenderStatus.Status status, boolean projectDirExcluded, @NotNull Project project) {
        LOG.info("Windows Defender status: " + status + "; projectDirExcluded? " + projectDirExcluded);
        if (((Boolean)StudioFlags.ANTIVIRUS_METRICS_ENABLED.get()).booleanValue() && !ApplicationManager.getApplication().isInternal() && StatisticsUploadAssistant.isSendAllowed()) {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WINDOWS_DEFENDER_STATUS).setWindowsDefenderStatus(WindowsDefenderStatus.newBuilder().setProjectDirExcluded(projectDirExcluded).setStatus(status)), project));
        }
    }

    @Slow
    @Nullable
    private List<Pattern> getExcludedPatterns() {
        try {
            List<String> excludedPaths = this.myVirusCheckerStatusProvider.getExcludedPaths();
            return ContainerUtil.map(excludedPaths, path2 -> WindowsPerformanceHintsChecker.wildcardsToRegex(WindowsPerformanceHintsChecker.expandEnvVars(path2)));
        }
        catch (IOException exception) {
            LOG.warn("Error retrieving list of excluded patterns", (Throwable)exception);
            return null;
        }
    }

    @NotNull
    private static List<Path> getImportantPaths(@NotNull Project project) {
        String homeDir = System.getProperty("user.home");
        String gradleUserHome = System.getenv("GRADLE_USER_HOME");
        String projectDir = project.getBasePath();
        ArrayList<Path> paths = new ArrayList<Path>();
        if (projectDir != null) {
            paths.add(Paths.get(projectDir, new String[0]));
        }
        paths.add(Paths.get(PathManager.getSystemPath(), new String[0]));
        if (gradleUserHome != null) {
            paths.add(Paths.get(gradleUserHome, new String[0]));
        } else {
            paths.add(Paths.get(homeDir, ".gradle"));
        }
        AndroidSdkData sdkData = AndroidSdkUtils.getProjectSdkData(project);
        if (sdkData == null) {
            sdkData = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (sdkData != null) {
            paths.add(Paths.get(sdkData.getLocation().getAbsolutePath(), new String[0]));
        }
        return paths;
    }

    @NotNull
    private static String expandEnvVars(@NotNull String path2) {
        Matcher m = WINDOWS_ENV_VAR_PATTERN.matcher(path2);
        StringBuffer result2 = new StringBuffer();
        while (m.find()) {
            String value2 = System.getenv(m.group(1));
            if (value2 == null) continue;
            m.appendReplacement(result2, Matcher.quoteReplacement(value2));
        }
        m.appendTail(result2);
        return result2.toString();
    }

    @NotNull
    private static Pattern wildcardsToRegex(@NotNull String path2) {
        Matcher m = WINDOWS_DEFENDER_WILDCARD_PATTERN.matcher(path2);
        StringBuilder sb = new StringBuilder();
        int previousWildcardEnd = 0;
        while (m.find()) {
            sb.append(Pattern.quote(path2.substring(previousWildcardEnd, m.start())));
            if (m.group().equals("?")) {
                sb.append("[^\\\\]");
            } else {
                sb.append("[^\\\\]*");
            }
            previousWildcardEnd = m.end();
        }
        sb.append(Pattern.quote(path2.substring(previousWildcardEnd)));
        sb.append(".*");
        return Pattern.compile(sb.toString(), 2);
    }

    @NotNull
    private static Map<Path, Boolean> checkPathsExcluded(@NotNull List<Path> paths, @NotNull List<Pattern> excludedPatterns) {
        HashMap<Path, Boolean> result2 = new HashMap<Path, Boolean>();
        for (Path path2 : paths) {
            try {
                String canonical = path2.toRealPath(new LinkOption[0]).toString();
                boolean found = false;
                for (Pattern pattern : excludedPatterns) {
                    if (!pattern.matcher(canonical).matches()) continue;
                    found = true;
                    result2.put(path2, true);
                    break;
                }
                if (found) continue;
                result2.put(path2, false);
            }
            catch (IOException e) {
                LOG.warn("Windows Defender exclusion check couldn't get real path for " + path2, (Throwable)e);
            }
        }
        return result2;
    }

    @NotNull
    private static String getNotificationTextForNonExcludedPaths(@NotNull Map<Path, Boolean> pathStatuses) {
        StringBuilder sb = new StringBuilder();
        pathStatuses.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).forEach(entry -> sb.append("<br/>").append(entry.getKey()));
        return sb.toString();
    }
}

