/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReportBuilder;
import com.android.tools.idea.diagnostics.LastActionTracker;
import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiagnosticReportIdePerformanceListener
implements IdePerformanceListener {
    private static final Logger LOG = Logger.getInstance(DiagnosticReportIdePerformanceListener.class);
    private final Consumer<DiagnosticReport> myReportCallback;
    @Nullable
    private DiagnosticReportBuilder myBuilder;
    @Nullable
    private ReportContext myContext;
    private int myReportsCollected;
    @Nullable
    private MessageBusConnection myMessageBusConnection;
    private LastActionTracker myLastActionTracker;

    public DiagnosticReportIdePerformanceListener(Consumer<DiagnosticReport> reportCallback) {
        this.myReportCallback = reportCallback;
        this.myLastActionTracker = new LastActionTracker();
    }

    public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump2) {
        ReportContext currentContext = this.myContext;
        if (currentContext != null && currentContext.myThreadDumpPath == null) {
            currentContext.myThreadDumpPath = toFile.toPath().getParent();
        }
    }

    public void uiFreezeStarted() {
        ReportContext context;
        LOG.info("uiFreezeStarted");
        if (this.myBuilder != null) {
            return;
        }
        this.myContext = context = new ReportContext();
        int freezeTimeBeforeCreatedMs = Registry.intValue((String)"performance.watcher.unresponsive.interval.ms");
        this.myBuilder = new DiagnosticReportBuilder(DiagnosticReportBuilder.INTERVAL_MS, DiagnosticReportBuilder.MAX_DURATION_MS, DiagnosticReportBuilder.FRAME_IGNORE_THRESHOLD_MS, freezeTimeBeforeCreatedMs, this.myLastActionTracker, new Controller(context));
    }

    private void reportReady(DiagnosticReport report2) {
        this.myReportCallback.accept(report2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uiFreezeFinished(long durationMs, @Nullable File reportDir) {
        int lengthInSeconds = (int)(durationMs / 1000L);
        LOG.info(String.format(Locale.US, "uiFreezeFinished: duration = %d seconds", lengthInSeconds));
        DiagnosticReportBuilder localBuilder = this.myBuilder;
        if (localBuilder == null) {
            return;
        }
        try {
            ++this.myReportsCollected;
            if (DiagnosticReportBuilder.MAX_REPORTS != -1 && this.myReportsCollected >= DiagnosticReportBuilder.MAX_REPORTS) {
                LOG.info("Stopped collecting UI freeze reports after " + this.myReportsCollected + " reports.");
                this.unregister();
            }
            if (this.myContext != null) {
                Path localReportPath;
                if (this.myContext.myThreadDumpPath == null) {
                    Path directoryForFreeze = DiagnosticReportIdePerformanceListener.tryCreateDirectoryForFreeze(lengthInSeconds);
                    if (directoryForFreeze == null) {
                        return;
                    }
                    this.myContext.myThreadDumpPath = directoryForFreeze;
                }
                if ((localReportPath = DiagnosticReportIdePerformanceListener.getPathForReportName("profileDiagnostics", this.myContext)) != null && Files.exists(localReportPath, new LinkOption[0])) {
                    try {
                        Files.write(localReportPath, ("UI freeze lasted " + lengthInSeconds + " seconds.\n").getBytes(), StandardOpenOption.APPEND);
                    }
                    catch (IOException e) {
                        LOG.warn("Exception while appending to a report.", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.myBuilder = null;
            this.myContext = null;
            localBuilder.stop();
        }
    }

    private static Path tryCreateDirectoryForFreeze(long freezeInSeconds) {
        String dirName = "uiFreeze-" + DiagnosticReportIdePerformanceListener.formatTime(System.currentTimeMillis()) + "-" + freezeInSeconds + "sec";
        Path freezeDir = Paths.get(PathManager.getLogPath(), dirName);
        try {
            if (Files.exists(freezeDir, new LinkOption[0])) {
                return null;
            }
            Files.createDirectories(freezeDir, new FileAttribute[0]);
            return freezeDir;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String formatTime(long timeMs) {
        return new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(new Date(timeMs));
    }

    private static Path tryFixReportPath(@NotNull Path path2) {
        Path reportDirectory = path2.getParent();
        if (Files.isDirectory(reportDirectory, new LinkOption[0])) {
            return path2;
        }
        String directoryGlob = reportDirectory.getFileName().toString() + "-*";
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(reportDirectory.getParent(), directoryGlob);){
            Iterator<Path> iterator = paths.iterator();
            if (iterator.hasNext()) {
                reportDirectory = iterator.next();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        if (reportDirectory == null) {
            return path2;
        }
        return reportDirectory.resolve(path2.getFileName());
    }

    @Nullable
    private static Path getPathForReportName(@NotNull String reportName, @NotNull ReportContext context) {
        Path threadDumpPath = context.myThreadDumpPath;
        if (threadDumpPath == null) {
            return null;
        }
        Path reportPath = threadDumpPath.resolve("diagnosticReport-" + reportName + ".txt");
        return DiagnosticReportIdePerformanceListener.tryFixReportPath(reportPath);
    }

    @Nullable
    private static Path saveReportFile(@NotNull String reportName, @NotNull String reportContents, ReportContext context) {
        Path reportPath = DiagnosticReportIdePerformanceListener.getPathForReportName(reportName, context);
        if (reportPath == null) {
            return null;
        }
        if (Files.exists(reportPath, new LinkOption[0])) {
            return reportPath;
        }
        try (PrintWriter out = new PrintWriter(reportPath.toFile(), "UTF-8");){
            out.write(reportContents);
            LOG.info(String.format("Freeze report saved: %s", reportPath));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return reportPath;
    }

    public void registerOn(Application application) {
        assert (this.myMessageBusConnection == null);
        this.myMessageBusConnection = application.getMessageBus().connect();
        this.myMessageBusConnection.subscribe(IdePerformanceListener.TOPIC, (Object)this);
    }

    public void unregister() {
        assert (this.myMessageBusConnection != null);
        this.myMessageBusConnection.disconnect();
        this.myMessageBusConnection = null;
        Disposer.dispose((Disposable)this.myLastActionTracker);
        this.myLastActionTracker = null;
    }

    public class Controller {
        private final ReportContext myContext;

        public Controller(ReportContext context) {
            this.myContext = context;
        }

        public Path saveReportFile(String reportName, String reportContents) {
            return DiagnosticReportIdePerformanceListener.saveReportFile(reportName, reportContents, this.myContext);
        }

        public void reportReady(DiagnosticReport report2) {
            DiagnosticReportIdePerformanceListener.this.reportReady(report2);
        }
    }

    private static class ReportContext {
        private Path myThreadDumpPath;

        private ReportContext() {
        }
    }
}

