/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectResourceIdResolver
implements ResourceIdResolver {
    private final Project myProject;
    private TIntObjectHashMap<String> myIdMap;
    private boolean myInitialized;

    @NotNull
    public static ResourceIdResolver getInstance(@NotNull Project project) {
        return (ResourceIdResolver)ServiceManager.getService((Project)project, ResourceIdResolver.class);
    }

    private ProjectResourceIdResolver(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public String getAndroidResourceName(int resId) {
        if (!this.myInitialized) {
            this.myIdMap = this.getIdMap();
            this.myInitialized = true;
        }
        return this.myIdMap == null ? null : (String)this.myIdMap.get(resId);
    }

    private TIntObjectHashMap<String> getIdMap() {
        AndroidSdkData sdkData;
        Module m;
        AndroidFacet facet2 = null;
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        int n = moduleArray.length;
        for (int j = 0; j < n && (facet2 = AndroidFacet.getInstance((Module)(m = moduleArray[j]))) == null; ++j) {
        }
        AndroidSdkData androidSdkData = sdkData = facet2 == null ? null : AndroidSdkData.getSdkData(facet2);
        if (sdkData == null) {
            return null;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            return null;
        }
        return sdkData.getTargetData(targets[targets.length - 1]).getPublicIdMap();
    }
}

