/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.psiclass;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.databinding.BindingLayout;
import com.android.tools.idea.databinding.BindingLayoutFile;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.ImportData;
import com.android.tools.idea.databinding.index.VariableData;
import com.android.tools.idea.databinding.index.ViewIdData;
import com.android.tools.idea.databinding.psiclass.LightBindingClassConfig;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.databinding.util.LayoutBindingTypeUtil;
import com.android.tools.idea.databinding.util.ViewBindingUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.light.DeprecatableLightMethodBuilder;
import com.android.tools.idea.psi.light.NullabilityLightFieldBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBindingClass
extends AndroidLightClassBase {
    @NotNull
    private final LightBindingClassConfig myConfig;
    @NotNull
    private final PsiJavaFile myBackingFile;
    @Nullable
    private PsiClass[] myPsiSupers;
    @Nullable
    private PsiMethod[] myPsiConstructors;
    @Nullable
    private PsiMethod[] myPsiAllMethods;
    @Nullable
    private PsiMethod[] myPsiMethods;
    @Nullable
    private PsiField[] myPsiFields;
    @Nullable
    private PsiReferenceList myExtendsList;
    @Nullable
    private PsiClassType[] myExtendsListTypes;

    public LightBindingClass(@NotNull PsiManager psiManager, @NotNull LightBindingClassConfig config) {
        super(psiManager, (Collection<String>)ImmutableSet.of((Object)"public", (Object)"final"));
        this.myConfig = config;
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)this.getProject());
        this.myBackingFile = (PsiJavaFile)fileFactory.createFileFromText(this.myConfig.getClassName() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)"// This class is generated on-the-fly by the IDE.");
        this.myBackingFile.setPackageName(StringUtil.getPackageName((String)this.myConfig.getQualifiedName()));
        this.setModuleInfo(this.myConfig.getFacet().getModule(), false);
    }

    private PsiMethod[] computeMethods() {
        ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>();
        this.createRootOverride(methods2);
        for (Pair<VariableData, XmlTag> variableTag : this.myConfig.getVariableTags()) {
            this.createVariableMethods(variableTag, methods2);
        }
        if (this.myConfig.shouldGenerateGettersAndStaticMethods()) {
            this.createStaticMethods(methods2);
        }
        return methods2.toArray(PsiMethod.EMPTY_ARRAY);
    }

    private PsiField[] computeFields() {
        Map<BindingLayout, Collection<ViewIdData>> scopedViewIds = this.myConfig.getScopedViewIds();
        if (scopedViewIds.isEmpty()) {
            return PsiField.EMPTY_ARRAY;
        }
        boolean allEmpty = true;
        for (Collection<ViewIdData> viewIds : scopedViewIds.values()) {
            if (viewIds.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return PsiField.EMPTY_ARRAY;
        }
        int numLayouts = scopedViewIds.keySet().size();
        if (numLayouts == 1) {
            Collection<ViewIdData> viewIds;
            viewIds = scopedViewIds.values().stream().findFirst().get();
            return (PsiField[])viewIds.stream().map(viewId -> this.createPsiField((ViewIdData)viewId, true)).filter(field2 -> field2 != null).toArray(PsiField[]::new);
        }
        HashMap<String, Integer> idCounts = new HashMap<String, Integer>();
        HashSet<ViewIdData> dedupedViewIds = new HashSet<ViewIdData>();
        for (Collection<ViewIdData> viewIds : scopedViewIds.values()) {
            for (ViewIdData viewId2 : viewIds) {
                int count = idCounts.compute(viewId2.getId(), (key, value2) -> value2 == null ? 1 : value2 + 1);
                if (count != 1) continue;
                dedupedViewIds.add(viewId2);
            }
        }
        return (PsiField[])dedupedViewIds.stream().map(viewId -> this.createPsiField((ViewIdData)viewId, (Integer)idCounts.get(viewId.getId()) == numLayouts)).filter(field2 -> field2 != null).toArray(PsiField[]::new);
    }

    @NotNull
    private PsiMethod createConstructor() {
        LightMethodBuilder constructor = new LightMethodBuilder((PsiClass)this, (Language)JavaLanguage.INSTANCE);
        constructor.setConstructor(true);
        constructor.addModifier("private");
        return constructor;
    }

    @NotNull
    public String getQualifiedName() {
        return this.myConfig.getQualifiedName();
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myPsiFields == null) {
            this.myPsiFields = this.computeFields();
        }
        return this.myPsiFields;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        return this.getFields();
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        if (this.myPsiConstructors == null) {
            this.myPsiConstructors = new PsiMethod[]{this.createConstructor()};
        }
        return this.myPsiConstructors;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        if (this.myPsiMethods == null) {
            this.myPsiMethods = this.computeMethods();
        }
        return this.myPsiMethods;
    }

    @Override
    @NotNull
    public PsiClass[] getSupers() {
        if (this.myPsiSupers == null) {
            PsiClass superClass = this.getSuperClass();
            this.myPsiSupers = superClass != null ? new PsiClass[]{superClass} : PsiClass.EMPTY_ARRAY;
        }
        return this.myPsiSupers;
    }

    @Override
    public PsiClass getSuperClass() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myConfig.getSuperName(), this.getModuleScope());
    }

    @Override
    public PsiReferenceList getExtendsList() {
        if (this.myExtendsList == null) {
            PsiElementFactory factory2 = PsiElementFactory.getInstance((Project)this.getProject());
            PsiJavaCodeReferenceElement referenceElementByType = factory2.createReferenceElementByType(this.getExtendsListTypes()[0]);
            this.myExtendsList = factory2.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElementByType});
        }
        return this.myExtendsList;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        return this.getExtendsListTypes();
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        if (this.myExtendsListTypes == null) {
            this.myExtendsListTypes = new PsiClassType[]{PsiType.getTypeByName((String)this.myConfig.getSuperName(), (Project)this.getProject(), (GlobalSearchScope)this.getModuleScope())};
        }
        return this.myExtendsListTypes;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        if (this.myPsiAllMethods == null) {
            PsiClass superClass = this.getSuperClass();
            this.myPsiAllMethods = superClass != null ? (PsiMethod[])ObjectArrays.concat((Object[])superClass.getAllMethods(), (Object[])this.getMethods(), PsiMethod.class) : this.getMethods();
        }
        return this.myPsiAllMethods;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] methods2;
        ArrayList<PsiMethod> matched = null;
        for (PsiMethod method2 : methods2 = checkBases ? this.getAllMethods() : this.getMethods()) {
            if (!name.equals(method2.getName())) continue;
            if (matched == null) {
                matched = new ArrayList<PsiMethod>();
            }
            matched.add(method2);
        }
        return matched == null ? PsiMethod.EMPTY_ARRAY : matched.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean continueProcessing = super.processDeclarations(processor, state, lastParent, place);
        if (!continueProcessing) {
            return false;
        }
        Collection<ImportData> imports = this.myConfig.getTargetLayout().getData().getImports();
        if (imports.isEmpty()) {
            return true;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint != null && classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint != null ? nameHint.getName(state) : null;
            for (ImportData anImport : imports) {
                PsiClass aClass;
                if (anImport.getAlias() != null) continue;
                String qName = anImport.getType();
                if (name != null && !qName.endsWith(name) || (aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qName, this.getModuleScope())) == null || processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private GlobalSearchScope getModuleScope() {
        return ProjectSystemUtil.getModuleSystem(this.myConfig.getFacet()).getResolveScope(ScopeType.MAIN);
    }

    private void createRootOverride(@NotNull List<PsiMethod> outPsiMethods) {
        XmlFile xmlFile = this.myConfig.getTargetLayout().toXmlFile();
        if (xmlFile == null) {
            return;
        }
        BindingXmlData xmlData = this.myConfig.getTargetLayout().getData();
        if (xmlData.getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && ViewBindingUtil.isViewBindingEnabled(this.myConfig.getFacet())) {
            XmlTag xmlRootTag = xmlFile.getRootTag();
            if (xmlRootTag == null) {
                return;
            }
            String rootTag = this.myConfig.getRootType();
            PsiType type = LayoutBindingTypeUtil.resolveViewPsiType(rootTag, (PsiElement)this);
            if (type != null) {
                DeprecatableLightMethodBuilder rootMethod = this.createPublicMethod("getRoot", type);
                outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlRootTag, this.getManager(), (PsiMethod)rootMethod, this, (Language)JavaLanguage.INSTANCE));
            }
        }
    }

    private void createVariableMethods(@NotNull Pair<VariableData, XmlTag> variableTag, @NotNull List<PsiMethod> outPsiMethods) {
        PsiManager psiManager = this.getManager();
        VariableData variable = (VariableData)variableTag.getFirst();
        XmlTag xmlTag = (XmlTag)variableTag.getSecond();
        String typeName = variable.getType();
        String variableType = DataBindingUtil.getQualifiedType(this.getProject(), typeName, this.myConfig.getTargetLayout().getData(), true);
        if (variableType == null) {
            return;
        }
        PsiType type = LayoutBindingTypeUtil.parsePsiType(variableType, (PsiElement)xmlTag);
        if (type == null) {
            return;
        }
        String javaName = DataBindingUtil.convertVariableNameToJavaFieldName(variable.getName());
        String capitalizedName = StringUtil.capitalize((String)javaName);
        DeprecatableLightMethodBuilder setter = this.createPublicMethod("set" + capitalizedName, (PsiType)PsiType.VOID);
        setter.addParameter(javaName, type);
        if (this.myConfig.settersShouldBeAbstract()) {
            setter.addModifier("abstract");
        }
        outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlTag, psiManager, (PsiMethod)setter, this, (Language)JavaLanguage.INSTANCE));
        if (this.myConfig.shouldGenerateGettersAndStaticMethods()) {
            DeprecatableLightMethodBuilder getter = this.createPublicMethod("get" + capitalizedName, type);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlTag, psiManager, (PsiMethod)getter, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    private void createStaticMethods(@NotNull List<PsiMethod> outPsiMethods) {
        XmlFile xmlFile = this.myConfig.getTargetLayout().toXmlFile();
        if (xmlFile == null) {
            return;
        }
        Project project = this.getProject();
        GlobalSearchScope moduleScope = this.getModuleScope();
        PsiClassType bindingType = PsiElementFactory.getInstance((Project)this.getProject()).createType((PsiClass)this);
        PsiClassType viewGroupType = PsiType.getTypeByName((String)"android.view.ViewGroup", (Project)project, (GlobalSearchScope)moduleScope);
        PsiClassType inflaterType = PsiType.getTypeByName((String)"android.view.LayoutInflater", (Project)project, (GlobalSearchScope)moduleScope);
        PsiClassType viewType = PsiType.getTypeByName((String)"android.view.View", (Project)project, (GlobalSearchScope)moduleScope);
        PsiClassType dataBindingComponentType = PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)moduleScope);
        ArrayList<DeprecatableLightMethodBuilder> methods2 = new ArrayList<DeprecatableLightMethodBuilder>();
        BindingXmlData xmlData = this.myConfig.getTargetLayout().getData();
        if (xmlData.getLayoutType() == BindingLayoutType.DATA_BINDING_LAYOUT) {
            DeprecatableLightMethodBuilder inflate4Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            inflate4Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            inflate4Params.addNullabilityParameter("root", (PsiType)viewGroupType, false);
            inflate4Params.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
            inflate4Params.addNullabilityParameter("bindingComponent", (PsiType)dataBindingComponentType, false);
            inflate4Params.setDeprecated(true);
            DeprecatableLightMethodBuilder inflate3Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            inflate3Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            inflate3Params.addNullabilityParameter("root", (PsiType)viewGroupType, false);
            inflate3Params.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
            DeprecatableLightMethodBuilder deprecatableLightMethodBuilder = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            deprecatableLightMethodBuilder.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            deprecatableLightMethodBuilder.addNullabilityParameter("bindingComponent", (PsiType)dataBindingComponentType, false);
            deprecatableLightMethodBuilder.setDeprecated(true);
            DeprecatableLightMethodBuilder inflate1Param = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            inflate1Param.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            DeprecatableLightMethodBuilder bind2 = this.createPublicStaticMethod("bind", (PsiType)bindingType, NullabilityType.NONNULL);
            bind2.addNullabilityParameter("view", (PsiType)viewType, true);
            DeprecatableLightMethodBuilder bindWithComponent = this.createPublicStaticMethod("bind", (PsiType)bindingType, NullabilityType.NONNULL);
            bindWithComponent.addNullabilityParameter("view", (PsiType)viewType, true);
            bindWithComponent.addNullabilityParameter("bindingComponent", (PsiType)dataBindingComponentType, false);
            bindWithComponent.setDeprecated(true);
            methods2.add(inflate1Param);
            methods2.add(deprecatableLightMethodBuilder);
            methods2.add(inflate3Params);
            methods2.add(inflate4Params);
            methods2.add(bind2);
            methods2.add(bindWithComponent);
        } else {
            assert (xmlData.getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && ViewBindingUtil.isViewBindingEnabled(this.myConfig.getFacet()));
            if (!xmlData.getRootTag().equals("merge")) {
                DeprecatableLightMethodBuilder inflate3Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
                inflate3Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
                inflate3Params.addNullabilityParameter("parent", (PsiType)viewGroupType, false);
                inflate3Params.addParameter("attachToParent", (PsiType)PsiType.BOOLEAN);
                DeprecatableLightMethodBuilder inflate1Param = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
                inflate1Param.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
                methods2.add(inflate1Param);
                methods2.add(inflate3Params);
            } else {
                DeprecatableLightMethodBuilder inflate2Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
                inflate2Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
                inflate2Params.addNullabilityParameter("parent", (PsiType)viewGroupType, true);
                methods2.add(inflate2Params);
            }
            DeprecatableLightMethodBuilder bind3 = this.createPublicStaticMethod("bind", (PsiType)bindingType, NullabilityType.NONNULL);
            bind3.addNullabilityParameter("view", (PsiType)viewType, true);
            methods2.add(bind3);
        }
        PsiManager psiManager = this.getManager();
        for (PsiMethod psiMethod : methods2) {
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlFile, psiManager, psiMethod, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicStaticMethod(@NotNull String name, @NotNull PsiType returnType, @NotNull NullabilityType nullabilityType) {
        DeprecatableLightMethodBuilder method2 = this.createPublicMethod(name, returnType, nullabilityType);
        method2.addModifier("static");
        return method2;
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicMethod(@NotNull String name, @NotNull PsiType returnType) {
        return this.createPublicMethod(name, returnType, NullabilityType.UNSPECIFIED);
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicMethod(@NotNull String name, @NotNull PsiType returnType, @NotNull NullabilityType nullabilityType) {
        DeprecatableLightMethodBuilder method2 = new DeprecatableLightMethodBuilder(this.getManager(), (Language)JavaLanguage.INSTANCE, name);
        method2.setContainingClass((PsiClass)this);
        if (nullabilityType == NullabilityType.UNSPECIFIED) {
            method2.setMethodReturnType(returnType);
        } else {
            method2.setMethodReturnType(returnType, !nullabilityType.isNullable());
        }
        method2.addModifier("public");
        return method2;
    }

    @Nullable
    private PsiField createPsiField(@NotNull ViewIdData viewIdData, boolean isNonNull) {
        String name = DataBindingUtil.convertAndroidIdToJavaFieldName(viewIdData.getId());
        PsiType type = LayoutBindingTypeUtil.resolveViewPsiType(viewIdData, (PsiElement)this);
        if (type == null) {
            return null;
        }
        NullabilityLightFieldBuilder field2 = new NullabilityLightFieldBuilder(PsiManager.getInstance((Project)this.getProject()), name, type, isNonNull, new String[]{"public", "final"});
        return new LightDataBindingField(this.myConfig.getTargetLayout(), viewIdData, this.getManager(), (PsiField)field2, this);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlFile xmlFile = this.myConfig.getTargetLayout().toXmlFile();
        if (xmlFile == null) {
            return super.getNavigationElement();
        }
        return new BindingLayoutFile(this, xmlFile);
    }

    @NotNull
    public String getName() {
        return this.myConfig.getClassName();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myBackingFile;
    }

    public boolean isValid() {
        return true;
    }

    public static class LightDataBindingField
    extends LightField {
        private final BindingLayout myLayout;
        private final ViewIdData myViewIdData;
        @Nullable
        private XmlTag myNavigationTag = null;

        public LightDataBindingField(@NotNull BindingLayout layout2, @NotNull ViewIdData viewIdData, @NotNull PsiManager manager, @NotNull PsiField field2, @NotNull PsiClass containingClass) {
            super(manager, field2, containingClass);
            this.myLayout = layout2;
            this.myViewIdData = viewIdData;
        }

        @Nullable
        private XmlTag computeTag() {
            XmlFile xmlFile = this.myLayout.toXmlFile();
            if (xmlFile == null) {
                return null;
            }
            final Ref resultTag = new Ref();
            xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    String idValue = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                    if (idValue != null && myViewIdData.getId().equals(ResourcesUtil.stripPrefixFromId((String)idValue))) {
                        resultTag.set((Object)tag);
                        this.stopWalking();
                    }
                }
            });
            return (XmlTag)resultTag.get();
        }

        @Nullable
        public PsiFile getContainingFile() {
            return this.myLayout.toXmlFile();
        }

        public TextRange getTextRange() {
            return TextRange.EMPTY_RANGE;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            if (this.myNavigationTag != null) {
                return this.myNavigationTag;
            }
            this.myNavigationTag = this.computeTag();
            return this.myNavigationTag != null ? this.myNavigationTag : super.getNavigationElement();
        }

        @NotNull
        public PsiElement setName(@NotNull String name) {
            return this;
        }
    }

    public static class LightDataBindingMethod
    extends LightMethod {
        private PsiElement myNavigationElement;

        public LightDataBindingMethod(@NotNull PsiElement navigationElement, @NotNull PsiManager manager, @NotNull PsiMethod method2, @NotNull PsiClass containingClass, @NotNull Language language) {
            super(manager, method2, containingClass, language);
            this.myNavigationElement = navigationElement;
        }

        public TextRange getTextRange() {
            return TextRange.EMPTY_RANGE;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.myNavigationElement;
        }

        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.getManager(), this.getName());
        }
    }

    private static enum NullabilityType {
        UNSPECIFIED,
        NONNULL,
        NULLABLE;


        public boolean isNullable() {
            return this == NULLABLE;
        }
    }
}

