/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationManager
implements Disposable {
    private static final Key<ConfigurationManager> KEY = Key.create((String)ConfigurationManager.class.getName());
    @NotNull
    private final Module myModule;
    private final Map<VirtualFile, Configuration> myCache = ContainerUtil.createSoftValueMap();
    private Device myDefaultDevice;
    private Locale myLocale;
    private IAndroidTarget myTarget;
    private int myStateVersion;
    private ResourceResolverCache myResolverCache;

    @NotNull
    public static ConfigurationManager getOrCreateInstance(@NotNull AndroidFacet androidFacet) {
        return ConfigurationManager.findConfigurationManager(androidFacet, true);
    }

    @NotNull
    public static ConfigurationManager getOrCreateInstance(@NotNull Module module2) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            throw new IllegalArgumentException("Module '" + module2.getName() + "' is not an Android module");
        }
        return ConfigurationManager.findConfigurationManager(androidFacet, true);
    }

    @Nullable
    public static ConfigurationManager findExistingInstance(@NotNull Module module2) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            throw new IllegalArgumentException("Module '" + module2.getName() + "' is not an Android module");
        }
        return ConfigurationManager.findConfigurationManager(androidFacet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static ConfigurationManager findConfigurationManager(@NotNull AndroidFacet androidFacet, boolean createIfNecessary) {
        Module module2 = androidFacet.getModule();
        ConfigurationManager configurationManager = (ConfigurationManager)module2.getUserData(KEY);
        if (configurationManager == null && createIfNecessary) {
            configurationManager = new ConfigurationManager(module2);
            module2.putUserData(KEY, (Object)configurationManager);
        }
        return configurationManager;
    }

    public ConfigurationManager(@NotNull Module module2) {
        this.myModule = module2;
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    @Slow
    @NotNull
    public Configuration getConfiguration(@NotNull VirtualFile file2) {
        Configuration configuration = this.myCache.get(file2);
        if (configuration == null) {
            configuration = this.create(file2);
            this.myCache.put(file2, configuration);
        }
        return configuration;
    }

    boolean hasCachedConfiguration(@NotNull VirtualFile file2) {
        return this.myCache.get(file2) != null;
    }

    @Slow
    @NotNull
    private Configuration create(@NotNull VirtualFile file2) {
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(file2);
        assert (file2.getParent() != null) : file2;
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file2.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file2, fileState, config);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, file2);
        if (fileState != null) {
            matcher.adaptConfigSelection(true);
        } else {
            matcher.findAndSetCompatibleConfig(false);
        }
        return configuration;
    }

    @NotNull
    public Configuration createSimilar(@NotNull VirtualFile file2, @NotNull VirtualFile baseFile) {
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(baseFile);
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file2.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file2, fileState, config);
        Configuration baseConfig = this.myCache.get(file2);
        if (baseConfig != null) {
            configuration.setEffectiveDevice(baseConfig.getDevice(), baseConfig.getDeviceState());
        }
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, file2);
        matcher.adaptConfigSelection(true);
        this.myCache.put(file2, configuration);
        return configuration;
    }

    public ConfigurationStateManager getStateManager() {
        return ConfigurationStateManager.get(this.myModule.getProject());
    }

    @Slow
    @NotNull
    public ImmutableList<Device> getDevices() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        if (platform == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)platform.getSdkData().getDeviceManager().getDevices(DeviceManager.ALL_DEVICES));
    }

    @Nullable
    public Device getDeviceById(@NotNull String id) {
        return this.getDevices().stream().filter(device -> device.getId().equals(id)).findFirst().orElse(null);
    }

    @Nullable
    public Device createDeviceForAvd(@NotNull AvdInfo avd) {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        if (platform == null) {
            return null;
        }
        Device modelDevice = platform.getSdkData().getDeviceManager().getDevice(avd.getDeviceName(), avd.getDeviceManufacturer());
        if (modelDevice == null) {
            return null;
        }
        String avdName = avd.getName();
        Device.Builder builder2 = new Device.Builder(modelDevice);
        builder2.setName(avdName);
        builder2.setId("_android_virtual_device_id_" + avdName);
        return builder2.build();
    }

    public static boolean isAvdDevice(@NotNull Device device) {
        return device.getId().startsWith("_android_virtual_device_id_");
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        if (platform != null) {
            AndroidSdkData sdkData = platform.getSdkData();
            return sdkData.getTargets();
        }
        return new IAndroidTarget[0];
    }

    public static boolean isLayoutLibTarget(@NotNull IAndroidTarget target) {
        return target.isPlatform() && target.hasRenderingLibrary();
    }

    @Nullable
    public IAndroidTarget getHighestApiTarget() {
        IAndroidTarget[] targetList = this.getTargets();
        for (int i2 = targetList.length - 1; i2 >= 0; --i2) {
            IAndroidTarget target = targetList[i2];
            if (!ConfigurationManager.isLayoutLibTarget(target) || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    private static boolean isLayoutLibSupported(IAndroidTarget target) {
        if (target instanceof PlatformTarget) {
            int layoutlibVersion = ((PlatformTarget)target).getLayoutlibApi();
            return layoutlibVersion <= 17;
        }
        return false;
    }

    @NotNull
    public String computePreferredTheme(@NotNull Configuration configuration) {
        String appTheme;
        String activityName = configuration.getActivity();
        if (activityName != null) {
            String theme;
            String activityFqcn = activityName;
            if (activityName.startsWith(".")) {
                String packageName = AndroidManifestUtils.getPackageName(this.myModule);
                activityFqcn = packageName + activityName;
            }
            if ((theme = ThemeUtils.getThemeNameForActivity(this.myModule, activityFqcn)) != null) {
                return theme;
            }
        }
        if ((appTheme = ThemeUtils.getAppThemeName(this.myModule)) != null) {
            return appTheme;
        }
        return ThemeUtils.getDefaultTheme(this.myModule, configuration.getTarget(), configuration.getScreenSize(), configuration.getCachedDevice());
    }

    @NotNull
    public final Module getModule() {
        return this.myModule;
    }

    @NotNull
    public Project getProject() {
        return this.myModule.getProject();
    }

    public void dispose() {
        this.myModule.putUserData(KEY, null);
    }

    @Nullable
    public Device getDefaultDevice() {
        ImmutableList<Device> devices2;
        if (this.myDefaultDevice == null && !(devices2 = this.getDevices()).isEmpty()) {
            Device device = (Device)devices2.get(0);
            for (Device d : devices2) {
                String id = d.getId();
                if (id.equals("pixel")) {
                    device = d;
                    break;
                }
                if (!id.equals("Galaxy Nexus")) continue;
                device = d;
            }
            this.myDefaultDevice = device;
        }
        return this.myDefaultDevice;
    }

    @Nullable
    public IAndroidTarget getDefaultTarget() {
        return this.getHighestApiTarget();
    }

    @NotNull
    public ImmutableList<Locale> getLocalesInProject() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myModule);
        assert (repositoryManager != null);
        return repositoryManager.getLocalesInProject();
    }

    @Nullable
    public IAndroidTarget getProjectTarget() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        return platform != null ? platform.getTarget() : null;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            String localeString = this.getStateManager().getProjectState().getLocale();
            this.myLocale = localeString != null ? ConfigurationProjectState.fromLocaleString(localeString) : Locale.ANY;
        }
        return this.myLocale;
    }

    public void setLocale(@NotNull Locale locale) {
        if (!locale.equals(this.myLocale)) {
            this.myLocale = locale;
            ++this.myStateVersion;
            this.getStateManager().getProjectState().setLocale(ConfigurationProjectState.toLocaleString(locale));
            for (Configuration configuration : this.myCache.values()) {
                configuration.updated(16);
            }
        }
    }

    public List<Device> getRecentDevices() {
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        if (deviceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList devices2 = Lists.newArrayListWithExpectedSize((int)deviceIds.size());
        ListIterator<String> iterator = deviceIds.listIterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            Device device = this.getDeviceById(id);
            if (device != null) {
                devices2.add(device);
                continue;
            }
            iterator.remove();
        }
        return devices2;
    }

    public void selectDevice(@NotNull Device device) {
        String id = device.getId();
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        deviceIds.remove(id);
        deviceIds.add(0, id);
        while (deviceIds.size() > 10) {
            deviceIds.remove(deviceIds.size() - 1);
        }
        ++this.myStateVersion;
        for (Configuration configuration : this.myCache.values()) {
            boolean updateTheme = false;
            String theme = configuration.getTheme();
            if (theme.startsWith("@android:style/")) {
                updateTheme = true;
                configuration.startBulkEditing();
                configuration.setTheme(null);
            }
            configuration.updated(2);
            if (!updateTheme) continue;
            configuration.finishBulkEditing();
        }
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            ConfigurationProjectState projectState = this.getStateManager().getProjectState();
            if (projectState.isPickTarget()) {
                this.myTarget = this.getDefaultTarget();
            } else {
                String targetString = projectState.getTarget();
                this.myTarget = ConfigurationProjectState.fromTargetString(this, targetString);
                if (this.myTarget == null) {
                    this.myTarget = this.getDefaultTarget();
                }
            }
            return this.myTarget;
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getTarget(int min) {
        IAndroidTarget target = this.getTarget();
        if (target != null && target.getVersion().getApiLevel() >= min) {
            return target;
        }
        IAndroidTarget[] targetList = this.getTargets();
        for (int i2 = targetList.length - 1; i2 >= 0; --i2) {
            target = targetList[i2];
            if (!ConfigurationManager.isLayoutLibTarget(target) || target.getVersion().getFeatureLevel() < min || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    public void setTarget(@Nullable IAndroidTarget target) {
        if (target != this.myTarget) {
            AndroidTargetData targetData;
            if (this.myTarget != null && (targetData = AndroidTargetData.getTargetData(this.myTarget, this.myModule)) != null) {
                targetData.clearLayoutBitmapCache(this.myModule);
            }
            this.myTarget = target;
            if (target != null) {
                this.getStateManager().getProjectState().setTarget(ConfigurationProjectState.toTargetString(target));
                ++this.myStateVersion;
                for (Configuration configuration : this.myCache.values()) {
                    configuration.updated(32);
                }
            }
        }
    }

    public int getStateVersion() {
        return this.myStateVersion;
    }

    @NotNull
    public ResourceResolverCache getResolverCache() {
        if (this.myResolverCache == null) {
            this.myResolverCache = new ResourceResolverCache(this);
        }
        return this.myResolverCache;
    }
}

