/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.idea.common.surface.MouseClickDisplayPanelKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/common/surface/MouseClickDisplayPanel;", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "durationMs", "", "decorationColor", "Ljava/awt/Color;", "startRadius", "", "endRadius", "(Lcom/intellij/openapi/Disposable;JLjava/awt/Color;II)V", "clickListener", "Ljava/awt/event/AWTEventListener;", "clickPosition", "Ljava/awt/Point;", "endTimeMillis", "isMouseTrackingEnabled", "", "disableMouseClickDisplay", "", "dispose", "enableMouseClickDisplay", "paintComponent", "g", "Ljava/awt/Graphics;", "setEnabled", "enabled", "intellij.android.designer"})
public final class MouseClickDisplayPanel
extends JComponent
implements Disposable {
    private boolean isMouseTrackingEnabled;
    private long endTimeMillis;
    private Point clickPosition;
    private final AWTEventListener clickListener;
    private final long durationMs;
    private final Color decorationColor;
    private final int startRadius;
    private final int endRadius;

    private final void enableMouseClickDisplay() {
        if (!this.isMouseTrackingEnabled) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.clickListener, 16L);
            this.isMouseTrackingEnabled = true;
        }
    }

    private final void disableMouseClickDisplay() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.clickListener);
        this.isMouseTrackingEnabled = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.enableMouseClickDisplay();
        } else {
            this.disableMouseClickDisplay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        block6: {
            Point point = this.clickPosition;
            if (point == null) break block6;
            Point point2 = point;
            boolean bl = false;
            boolean bl2 = false;
            Point it = point2;
            boolean bl3 = false;
            long animationTime = this.endTimeMillis - System.currentTimeMillis();
            if (animationTime < 0L) {
                this.clickPosition = null;
                return;
            }
            float animationPosition = (float)(this.durationMs - animationTime) / (float)this.durationMs;
            Graphics graphics = g.create();
            if (graphics == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                GraphicsUtilKt.setColorAndAlpha((Graphics2D)g2d, (Color)this.decorationColor);
                int radius = this.startRadius + (int)((float)this.endRadius * animationPosition);
                g2d.fillOval(it.x - radius, it.y - radius, radius * 2, radius * 2);
            }
            finally {
                g2d.dispose();
            }
            this.repaint();
        }
    }

    public void dispose() {
        this.disableMouseClickDisplay();
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs, @NotNull Color decorationColor, int startRadius, int endRadius) {
        this.durationMs = durationMs;
        this.decorationColor = decorationColor;
        this.startRadius = startRadius;
        this.endRadius = endRadius;
        this.endTimeMillis = Long.MAX_VALUE;
        this.clickListener = new AWTEventListener(this){
            final /* synthetic */ MouseClickDisplayPanel this$0;

            public final void eventDispatched(AWTEvent it) {
                Point clickPoint;
                if (!(it instanceof MouseEvent)) {
                    return;
                }
                if (it.getID() == 500 && ((MouseEvent)it).getClickCount() == 1 && this.this$0.isEnabled() && this.this$0.isVisible() && this.this$0.contains(clickPoint = SwingUtilities.convertPoint(((MouseEvent)it).getComponent(), ((MouseEvent)it).getPoint(), this.this$0))) {
                    MouseClickDisplayPanel.access$setClickPosition$p(this.this$0, ((MouseEvent)it).getPoint());
                    MouseClickDisplayPanel.access$setEndTimeMillis$p(this.this$0, System.currentTimeMillis() + MouseClickDisplayPanel.access$getDurationMs$p(this.this$0));
                    this.this$0.repaint();
                }
            }
            {
                this.this$0 = mouseClickDisplayPanel;
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setEnabled(false);
    }

    public /* synthetic */ MouseClickDisplayPanel(Disposable disposable2, long l, Color color, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            l = 100L;
        }
        if ((n3 & 4) != 0) {
            color = MouseClickDisplayPanelKt.access$getDEFAULT_DECORATION_COLOR$p();
        }
        if ((n3 & 8) != 0) {
            n = 10;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 20;
        }
        this(disposable2, l, color, n, n2);
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs, @NotNull Color decorationColor, int startRadius) {
        this(parentDisposable, durationMs, decorationColor, startRadius, 0, 16, null);
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs, @NotNull Color decorationColor) {
        this(parentDisposable, durationMs, decorationColor, 0, 0, 24, null);
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable, long durationMs) {
        this(parentDisposable, durationMs, null, 0, 0, 28, null);
    }

    @JvmOverloads
    public MouseClickDisplayPanel(@NotNull Disposable parentDisposable) {
        this(parentDisposable, 0L, null, 0, 0, 30, null);
    }

    public static final /* synthetic */ Point access$getClickPosition$p(MouseClickDisplayPanel $this) {
        return $this.clickPosition;
    }

    public static final /* synthetic */ void access$setClickPosition$p(MouseClickDisplayPanel $this, Point point) {
        $this.clickPosition = point;
    }

    public static final /* synthetic */ long access$getEndTimeMillis$p(MouseClickDisplayPanel $this) {
        return $this.endTimeMillis;
    }

    public static final /* synthetic */ void access$setEndTimeMillis$p(MouseClickDisplayPanel $this, long l) {
        $this.endTimeMillis = l;
    }

    public static final /* synthetic */ long access$getDurationMs$p(MouseClickDisplayPanel $this) {
        return $this.durationMs;
    }
}

