/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.DefaultModelUpdater;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.NlModelBuilder;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerEditorFileTypeKt;
import com.android.tools.idea.common.util.XmlTagUtil;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderUtils;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModel
implements Disposable,
ResourceNotificationManager.ResourceChangeListener,
ModificationTracker {
    public static final int DELAY_AFTER_TYPING_MS = 250;
    static final boolean CHECK_MODEL_INTEGRITY = false;
    private final Set<String> myPendingIds = Sets.newHashSet();
    @NotNull
    private final AndroidFacet myFacet;
    private final VirtualFile myFile;
    private final Configuration myConfiguration;
    private final ListenerCollection<ModelListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private String myModelDisplayName;
    @Nullable
    private NlComponent myRootComponent;
    private LintAnnotationsModel myLintAnnotationsModel;
    private final long myId;
    private final Set<Object> myActivations = Collections.newSetFromMap(new WeakHashMap());
    private final ModelVersion myModelVersion = new ModelVersion();
    private final DesignerEditorFileType myType;
    private long myConfigurationModificationCount;
    private final MergingUpdateQueue myUpdateQueue;
    private ChangeType myModificationTrigger;
    private final BiFunction<Project, VirtualFile, XmlFile> myXmlFileProvider;
    @NotNull
    private final Consumer<NlComponent> myComponentRegistrar;
    @NotNull
    private final NlModelUpdaterInterface myModelUpdater;
    @NotNull
    private DataContext myDataContext;

    @NotNull
    public static NlModelBuilder builder(@NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration) {
        return new NlModelBuilder(facet2, file2, configuration);
    }

    @Slow
    @NotNull
    static NlModel create(@Nullable Disposable parent, @Nullable String modelDisplayName, @NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration, @NotNull Consumer<NlComponent> componentRegistrar2, @NotNull BiFunction<Project, VirtualFile, XmlFile> xmlFileProvider2, @Nullable NlModelUpdaterInterface modelUpdater, @NotNull DataContext dataContext) {
        return new NlModel(parent, modelDisplayName, facet2, file2, configuration, componentRegistrar2, xmlFileProvider2, modelUpdater, dataContext);
    }

    protected NlModel(@Nullable Disposable parent, @Nullable String modelDisplayName, @NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration, @NotNull Consumer<NlComponent> componentRegistrar2, @NotNull DataContext dataContext) {
        this(parent, modelDisplayName, facet2, file2, configuration, componentRegistrar2, NlModel::getDefaultXmlFile, null, dataContext);
    }

    @VisibleForTesting
    protected NlModel(@Nullable Disposable parent, @Nullable String modelDisplayName, @NotNull AndroidFacet facet2, @NotNull VirtualFile file2, @NotNull Configuration configuration, @NotNull Consumer<NlComponent> componentRegistrar2, @NotNull BiFunction<Project, VirtualFile, XmlFile> xmlFileProvider2, @Nullable NlModelUpdaterInterface modelUpdater, @NotNull DataContext dataContext) {
        this.myFacet = facet2;
        this.myXmlFileProvider = xmlFileProvider2;
        this.myModelDisplayName = modelDisplayName;
        this.myFile = file2;
        this.myConfiguration = configuration;
        this.myComponentRegistrar = componentRegistrar2;
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myId = System.nanoTime() ^ (long)file2.getName().hashCode();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.myType = DesignerEditorFileTypeKt.typeOf((PsiFile)this.getFile());
        this.myUpdateQueue = new MergingUpdateQueue("android.layout.preview.edit", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        this.myModelUpdater = modelUpdater == null ? new DefaultModelUpdater() : modelUpdater;
        this.myDataContext = dataContext;
    }

    @NotNull
    @VisibleForTesting
    public MergingUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(@NotNull Object source) {
        boolean wasActive;
        if (this.getFacet().isDisposed()) {
            return false;
        }
        Set<Object> set = this.myActivations;
        synchronized (set) {
            wasActive = !this.myActivations.isEmpty();
            this.myActivations.add(source);
        }
        if (!wasActive) {
            if (this.myConfiguration.getModificationCount() != this.myConfigurationModificationCount) {
                this.updateTheme();
            }
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
            manager.addListener(this, this.myFacet, this.myFile, this.myConfiguration);
            this.myListeners.forEach(listener2 -> listener2.modelActivated(this));
            return true;
        }
        return false;
    }

    public void updateTheme() {
        ResourceResolver resolver;
        ResourceUrl themeUrl = ResourceUrl.parse((String)this.myConfiguration.getTheme());
        if (themeUrl != null && themeUrl.type == ResourceType.STYLE && ((resolver = this.myConfiguration.getResourceResolver()) == null || resolver.getTheme(themeUrl.name, themeUrl.isFramework()) == null)) {
            this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
        }
    }

    private void deactivate() {
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
        manager.removeListener(this, this.myFacet, this.myFile, this.myConfiguration);
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(@NotNull Object source) {
        boolean shouldDeactivate;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            boolean removed = this.myActivations.remove(source);
            shouldDeactivate = removed && this.myActivations.isEmpty();
        }
        if (shouldDeactivate) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    @NotNull
    private static XmlFile getDefaultXmlFile(Project project, VirtualFile virtualFile) {
        XmlFile file2 = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile);
        return (XmlFile)Verify.verifyNotNull((Object)file2);
    }

    @NotNull
    public XmlFile getFile() {
        return this.myXmlFileProvider.apply(this.getProject(), this.myFile);
    }

    @NotNull
    public DesignerEditorFileType getType() {
        return this.myType;
    }

    @Nullable
    public LintAnnotationsModel getLintAnnotationsModel() {
        return this.myLintAnnotationsModel;
    }

    public void setLintAnnotationsModel(@Nullable LintAnnotationsModel model2) {
        this.myLintAnnotationsModel = model2;
    }

    @NotNull
    public Set<String> getPendingIds() {
        return this.myPendingIds;
    }

    public void syncWithPsi(@NotNull XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
        this.myModelUpdater.update(this, newRoot, roots);
    }

    protected void setRootComponent(NlComponent root2) {
        this.myRootComponent = root2;
    }

    public void checkStructure() {
    }

    private void checkUnique(NlComponent component, Set<NlComponent> unique) {
    }

    private void checkUnique(XmlTag tag, Set<XmlTag> unique) {
    }

    private void checkStructure(NlComponent component) {
    }

    public void addListener(@NotNull ModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void notifyListenersModelDerivedDataChanged() {
        this.myListeners.forEach(listener2 -> listener2.modelDerivedDataChanged(this));
    }

    public void notifyListenersModelChangedOnLayout(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelChangedOnLayout(this, animate));
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public Module getModule() {
        return this.myFacet.getModule();
    }

    @NotNull
    public Project getProject() {
        return this.getModule().getProject();
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public ImmutableList<NlComponent> getComponents() {
        return this.myRootComponent != null ? ImmutableList.of((Object)this.myRootComponent) : ImmutableList.of();
    }

    @NotNull
    public Stream<NlComponent> flattenComponents() {
        return this.myRootComponent != null ? Stream.of(this.myRootComponent).flatMap(NlComponent::flatten) : Stream.empty();
    }

    public void notifyLiveUpdate(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelLiveUpdate(this, animate));
    }

    @NotNull
    public ImmutableList<NlComponent> findByOffset(int offset2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.getFile(), (int)offset2, XmlTag.class, (boolean)false);
        return tag != null ? this.findViewsByTag(tag) : ImmutableList.of();
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        return this.myRootComponent != null ? this.myRootComponent.findViewByTag(tag) : null;
    }

    @Nullable
    public NlComponent find(@NotNull String id) {
        return this.flattenComponents().filter(c -> id.equals(c.getId())).findFirst().orElse(null);
    }

    @Nullable
    public NlComponent find(@NotNull Predicate<NlComponent> condition) {
        return this.flattenComponents().filter(condition).findFirst().orElse(null);
    }

    @NotNull
    private ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (this.myRootComponent == null) {
            return ImmutableList.of();
        }
        return this.myRootComponent.findViewsByTag(tag);
    }

    @Nullable
    public NlComponent findViewByPsi(@Nullable PsiElement element2) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element2 != null) {
            if (element2 instanceof XmlTag) {
                return this.findViewByTag((XmlTag)element2);
            }
            element2 = element2.getParent();
        }
        return null;
    }

    @Nullable
    public ResourceReference findAttributeByPsi(@NotNull PsiElement element2) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element2 != null) {
            if (element2 instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)element2;
                ResourceNamespace namespace = IdeResourcesUtil.resolveResourceNamespace((XmlElement)attribute, attribute.getNamespacePrefix());
                if (namespace == null) {
                    return null;
                }
                return ResourceReference.attr((ResourceNamespace)namespace, (String)attribute.getLocalName());
            }
            element2 = element2.getParent();
        }
        return null;
    }

    public void delete(Collection<NlComponent> components) {
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)"Delete Component", null, () -> NlModel.handleDeletion(components), (PsiFile[])new PsiFile[]{this.getFile()});
        this.notifyModified(ChangeType.DELETE);
    }

    private static void handleDeletion(@NotNull Collection<NlComponent> components) {
        Multimap<NlComponent, NlComponent> siblingLists = NlComponentUtil.groupSiblings(components);
        for (NlComponent parent : siblingLists.keySet()) {
            if (parent == null) continue;
            Collection children = siblingLists.get((Object)parent);
            if (parent.getMixin().maybeHandleDeletion(children)) continue;
            for (NlComponent component : children) {
                XmlTag tag;
                NlComponent p = component.getParent();
                if (p != null) {
                    p.removeChild(component);
                }
                if (!(tag = component.getTagDeprecated()).isValid()) continue;
                PsiElement parentTag = tag.getParent();
                tag.delete();
                if (!(parentTag instanceof XmlTag)) continue;
                ((XmlTag)parentTag).collapseIfEmpty();
            }
        }
    }

    @Nullable
    public NlComponent createComponent(@Nullable DesignSurface surface2, @NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        XmlTag addedTag = tag;
        if (parent != null) {
            XmlTag parentTag = parent.getTagDeprecated();
            addedTag = (XmlTag)WriteAction.compute(() -> {
                if (before != null) {
                    return (XmlTag)parentTag.addBefore((PsiElement)tag, (PsiElement)before.getTagDeprecated());
                }
                return parentTag.addSubTag(tag, false);
            });
        }
        NlComponent child = this.createComponent(addedTag);
        if (parent != null) {
            parent.addChild(child, before);
        }
        if (child.postCreate(surface2, insertType)) {
            return child;
        }
        return null;
    }

    @NotNull
    public NlComponent createComponent(@NotNull XmlTag tag) {
        NlComponent component = new NlComponent(this, tag);
        this.myComponentRegistrar.accept(component);
        return component;
    }

    @NotNull
    public List<NlComponent> createComponents(@NotNull DnDTransferItem item, @NotNull InsertType insertType, @NotNull DesignSurface surface2) {
        ArrayList<NlComponent> components = new ArrayList<NlComponent>(item.getComponents().size());
        for (DnDTransferComponent dndComponent : item.getComponents()) {
            XmlTag tag = XmlTagUtil.createTag(this.getProject(), dndComponent.getRepresentation());
            NlComponent component = this.createComponent(surface2, tag, null, null, insertType);
            if (component == null) {
                return Collections.emptyList();
            }
            component.postCreateFromTransferrable(dndComponent);
            components.add(component);
        }
        return components;
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        return this.canAddComponents(toAdd, receiver, before, false);
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, boolean ignoreMissingDependencies) {
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        if (toAdd.isEmpty()) {
            return false;
        }
        if (toAdd.stream().anyMatch(c -> !c.canAddTo(receiver))) {
            return false;
        }
        if (NlComponentUtil.isDescendant(receiver, toAdd)) {
            return false;
        }
        return ignoreMissingDependencies || this.checkIfUserWantsToAddDependencies(toAdd);
    }

    private boolean checkIfUserWantsToAddDependencies(List<NlComponent> toAdd) {
        return NlDependencyManager.getInstance().checkIfUserWantsToAddDependencies(toAdd, this.getFacet());
    }

    public void addComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2) {
        this.addComponents(toAdd, receiver, before, insertType, surface2, null);
    }

    public void addComponents(@NotNull List<NlComponent> componentToAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2, @Nullable Runnable attributeUpdatingTask) {
        this.addComponents(componentToAdd, receiver, before, insertType, surface2, attributeUpdatingTask, null);
    }

    public void addComponents(@NotNull List<NlComponent> componentToAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2, @Nullable Runnable attributeUpdatingTask, @Nullable String groupId) {
        ImmutableList toAdd = ImmutableList.copyOf(componentToAdd);
        if (!this.canAddComponents((List<NlComponent>)toAdd, receiver, before, insertType == InsertType.MOVE_WITHIN)) {
            return;
        }
        Runnable callback2 = () -> this.addComponentInWriteCommand((List<NlComponent>)toAdd, receiver, before, insertType, surface2, attributeUpdatingTask, groupId);
        if (insertType != InsertType.MOVE_WITHIN) {
            NlDependencyManager.getInstance().addDependenciesAsync((Iterable<? extends NlComponent>)toAdd, this.getFacet(), "Adding Components...", callback2);
        } else {
            callback2.run();
        }
    }

    private void addComponentInWriteCommand(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2, @Nullable Runnable attributeUpdatingTask, @Nullable String groupId) {
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
            NlWriteCommandActionUtil.run(toAdd, NlModel.generateAddComponentsDescription(toAdd, insertType), groupId, () -> {
                if (attributeUpdatingTask != null) {
                    attributeUpdatingTask.run();
                }
                this.handleAddition(toAdd, receiver, before, insertType, surface2);
            });
            this.notifyModified(ChangeType.ADD_COMPONENTS);
            if (insertType == InsertType.CREATE && surface2 != null) {
                surface2.getSelectionModel().setSelection(toAdd);
            }
        });
    }

    @NotNull
    private static String generateAddComponentsDescription(@NotNull List<NlComponent> toAdd, @NotNull InsertType insertType) {
        DragType dragType = insertType.getDragType();
        String componentType = "";
        if (toAdd.size() == 1) {
            String tagName = toAdd.get(0).getTagName();
            componentType = tagName.substring(tagName.lastIndexOf(46) + 1);
        }
        return dragType.getDescription(componentType);
    }

    public void addTags(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        NlWriteCommandActionUtil.run(added, NlModel.generateAddComponentsDescription(added, insertType), () -> {
            for (NlComponent component : added) {
                component.addTags(receiver, before, insertType);
            }
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    @NotNull
    public Set<String> getIds() {
        LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(this.getFacet());
        HashSet<String> ids2 = new HashSet<String>(resources.getResources(ResourceNamespace.TODO(), ResourceType.ID).keySet());
        Set<String> pendingIds = this.getPendingIds();
        if (!pendingIds.isEmpty()) {
            HashSet<String> all = new HashSet<String>(pendingIds.size() + ids2.size());
            all.addAll(ids2);
            all.addAll(pendingIds);
            ids2 = all;
        }
        return ids2;
    }

    private void handleAddition(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface2) {
        Set<String> ids2 = this.getIds();
        for (NlComponent component : added) {
            component.moveTo(receiver, before, insertType, ids2, surface2);
        }
    }

    @NotNull
    public InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview) {
        if (item != null && item.isFromPalette()) {
            return asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
        }
        switch (dragType) {
            case CREATE: {
                return asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
            }
            case MOVE: {
                return item != null && this.myId != item.getModelId() ? InsertType.COPY : InsertType.MOVE_INTO;
            }
            case COPY: {
                return InsertType.COPY;
            }
        }
        return InsertType.PASTE;
    }

    public long getId() {
        return this.myId;
    }

    public void setModelDisplayName(@Nullable String name) {
        this.myModelDisplayName = name;
    }

    @Nullable
    public String getModelDisplayName() {
        return this.myModelDisplayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean shouldDeactivate;
        this.myLintAnnotationsModel = null;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            shouldDeactivate = !this.myActivations.isEmpty();
            this.myActivations.clear();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
        this.myListeners.clear();
    }

    @NotNull
    public String toString() {
        return NlModel.class.getSimpleName() + " for " + this.myFile;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
        for (ResourceNotificationManager.Reason r : reason) {
            switch (r) {
                case RESOURCE_EDIT: {
                    this.notifyModifiedViaUpdateQueue(ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.notifyModifiedViaUpdateQueue(ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection<Configuration>)ImmutableList.of((Object)this.getConfiguration()));
                    this.notifyModified(ChangeType.RESOURCE_CHANGED);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    RenderUtils.clearCache((ImmutableCollection<Configuration>)ImmutableList.of((Object)this.getConfiguration()));
                    this.notifyModified(ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.notifyModified(ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    public long getModificationCount() {
        return this.myModelVersion.getVersion();
    }

    public long getConfigurationModificationCount() {
        return this.myConfigurationModificationCount;
    }

    public void notifyModified(@NotNull ChangeType reason) {
        this.myModelVersion.increase(reason);
        this.updateTheme();
        this.myModificationTrigger = reason;
        this.myListeners.forEach(listener2 -> listener2.modelChanged(this));
    }

    public void notifyModifiedViaUpdateQueue(final @NotNull ChangeType reason) {
        this.myUpdateQueue.queue(new Update("edit"){

            public void run() {
                NlModel.this.notifyModified(reason);
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    @Nullable
    public ChangeType getLastChangeType() {
        return this.myModificationTrigger;
    }

    public void resetLastChange() {
        this.myModificationTrigger = null;
    }

    @NotNull
    public final DataContext getDataContext() {
        return this.myDataContext;
    }

    public final void setDataContext(@NotNull DataContext dataContext) {
        this.myDataContext = dataContext;
    }

    private /* synthetic */ void lambda$checkStructure$1() {
        Set unique = Sets.newIdentityHashSet();
        Set uniqueTags = Sets.newIdentityHashSet();
        this.checkUnique(this.getFile().getRootTag(), uniqueTags);
        uniqueTags.clear();
        if (this.myRootComponent != null) {
            this.checkUnique(this.myRootComponent.getTagDeprecated(), uniqueTags);
            this.checkUnique(this.myRootComponent, unique);
            this.checkStructure(this.myRootComponent);
        }
    }

    static class ModelVersion {
        private final AtomicLong myVersion = new AtomicLong();
        ChangeType mLastReason;

        ModelVersion() {
        }

        public void increase(ChangeType reason) {
            this.myVersion.incrementAndGet();
            this.mLastReason = reason;
        }

        public long getVersion() {
            return this.myVersion.get();
        }
    }

    public static enum ChangeType {
        RESOURCE_EDIT,
        EDIT,
        RESOURCE_CHANGED,
        ADD_COMPONENTS,
        DELETE,
        DND_COMMIT,
        DND_END,
        DROP,
        RESIZE_END,
        RESIZE_COMMIT,
        UPDATE_HIERARCHY,
        BUILD,
        CONFIGURATION_CHANGE;

    }

    public static interface TagSnapshotTreeNode {
        @Nullable
        public TagSnapshot getTagSnapshot();

        @NotNull
        public List<TagSnapshotTreeNode> getChildren();
    }

    public static interface NlModelUpdaterInterface {
        public void update(@NotNull NlModel var1, @Nullable XmlTag var2, @NotNull List<TagSnapshotTreeNode> var3);
    }
}

