/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.AttributesHelperKt;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponentBackend;
import com.android.tools.idea.common.model.NlComponentBackendXml;
import com.android.tools.idea.common.model.NlComponentModificationDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.QualifiedName;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponent
implements NlAttributesHolder {
    @Nullable
    private XmlModelComponentMixin myMixin;
    private final List<NlComponent> children = Lists.newArrayList();
    @Nullable
    private List<NlComponent> cachedChildrenCopy = null;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @Nullable
    private TagSnapshot mySnapshot;
    @NotNull
    private NlComponentBackend myBackend;
    private final HashMap<Object, Object> myClientProperties = new HashMap();
    private final ListenerCollection<ChangeListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private final ChangeEvent myChangeEvent = new ChangeEvent(this);
    private NlComponentModificationDelegate myComponentModificationDelegate;
    @Nullable
    AttributesTransaction myCurrentTransaction;

    public NlComponent(@NotNull NlModel model2, @NotNull XmlTag tag) {
        this.myModel = model2;
        this.myBackend = new NlComponentBackendXml(model2.getProject(), tag);
    }

    public NlComponent(@NotNull NlModel model2, @NotNull XmlTag tag, @NotNull SmartPsiElementPointer<XmlTag> tagPointer) {
        this.myModel = model2;
        this.myBackend = new NlComponentBackendXml(model2.getProject(), tag, tagPointer);
    }

    public void setComponentModificationDelegate(@Nullable NlComponentModificationDelegate delegate2) {
        this.myComponentModificationDelegate = delegate2;
    }

    @Nullable
    public NlComponentModificationDelegate getComponentModificationDelegate() {
        return this.myComponentModificationDelegate;
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    @Nullable
    public XmlTag getTag() {
        return this.myBackend.getTag();
    }

    @Deprecated
    @NotNull
    public XmlTag getTagDeprecated() {
        return this.myBackend.getTagDeprecated();
    }

    @Deprecated
    @NotNull
    public SmartPsiElementPointer<XmlTag> getTagPointer() {
        return this.myBackend.getTagPointer();
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        this.myBackend.setTagElement(tag);
    }

    @Deprecated
    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component) {
        this.addChild(component, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull NlComponent component, @Nullable NlComponent before) {
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            int index2;
            this.cachedChildrenCopy = null;
            int n = index2 = before != null ? this.children.indexOf(before) : -1;
            if (index2 != -1) {
                this.children.add(index2, component);
            } else {
                this.children.add(component);
            }
        }
        component.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull NlComponent component) {
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.remove(component);
        }
        component.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(@Nullable List<NlComponent> components) {
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.clear();
            if (components == null) {
                return;
            }
            this.children.addAll(components);
        }
        for (NlComponent component : components) {
            if (component == this) {
                throw new IllegalArgumentException();
            }
            component.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NlComponent> getChildren() {
        ImmutableList childrenCopy = this.cachedChildrenCopy;
        if (childrenCopy == null) {
            List<NlComponent> list = this.children;
            synchronized (list) {
                this.cachedChildrenCopy = childrenCopy = ImmutableList.copyOf(this.children);
            }
        }
        return childrenCopy;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    @Nullable
    public NlComponent getChild(int index2) {
        List<NlComponent> children = this.getChildren();
        return index2 >= 0 && index2 < children.size() ? children.get(index2) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index2 = 0; index2 < this.myParent.getChildCount(); ++index2) {
            if (this.myParent.getChild(index2) != this) continue;
            return this.myParent.getChild(index2 + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (this.getTagDeprecated() == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result2 = child.findViewByTag(tag);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder2) {
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder2);
        }
        if (this.getTagDeprecated() == tag) {
            builder2.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder2);
        return builder2.build();
    }

    public boolean isRoot() {
        return !(this.getTagDeprecated().getParent() instanceof XmlTag);
    }

    @NotNull
    public NlComponent getRoot() {
        NlComponent parent;
        NlComponent component = this;
        while (!component.isRoot() && (parent = component.getParent()) != null) {
            component = parent;
        }
        return component;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.resolveAttribute("http://schemas.android.com/apk/res/android", "id");
        return id != null ? ResourcesUtil.stripPrefixFromId((String)id) : null;
    }

    public void clearTransaction() {
        if (this.myCurrentTransaction != null) {
            this.myCurrentTransaction.finishTransaction();
        }
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        return this.myBackend.getTagName();
    }

    @NotNull
    public NlComponentBackend getBackend() {
        return this.myBackend;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myBackend.getTagName());
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value2) {
        TagSnapshot snapshot;
        String previous;
        XmlTag tag = this.getTagDeprecated();
        if (!tag.isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null) {
            this.transferNamespaces(this);
            prefix = IdeResourcesUtil.ensureNamespaceImported((XmlFile)tag.getContainingFile(), namespace, null);
        }
        if (!Objects.equals(previous = this.myBackend.getAttribute(attribute, namespace), value2)) {
            this.myBackend.setAttribute(attribute, namespace, value2);
        }
        if ((snapshot = this.mySnapshot) != null) {
            snapshot.setAttribute(attribute, namespace, prefix, value2);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        return this.myCurrentTransaction;
    }

    @Nullable
    public AttributesTransaction getAttributeTransaction() {
        return this.myCurrentTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        return this.getAttributeImpl(namespace, attribute);
    }

    @Nullable
    public String getAttributeImpl(@Nullable String namespace, @NotNull String attribute) {
        TagSnapshot snapshot = this.mySnapshot;
        if (snapshot != null) {
            return snapshot.getAttribute(attribute, namespace);
        }
        return this.myBackend.getAttribute(attribute, namespace);
    }

    @Nullable
    public String resolveAttribute(@Nullable String namespace, @NotNull String attribute) {
        String value2 = this.getAttribute(namespace, attribute);
        if (value2 != null) {
            return value2;
        }
        if (this.getMixin() != null) {
            return this.getMixin().getAttribute(namespace, attribute);
        }
        return null;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        return this.getAttributesImpl();
    }

    @NotNull
    public List<AttributeSnapshot> getAttributesImpl() {
        TagSnapshot snapshot = this.mySnapshot;
        if (snapshot != null) {
            return snapshot.attributes;
        }
        XmlTag tag = this.getTagDeprecated();
        if (tag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag(tag));
            }
            return AttributeSnapshot.createAttributesForTag(tag);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String ensureNamespace(@NotNull String suggestedPrefix, @NotNull String namespace) {
        XmlTag tag = this.getBackend().getTag();
        if (tag == null) {
            return null;
        }
        this.transferNamespaces(this);
        return IdeResourcesUtil.ensureNamespaceImported((XmlFile)tag.getContainingFile(), namespace, suggestedPrefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index2 = str.lastIndexOf("@id/");
        if (index2 != -1) {
            return str.substring(index2 + 4);
        }
        index2 = str.lastIndexOf("@+id/");
        if (index2 != -1) {
            return str.substring(index2 + 5);
        }
        return null;
    }

    public void removeObsoleteAttributes() {
        Set<QualifiedName> obsoleteAttributes = AttributesHelperKt.getObsoleteAttributes(this);
        AttributesTransaction transaction = this.startAttributeTransaction();
        obsoleteAttributes.forEach(qualifiedName -> transaction.removeAttribute(qualifiedName.getNamespace(), qualifiedName.getName()));
        transaction.commit();
    }

    public final void putClientProperty(Object key, Object value2) {
        this.myClientProperties.put(key, value2);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeLiveChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener2 -> listener2.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        return this.assignId(this.getTagName());
    }

    public String ensureId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return this.assignId();
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        return this.assignId(baseName, this.getModel().getIds());
    }

    @NotNull
    private String assignId(@NotNull Set<String> ids2) {
        ViewHandler handler2 = NlComponentHelperKt.getViewHandler(this);
        String baseName = handler2 != null ? handler2.generateBaseId(this) : this.getTagName();
        return this.assignId(baseName, ids2);
    }

    @NotNull
    private String assignId(@NotNull String baseName, @NotNull Set<String> ids2) {
        String newId = NlComponent.generateId(baseName, ids2, ResourceFolderType.LAYOUT, this.getModel().getModule());
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getPendingIds().add(newId);
        return newId;
    }

    public void incrementId(@NotNull Set<String> ids2) {
        String id = this.getId();
        if (id == null || id.isEmpty()) {
            ids2.add(this.assignId(ids2));
        } else {
            String baseName = id.replaceAll("[0-9]*$", "");
            if (baseName != null && !baseName.isEmpty()) {
                ids2.add(this.assignId(baseName, ids2));
            }
        }
    }

    @NotNull
    private static String generateId(@NotNull String baseName, @NotNull Set<String> ids2, ResourceFolderType type, Module module2) {
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Project project = module2.getProject();
        String nextIdValue = idValue = IdeResourcesUtil.prependResourcePrefix(module2, idValue, type);
        int index2 = 0;
        NamesValidator validator = LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids2.contains(nextIdValue) || validator.isKeyword(nextIdValue, project)) {
            if (++index2 == 1 && !validator.isKeyword(nextIdValue, project)) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index2;
        }
        return idValue + (index2 == 0 ? "" : Integer.valueOf(index2));
    }

    @Nullable
    public String getTooltipText() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getTooltipText();
        }
        return null;
    }

    public boolean canAddTo(NlComponent receiver) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.canAddTo(receiver);
        }
        return true;
    }

    public void moveTo(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type, @NotNull Set<String> ids2, @Nullable DesignSurface surface2) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            mixin.beforeMove(type, receiver, ids2);
        }
        NlComponent oldParent = this.getParent();
        this.addTags(receiver, before, type);
        if (mixin != null) {
            mixin.afterMove(type, oldParent, receiver, surface2);
        }
    }

    public void addTags(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type) {
        XmlTag beforeTag;
        NlComponent parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
        XmlTag tag = this.getBackend().getTag();
        XmlTag receiverTag = receiver.getBackend().getTag();
        XmlTag xmlTag = beforeTag = before != null ? before.getBackend().getTag() : null;
        if (receiverTag == null || tag == null) {
            return;
        }
        if (receiverTag == tag) {
            return;
        }
        receiver.addChild(this, before);
        this.transferNamespaces(receiver);
        if (beforeTag != null) {
            this.setTag((XmlTag)receiverTag.addBefore((PsiElement)tag, (PsiElement)beforeTag));
        } else {
            this.setTag(receiverTag.addSubTag(tag, false));
        }
        if (type.isMove()) {
            tag.delete();
        }
    }

    public void postCreateFromTransferrable(@NotNull DnDTransferComponent dndComponent) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            mixin.postCreateFromTransferrable(dndComponent);
        }
    }

    public boolean postCreate(@Nullable DesignSurface surface2, @NotNull InsertType insertType) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.postCreate(surface2, insertType);
        }
        return true;
    }

    private void transferNamespaces(@NotNull NlComponent receiver) {
        NlComponent root2 = receiver.getRoot();
        while (receiver != null && receiver != root2) {
            XmlTag tag = receiver.getTag();
            if (tag != null && !tag.getLocalNamespaceDeclarations().isEmpty()) {
                receiver.transferLocalNamespaces(root2);
            }
            receiver = receiver.getParent();
        }
        if (receiver != this) {
            this.transferLocalNamespaces(root2);
        }
    }

    private void transferLocalNamespaces(@NotNull NlComponent root2) {
        XmlTag rootTag = root2.getTag();
        XmlTag tag = this.getTag();
        if (tag == null || rootTag == null || rootTag == tag) {
            return;
        }
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap namespaceToPrefix = Maps.newHashMap();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put(entry.getValue(), entry.getKey());
        }
        HashMap oldPrefixToPrefix = Maps.newHashMap();
        for (Map.Entry entry : tag.getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                XmlFile file2 = this.getModel().getFile();
                String newPrefix = IdeResourcesUtil.ensureNamespaceImported(file2, namespace, prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlComponent.updatePrefixes(tag, oldPrefixToPrefix);
        }
        this.removeNamespaceAttributes();
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ':' + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlComponent.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private void removeNamespaceAttributes() {
        XmlTag tag = this.getTag();
        if (tag != null) {
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!attribute.getName().startsWith("xmlns:")) continue;
                attribute.delete();
            }
        }
    }

    public Set<String> getDependencies() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getDependencies();
        }
        return ImmutableSet.of();
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component) {
            this.myComponent = component;
        }

        @NotNull
        protected NlComponent getComponent() {
            return this.myComponent;
        }

        @Nullable
        public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
            return null;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }

        @Nullable
        public String getTooltipText() {
            return null;
        }

        public boolean canAddTo(@NotNull NlComponent receiver) {
            return true;
        }

        public Set<String> getDependencies() {
            return ImmutableSet.of();
        }

        public void beforeMove(@NotNull InsertType insertType, @NotNull NlComponent receiver, @NotNull Set<String> ids2) {
        }

        public void afterMove(@NotNull InsertType insertType, @Nullable NlComponent previousParent, @NotNull NlComponent receiver, @Nullable DesignSurface surface2) {
        }

        public boolean postCreate(@Nullable DesignSurface surface2, @NotNull InsertType insertType) {
            return true;
        }

        public void postCreateFromTransferrable(DnDTransferComponent dndComponent) {
        }

        public abstract boolean maybeHandleDeletion(@NotNull Collection<NlComponent> var1);

        @NotNull
        public abstract Icon getIcon();
    }
}

