/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.idea.common.editor.ActionsToolbar;
import com.android.tools.idea.common.editor.DesignSurfaceActionsToolbar;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManager<S extends DesignSurface> {
    protected final S mySurface;

    protected ActionManager(@NotNull S surface2) {
        this.mySurface = surface2;
    }

    protected static void registerAction(@NotNull AnAction action2, @NonNls String actionId, @NotNull JComponent component) {
        Arrays.stream(com.intellij.openapi.actionSystem.ActionManager.getInstance().getAction(actionId).getShortcutSet().getShortcuts()).filter(shortcut -> shortcut instanceof KeyboardShortcut && ((KeyboardShortcut)shortcut).getSecondKeyStroke() == null).forEach(shortcut -> ActionManager.registerAction(action2, ((KeyboardShortcut)shortcut).getFirstKeyStroke(), component));
    }

    protected static void registerAction(@NotNull AnAction action2, @NotNull KeyStroke keyStroke, @NotNull JComponent component) {
        KeyBindingKt.registerAnActionKey((JComponent)component, () -> action2, (KeyStroke)keyStroke, (String)action2.getClass().getSimpleName(), (int)1);
    }

    @NotNull
    public JComponent createToolbar() {
        return new ActionsToolbar((Disposable)this.mySurface, (DesignSurface)((Object)this.mySurface)).getToolbarComponent();
    }

    @NotNull
    public JComponent createDesignSurfaceToolbar() {
        return new DesignSurfaceActionsToolbar((DesignSurface)((Object)this.mySurface), (JComponent)this.mySurface, (Disposable)this.mySurface).getDesignSurfaceToolbar();
    }

    @Nullable
    protected static AnAction getRegisteredActionByName(@NotNull String actionName) {
        return com.intellij.openapi.actionSystem.ActionManager.getInstance().getAction(actionName);
    }

    public abstract void registerActionsShortcuts(@NotNull JComponent var1);

    @NotNull
    public abstract DefaultActionGroup getPopupMenuActions(@Nullable NlComponent var1);

    @NotNull
    public abstract DefaultActionGroup getToolbarActions(@NotNull List<NlComponent> var1);

    @Nullable
    public JComponent getSceneViewContextToolbar(@NotNull SceneView sceneView) {
        return null;
    }

    @Nullable
    public JComponent getSceneViewBottomBar(@NotNull SceneView sceneView) {
        return null;
    }

    @Nullable
    public JComponent getSceneViewLeftBar(@NotNull SceneView sceneView) {
        return null;
    }
}

