/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.sdklib.devices.State;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.surface.DesignSurface;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleDeviceOrientationAction
extends AnAction {
    private ToggleDeviceOrientationAction() {
    }

    @NotNull
    public static ToggleDeviceOrientationAction getInstance() {
        return (ToggleDeviceOrientationAction)ActionManager.getInstance().getAction("Android.Designer.ToggleDeviceOrientation");
    }

    public void update(@NotNull AnActionEvent e) {
        if (DesignerActionUtils.isActionEventFromJTextField(e)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(e.getData(DesignerDataKeys.DESIGN_SURFACE) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DesignSurface surface2 = (DesignSurface)((Object)e.getRequiredData(DesignerDataKeys.DESIGN_SURFACE));
        surface2.getConfigurations().forEach(configuration -> {
            configuration.getDeviceState();
            State current = configuration.getDeviceState();
            State flip = configuration.getNextDeviceState(current);
            if (flip != null) {
                configuration.setDeviceState(flip);
            }
        });
    }
}

