/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StopAvdAction
extends AvdUiAction {
    private boolean myEnabled = true;
    @NotNull
    private final PropertyChangeSupport myPropertyChangeSupport = new SwingPropertyChangeSupport(this);
    @NotNull
    private final Function<AvdUiAction.AvdInfoProvider, ListenableFuture<Boolean>> myIsAvdRunning;
    @NotNull
    private final Executor myExecutor;

    StopAvdAction(@NotNull AvdUiAction.AvdInfoProvider provider2) {
        this(provider2, StopAvdAction::isAvdRunning, (Executor)EdtExecutorService.getInstance());
    }

    @VisibleForTesting
    StopAvdAction(@NotNull AvdUiAction.AvdInfoProvider provider2, @NotNull Function<AvdUiAction.AvdInfoProvider, ListenableFuture<Boolean>> isAvdRunning, @NotNull Executor executor) {
        super(provider2, "Stop", "Stop the emulator running this AVD", AllIcons.Actions.Suspend);
        this.myIsAvdRunning = isAvdRunning;
        this.myExecutor = executor;
    }

    @NotNull
    private static ListenableFuture<Boolean> isAvdRunning(@NotNull AvdUiAction.AvdInfoProvider provider2) {
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService());
        AvdInfo device = provider2.getAvdInfo();
        assert (device != null);
        return service.submit(() -> AvdManagerConnection.getDefaultAvdManagerConnection().isAvdRunning(device));
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.myPropertyChangeSupport.firePropertyChange("enabled", oldEnabled, enabled);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
        FutureUtils.addCallback(this.myIsAvdRunning.apply(this.myAvdInfoProvider), (Executor)this.myExecutor, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(@Nullable Boolean running) {
                StopAvdAction.this.setEnabled(running);
            }

            public void onFailure(@NotNull Throwable throwable) {
                Logger.getInstance(StopAvdAction.class).warn(throwable);
            }
        });
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        AvdManagerConnection.getDefaultAvdManagerConnection().stopAvd(Objects.requireNonNull(this.getAvdInfo()));
    }
}

