/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdDisplayList;
import com.android.tools.idea.avdmanager.SizeOnDisk;
import com.intellij.ui.table.TableView;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class SizeOnDiskColumn
extends AvdDisplayList.AvdColumnInfo {
    @NotNull
    private final Map<AvdInfo, SizeOnDisk> myDeviceToSizeOnDiskMap = new HashMap<AvdInfo, SizeOnDisk>();
    @NotNull
    private final TableView<AvdInfo> myTable;

    SizeOnDiskColumn(@NotNull TableView<AvdInfo> table2) {
        super("Size on Disk");
        this.myTable = table2;
    }

    @NotNull
    public String valueOf(@NotNull AvdInfo device) {
        return this.getSizeOnDisk(device).toString();
    }

    @Override
    @NotNull
    public Comparator<AvdInfo> getComparator() {
        return Comparator.comparing(this::getSizeOnDisk);
    }

    @NotNull
    private SizeOnDisk getSizeOnDisk(@NotNull AvdInfo device) {
        return this.myDeviceToSizeOnDiskMap.computeIfAbsent(device, d -> new SizeOnDisk((AvdInfo)d, this.myTable));
    }
}

