/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.io.FileUtilKt;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.table.TableView;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SizeOnDisk
implements Comparable<SizeOnDisk> {
    @VisibleForTesting
    static final int MODEL_COLUMN_INDEX = 7;
    @NotNull
    private String myString = "Calculating...";
    private long myValue = -1L;
    @NotNull
    private final ListenableFuture<Long> myFuture;

    SizeOnDisk(@NotNull AvdInfo device, @NotNull TableView<AvdInfo> table2) {
        this(device, table2, () -> SizeOnDisk.getSize(Paths.get(device.getDataFolderPath(), new String[0])), (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private static ListenableFuture<Long> getSize(@NotNull Path path2) {
        return MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService()).submit(() -> FileUtilKt.recursiveSize((Path)path2));
    }

    @VisibleForTesting
    SizeOnDisk(@NotNull AvdInfo device, @NotNull TableView<AvdInfo> table2, @NotNull ListenableFuture<Long> future2) {
        this(device, table2, () -> future2, MoreExecutors.directExecutor());
    }

    private SizeOnDisk(final @NotNull AvdInfo device, final @NotNull TableView<AvdInfo> table2, @NotNull Supplier<? extends ListenableFuture<Long>> futureSupplier, @NotNull Executor executor) {
        this.myFuture = futureSupplier.get();
        this.addCallback(executor, new FutureCallback<Long>(){

            public void onSuccess(@Nullable Long value2) {
                assert (value2 != null);
                Storage storage = new Storage(value2.longValue());
                SizeOnDisk.this.myString = SizeOnDisk.toString(storage);
                SizeOnDisk.this.myValue = storage.getSize();
                ((AbstractTableModel)table2.getModel()).fireTableCellUpdated(table2.getItems().indexOf(device), 7);
            }

            public void onFailure(@NotNull Throwable throwable) {
                Logger.getInstance(SizeOnDisk.class).warn(throwable);
                SizeOnDisk.this.myString = "Failed to calculate";
                SizeOnDisk.this.myValue = Long.MAX_VALUE;
                ((AbstractTableModel)table2.getModel()).fireTableCellUpdated(table2.getItems().indexOf(device), 7);
            }
        });
    }

    private void addCallback(@NotNull Executor executor, @NotNull FutureCallback<Long> callback2) {
        Futures.addCallback(this.myFuture, callback2, (Executor)executor);
    }

    @NotNull
    @VisibleForTesting
    static String toString(@NotNull Storage storage) {
        double value2 = storage.getPreciseSizeAsUnit(Storage.Unit.MiB);
        String unitSymbol = "MB";
        if (value2 >= 1024.0) {
            value2 = storage.getPreciseSizeAsUnit(Storage.Unit.GiB);
            unitSymbol = "GB";
        }
        return String.format(value2 > 9.94 ? "%.0f %s" : "%.1f %s", value2, unitSymbol);
    }

    @NotNull
    public String toString() {
        return this.myString;
    }

    @Override
    public int compareTo(@NotNull SizeOnDisk sizeOnDisk) {
        return Long.compare(this.myValue, sizeOnDisk.myValue);
    }
}

