/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.EmulatorProcessHandler;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AvdLaunchEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorRunner {
    private final GeneralCommandLine myCommandLine;
    private ProcessHandler myProcessHandler;
    private final List<ProcessListener> myExtraListeners = new ArrayList<ProcessListener>();

    public EmulatorRunner(@NotNull GeneralCommandLine commandLine, @Nullable AvdInfo avdInfo) {
        this.myCommandLine = commandLine;
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.DEPLOYMENT_TO_EMULATOR);
        event.setAvdLaunchEvent(AvdLaunchEvent.newBuilder().setLaunchType(EmulatorRunner.getLaunchType(commandLine)).setAvdClass(EmulatorRunner.getAvdClass(avdInfo)));
        if (avdInfo != null) {
            event.setDeviceInfo(DeviceInfo.newBuilder().setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)avdInfo.getAbiType())).setBuildApiLevelFull(avdInfo.getAndroidVersion().toString()));
        }
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public ProcessHandler start() throws ExecutionException {
        Process process = this.myCommandLine.createProcess();
        this.myProcessHandler = new EmulatorProcessHandler(process, this.myCommandLine);
        this.myExtraListeners.forEach(arg_0 -> ((ProcessHandler)this.myProcessHandler).addProcessListener(arg_0));
        this.myProcessHandler.startNotify();
        return this.myProcessHandler;
    }

    public void addProcessListener(@NotNull ProcessListener listener2) {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.addProcessListener(listener2);
        } else {
            this.myExtraListeners.add(listener2);
        }
    }

    @NotNull
    private static AvdLaunchEvent.LaunchType getLaunchType(@NotNull GeneralCommandLine commandLine) {
        return commandLine.getParametersList().getParameters().contains("-qt-hide-window") ? AvdLaunchEvent.LaunchType.IN_TOOL_WINDOW : AvdLaunchEvent.LaunchType.STANDALONE;
    }

    @NotNull
    private static AvdLaunchEvent.AvdClass getAvdClass(@Nullable AvdInfo avdInfo) {
        if (avdInfo == null) {
            return AvdLaunchEvent.AvdClass.UNKNOWN_AVD_CLASS;
        }
        String tag = avdInfo.getProperty("tag.id");
        if ("android-tv".equals(tag)) {
            return AvdLaunchEvent.AvdClass.TV;
        }
        if ("android-automotive".equals(tag)) {
            return AvdLaunchEvent.AvdClass.AUTOMOTIVE;
        }
        if ("android-wear".equals(tag)) {
            return AvdLaunchEvent.AvdClass.WEARABLE;
        }
        if (AvdManagerConnection.isFoldable(avdInfo)) {
            return AvdLaunchEvent.AvdClass.FOLDABLE;
        }
        return AvdLaunchEvent.AvdClass.GENERIC;
    }
}

