/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class EmulatorProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance(EmulatorProcessHandler.class);

    public EmulatorProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
        super(process, commandLine.getCommandLineString(), null);
        this.addProcessListener((ProcessListener)new ConsoleListener());
        ProcessTerminatedListener.attach((ProcessHandler)this);
    }

    private class ConsoleListener
    extends ProcessAdapter {
        private ConsoleListener() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            Integer exitCode;
            String text2 = event.getText();
            if (text2 != null) {
                LOG.info("Emulator: " + text2.trim());
            }
            if (ProcessOutputTypes.SYSTEM.equals((Object)outputType) && EmulatorProcessHandler.this.isProcessTerminated() && (exitCode = EmulatorProcessHandler.this.getExitCode()) != null && exitCode != 0) {
                LOG.warn("Emulator terminated with exit code " + exitCode);
            }
        }
    }
}

