/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.avdmanager.DeviceSkinUpdater;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

@Service
final class DeviceSkinUpdaterService {
    @NotNull
    private final ListeningExecutorService myExecutorService;

    private DeviceSkinUpdaterService() {
        ExecutorService delegate2 = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"DeviceSkinUpdaterService", (int)1);
        this.myExecutorService = MoreExecutors.listeningDecorator((ExecutorService)delegate2);
    }

    @NotNull
    static DeviceSkinUpdaterService getInstance() {
        return (DeviceSkinUpdaterService)ServiceManager.getService(DeviceSkinUpdaterService.class);
    }

    @AnyThread
    @NotNull
    @NotNull ListenableFuture<@NotNull Path> updateSkins(@NotNull Path device) {
        return this.myExecutorService.submit(() -> DeviceSkinUpdater.updateSkins(device));
    }
}

