/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.Slow;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.MoreFiles;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceSkinUpdater {
    @NotNull
    private final Path myStudioSkins;
    @NotNull
    private final Path mySdkSkins;
    private final boolean myEmulatorSupportsWebP;
    @NotNull
    private final FileSystem myFileSystem;
    @NotNull
    private final Converter myConverter;

    @VisibleForTesting
    DeviceSkinUpdater(@NotNull Path studioSkins, @NotNull Path sdkSkins, boolean emulatorSupportsWebP, @NotNull FileSystem fileSystem, @NotNull Converter converter) {
        this.myStudioSkins = studioSkins;
        this.mySdkSkins = sdkSkins;
        this.myEmulatorSupportsWebP = emulatorSupportsWebP;
        this.myFileSystem = fileSystem;
        this.myConverter = converter;
    }

    @Slow
    @NotNull
    static Path updateSkins(@NotNull Path device) {
        File studioSkins = DeviceArtDescriptor.getBundledDescriptorsFolder();
        AndroidSdkData sdk = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        return DeviceSkinUpdater.updateSkins(device, studioSkins == null ? null : studioSkins.toPath(), sdk == null ? null : sdk.getLocation().toPath(), sdk != null && AvdWizardUtils.emulatorSupportsWebp(sdk.getSdkHandler()));
    }

    @VisibleForTesting
    @NotNull
    static Path updateSkins(@NotNull Path device, @Nullable Path studioSkins, @Nullable Path sdkSkins, boolean emulatorSupportsWebP) {
        if (studioSkins == null && sdkSkins == null) {
            return device;
        }
        if (studioSkins == null) {
            return sdkSkins.resolve(device);
        }
        if (sdkSkins == null) {
            return studioSkins.resolve(device);
        }
        DeviceSkinUpdater updater = new DeviceSkinUpdater(studioSkins, sdkSkins, emulatorSupportsWebP, FileSystems.getDefault(), new Converter());
        return updater.updateSkinsImpl(device);
    }

    @VisibleForTesting
    @NotNull
    Path updateSkinsImpl(@NotNull Path device) {
        assert (!(device.toString().isEmpty() || device.isAbsolute() || device.equals(this.myFileSystem.getPath("_no_skin", new String[0])))) : device;
        Path sdkDeviceSkins = this.mySdkSkins.resolve(device);
        Path studioDeviceSkins = this.getStudioDeviceSkins(device);
        try {
            if (DeviceSkinUpdater.areSdkDeviceSkinsUpToDate(sdkDeviceSkins, studioDeviceSkins)) {
                return sdkDeviceSkins;
            }
            Files.createDirectories(sdkDeviceSkins, new FileAttribute[0]);
            if (this.myEmulatorSupportsWebP) {
                DeviceSkinUpdater.copyStudioDeviceSkins(studioDeviceSkins, sdkDeviceSkins);
            } else {
                this.convertAndCopyStudioDeviceSkins(studioDeviceSkins, sdkDeviceSkins);
            }
            return sdkDeviceSkins;
        }
        catch (IOException exception) {
            Logger.getInstance(DeviceSkinUpdater.class).warn((Throwable)exception);
            return studioDeviceSkins;
        }
    }

    @NotNull
    private Path getStudioDeviceSkins(@NotNull Path device) {
        if (device.equals(this.myFileSystem.getPath("AndroidWearRound", new String[0]))) {
            return this.myStudioSkins.resolve("wear_round");
        }
        if (device.equals(this.myFileSystem.getPath("AndroidWearSquare", new String[0]))) {
            return this.myStudioSkins.resolve("wear_square");
        }
        return this.myStudioSkins.resolve(device);
    }

    private static boolean areSdkDeviceSkinsUpToDate(@NotNull Path sdkDeviceSkins, @NotNull Path studioDeviceSkins) throws IOException {
        if (Files.notExists(sdkDeviceSkins, new LinkOption[0])) {
            return false;
        }
        Path studioLayout = studioDeviceSkins.resolve("layout");
        if (Files.notExists(studioLayout, new LinkOption[0])) {
            return true;
        }
        Path sdkLayout = sdkDeviceSkins.resolve("layout");
        if (Files.notExists(sdkLayout, new LinkOption[0])) {
            return false;
        }
        if (Files.getLastModifiedTime(studioLayout, new LinkOption[0]).compareTo(Files.getLastModifiedTime(sdkLayout, new LinkOption[0])) < 0) {
            return true;
        }
        PathUtils.deleteRecursivelyIfExists((Path)sdkDeviceSkins);
        return false;
    }

    private static void copyStudioDeviceSkins(@NotNull Path studioDeviceSkins, @NotNull Path sdkDeviceSkins) throws IOException {
        for (Path path2 : DeviceSkinUpdater.list(studioDeviceSkins)) {
            DeviceSkinUpdater.copy(path2, sdkDeviceSkins.resolve(path2.getFileName()));
        }
    }

    private void convertAndCopyStudioDeviceSkins(@NotNull Path studioDeviceSkins, @NotNull Path sdkDeviceSkins) throws IOException {
        Collection<Path> paths = DeviceSkinUpdater.list(studioDeviceSkins);
        Path layout2 = null;
        int size = paths.size();
        ArrayList<String> namesToReplace = new ArrayList<String>(size);
        ArrayList<String> namesToReplaceThemWith = new ArrayList<String>(size);
        for (Path path2 : paths) {
            Path pngImage;
            String name = path2.getFileName().toString();
            if (name.equals("layout")) {
                layout2 = path2;
                continue;
            }
            if (name.endsWith(".webp") && this.myConverter.convert(path2, pngImage = sdkDeviceSkins.resolve(MoreFiles.getNameWithoutExtension((Path)path2.getFileName()) + ".png"))) {
                namesToReplace.add(name);
                namesToReplaceThemWith.add(pngImage.getFileName().toString());
                continue;
            }
            DeviceSkinUpdater.copy(path2, sdkDeviceSkins.resolve(name));
        }
        if (layout2 == null) {
            return;
        }
        DeviceSkinUpdater.replaceAll(layout2, namesToReplace, namesToReplaceThemWith, sdkDeviceSkins.resolve(layout2.getFileName()));
    }

    private static void replaceAll(@NotNull Path source, @NotNull @NotNull List<@NotNull String> stringsToReplace, @NotNull @NotNull List<@NotNull String> stringsToReplaceThemWith, @NotNull Path target) throws IOException {
        String sourceString = new String(Files.readAllBytes(source), StandardCharsets.UTF_8);
        String targetString = StringUtil.replace((String)sourceString, stringsToReplace, stringsToReplaceThemWith);
        Files.write(target, targetString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    @NotNull
    static @NotNull Collection<@NotNull Path> list(@NotNull Path directory) throws IOException {
        try (Stream<Path> stream = Files.list(directory);){
            Collection collection2 = stream.sorted().collect(Collectors.toList());
            return collection2;
        }
    }

    @VisibleForTesting
    static void copy(@NotNull Path source, @NotNull Path target) throws IOException {
        if (!Files.isRegularFile(source, new LinkOption[0])) {
            return;
        }
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        Files.copy(source, target, new CopyOption[0]);
    }

    @VisibleForTesting
    static class Converter {
        Converter() {
        }

        @VisibleForTesting
        boolean convert(@NotNull Path webPImage, @NotNull Path pngImage) throws IOException {
            BufferedImage image;
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(webPImage, new OpenOption[0]));){
                image = ImageIO.read(in);
            }
            if (image == null) {
                return false;
            }
            var5_4 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(pngImage, new OpenOption[0]));){
                ImageIO.write((RenderedImage)image, "PNG", out);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
        }
    }
}

