/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class DeleteAvdAction
extends AvdUiAction {
    public DeleteAvdAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "Delete", "Delete this AVD", AllIcons.Actions.Cancel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        AvdInfo info2 = this.getAvdInfo();
        if (info2 == null) {
            return;
        }
        if (connection.isAvdRunning(info2)) {
            Messages.showErrorDialog((Component)this.myAvdInfoProvider.getAvdProviderComponent(), (String)"The selected AVD is currently running in the Emulator. Please exit the emulator instance and try deleting again.", (String)"Cannot Delete A Running AVD");
            return;
        }
        int result2 = Messages.showYesNoDialog((Component)this.myAvdInfoProvider.getAvdProviderComponent(), (String)("Do you really want to delete AVD " + info2.getName() + "?"), (String)"Confirm Deletion", (Icon)AllIcons.General.QuestionDialog);
        if (result2 == 0) {
            if (!connection.deleteAvd(info2)) {
                Messages.showErrorDialog((Component)this.myAvdInfoProvider.getAvdProviderComponent(), (String)"An error occurred while deleting the AVD. See idea.log for details.", (String)"Error Deleting AVD");
            }
            this.refreshAvds();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

