/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging.editor;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.apk.debugging.editor.ChooseAndAttachJavaSourcesTask;
import com.android.tools.idea.smali.psi.SmaliFile;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmaliFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"apk.smali.file");
    @NotNull
    private final Project myProject;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;

    public SmaliFileNotificationProvider(@NotNull Project project) {
        this.myProject = project;
        this.myDexSourceFiles = DexSourceFiles.getInstance(project);
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        File filePath;
        File outputFolderPath;
        Module module2 = ProjectFileIndex.getInstance((Project)this.myProject).getModuleForFile(file2);
        if (module2 != null && ApkFacet.getInstance(module2) != null && this.myDexSourceFiles.isSmaliFile(file2) && FileUtil.isAncestor((File)(outputFolderPath = this.myDexSourceFiles.getDefaultSmaliOutputFolderPath()), (File)(filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file2)), (boolean)false)) {
            String classFqn;
            EditorNotificationPanel panel2 = new EditorNotificationPanel();
            panel2.setText("Disassembled classes.dex file. To set up breakpoints for debugging, please attach Kotlin/Java source files.");
            PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            if (psiFile2 instanceof SmaliFile && StringUtil.isNotEmpty((String)(classFqn = this.myDexSourceFiles.findJavaClassName((SmaliFile)psiFile2)))) {
                PsiClass javaPsiClass = this.myDexSourceFiles.findJavaPsiClass(classFqn);
                if (javaPsiClass != null) {
                    panel2.createActionLabel("Open Kotlin/Java file", () -> NavigationUtil.openFileWithPsiElement((PsiElement)javaPsiClass, (boolean)true, (boolean)true));
                } else {
                    panel2.createActionLabel("Attach Kotlin/Java Sources...", (Runnable)new ChooseAndAttachJavaSourcesTask(classFqn, module2, this.myDexSourceFiles));
                }
            }
            return panel2;
        }
        return null;
    }
}

