/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.project.CustomProjectTypeImporter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportApkAction
extends DumbAwareAction {
    @VisibleForTesting
    @NonNls
    static final String LAST_IMPORTED_LOCATION = "last.apk.imported.location";
    @NotNull
    private final PropertiesComponent myPropertiesComponent;
    @NotNull
    private final CustomProjectTypeImporter.MainImporter myProjectTypeImporter;
    @NotNull
    private final RecentProjectsManager myRecentProjectsManager;
    @NotNull
    private final FileChooserDialogFactory myFileChooserDialogFactory;
    @Nullable
    private final ExternalSystemManager<?, ?, ?, ?, ?> myExternalSystemManager;

    public ImportApkAction() {
        this(PropertiesComponent.getInstance(), CustomProjectTypeImporter.getMain(), new FileChooserDialogFactory(), RecentProjectsManager.getInstance(), ExternalSystemApiUtil.getManager((ProjectSystemId)ApkDebugging.SYSTEM_ID));
    }

    @VisibleForTesting
    ImportApkAction(@NotNull PropertiesComponent propertiesComponent, @NotNull CustomProjectTypeImporter.MainImporter projectTypeImporter, @NotNull FileChooserDialogFactory fileChooserDialogFactory, @NotNull RecentProjectsManager recentProjectsManager, @Nullable ExternalSystemManager<?, ?, ?, ?, ?> externalSystemManager) {
        super("Profile or Debug APK", null, AllIcons.ToolbarDecorator.Import);
        this.myPropertiesComponent = propertiesComponent;
        this.myProjectTypeImporter = projectTypeImporter;
        this.myRecentProjectsManager = recentProjectsManager;
        this.myFileChooserDialogFactory = fileChooserDialogFactory;
        this.myExternalSystemManager = externalSystemManager;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (this.myExternalSystemManager == null) {
            return;
        }
        FileChooserDialog chooser2 = this.myFileChooserDialogFactory.create(this.myExternalSystemManager);
        VirtualFile toSelect = null;
        String lastLocation = this.myPropertiesComponent.getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files2 = chooser2.choose(null, new VirtualFile[]{toSelect})).length == 0) {
            return;
        }
        VirtualFile file2 = files2[0];
        this.myPropertiesComponent.setValue(LAST_IMPORTED_LOCATION, FileUtil.toSystemDependentName((String)file2.getPath()));
        String lastProjectCreation = this.myRecentProjectsManager.getLastProjectCreationLocation();
        this.myProjectTypeImporter.importFileAsProject(file2);
        this.myRecentProjectsManager.setLastProjectCreationLocation(lastProjectCreation);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.myExternalSystemManager != null && ApkDebugging.isEnabled();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @VisibleForTesting
    static class FileChooserDialogFactory {
        FileChooserDialogFactory() {
        }

        @NotNull
        FileChooserDialog create(@NotNull ExternalSystemManager<?, ?, ?, ?, ?> externalSystemManager) {
            return new FileChooserDialogImpl(externalSystemManager.getExternalProjectDescriptor(), (Project)null);
        }
    }
}

