/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/adb/wireless/ExternalCommand;", "", "executable", "", "(Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getExecutable", "()Ljava/lang/String;", "execute", "", "args", "", "stdin", "Ljava/io/InputStream;", "stdout", "Ljava/io/OutputStream;", "stderr", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "PipeConnector", "intellij.android.adb"})
public final class ExternalCommand {
    private final Logger LOG;
    @NotNull
    private final String executable;

    public final int execute(@NotNull List<String> args, @NotNull InputStream stdin, @NotNull OutputStream stdout, @NotNull OutputStream stderr, long timeout, @NotNull TimeUnit unit) throws IOException {
        List command = new ArrayList();
        File exe = new File(this.executable);
        command.add(exe.getAbsolutePath());
        command.addAll((Collection)args);
        this.LOG.info("Executing command: " + command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process process = pb.start();
        PipeConnector inToProcess = new PipeConnector(stdin, process.getOutputStream());
        PipeConnector processToOut = new PipeConnector(process.getInputStream(), stdout);
        PipeConnector processToErr = new PipeConnector(process.getErrorStream(), stderr);
        inToProcess.start();
        processToOut.start();
        processToErr.start();
        int code = 255;
        try {
            boolean finished2 = process.waitFor(timeout, unit);
            if (!finished2) {
                this.LOG.warn("Command did not terminate within specified timeout");
                process.destroyForcibly();
            } else {
                code = process.exitValue();
                this.LOG.info("Command finished with exit value " + code);
            }
            processToOut.join();
            stdin.close();
            inToProcess.join();
        }
        catch (InterruptedException e) {
            this.LOG.warn("Command was interrupted", (Throwable)e);
        }
        return code;
    }

    @NotNull
    public final String getExecutable() {
        return this.executable;
    }

    public ExternalCommand(@NotNull String executable) {
        this.executable = executable;
        boolean $i$f$logger = false;
        this.LOG = Logger.getInstance(ExternalCommand.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/adb/wireless/ExternalCommand$PipeConnector;", "Ljava/lang/Thread;", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "(Ljava/io/InputStream;Ljava/io/OutputStream;)V", "run", "", "intellij.android.adb"})
    private static final class PipeConnector
    extends Thread {
        private final InputStream input;
        private final OutputStream output;

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[8192];
                int read2 = 0;
                while (true) {
                    int n = this.input.read(buffer);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n;
                    boolean bl3 = false;
                    read2 = it;
                    if (n > 0) {
                        this.output.write(buffer, 0, read2);
                        this.output.flush();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public PipeConnector(@NotNull InputStream input, @NotNull OutputStream output) {
            this.input = input;
            this.output = output;
        }
    }
}

