/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class LicensesLocator {
    private final Path myIdeHome;
    private final boolean myOnMac;
    private final List<String> myGooglePlugins = Arrays.asList("android", "firebase", "firebase-testing", "google-appindexing", "google-cloud-tools", "google-cloud-tools-core", "google-login", "google-services", "test-recorder");

    public LicensesLocator(@NotNull Path ideHome, boolean isMacLayout) {
        this.myIdeHome = ideHome;
        this.myOnMac = isMacLayout;
    }

    @NotNull
    public List<Path> getLicenseFiles() {
        ArrayList<Path> licenses = new ArrayList<Path>();
        licenses.addAll(this.getIdeLicenseAndNotice());
        licenses.addAll(this.getIdeWideThirdPartyLibLicenses());
        for (String plugin : this.myGooglePlugins) {
            licenses.addAll(this.getThirdPartyLibrariesForPlugin(plugin));
        }
        return licenses;
    }

    @NotNull
    private List<Path> getIdeLicenseAndNotice() {
        Path root2 = this.myIdeHome;
        if (this.myOnMac) {
            root2 = root2.resolve("Resources");
        }
        return ImmutableList.of((Object)root2.resolve("NOTICE.txt"), (Object)root2.resolve("LICENSE.txt"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<Path> getIdeWideThirdPartyLibLicenses() {
        try (Stream<Path> stream = Files.list(this.myIdeHome.resolve("license"));){
            List<Path> list = stream.sorted().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            Logger.getInstance(LicensesLocator.class).error((Throwable)e);
            return ImmutableList.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Path> getThirdPartyLibrariesForPlugin(String plugin) {
        Path pluginLicenseFolder = Paths.get(this.myIdeHome.toString(), "plugins", plugin, "lib", "licenses");
        if (!Files.isDirectory(pluginLicenseFolder, new LinkOption[0])) return ImmutableList.of();
        try (Stream<Path> stream = Files.list(pluginLicenseFolder);){
            List<Path> list = stream.sorted().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            Logger.getInstance(LicensesLocator.class).warn((Throwable)e);
            return ImmutableList.of();
        }
    }
}

