/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenStringResourceEditorAction
extends AnAction {
    public OpenStringResourceEditorAction() {
        super("Open Translations Editor", null, StringResourceEditor.ICON);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean show = false;
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file2 != null) {
            show = StringResourceEditorProvider.canViewTranslations(project, file2);
        }
        e.getPresentation().setEnabledAndVisible(show);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (project == null || file2 == null) {
            return;
        }
        StringResourceEditorProvider.openEditor(project, file2);
    }
}

