/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidActionGroupRemover
extends ActionGroup {
    @NotNull
    private final ActionGroup myDelegate;

    public AndroidActionGroupRemover(@NotNull ActionGroup delegate2, @NotNull String backupText) {
        super(delegate2.getTemplatePresentation().getTextWithMnemonic(), delegate2.getTemplatePresentation().getDescription(), delegate2.getTemplatePresentation().getIcon());
        this.myDelegate = delegate2;
        Presentation presentation = this.getTemplatePresentation();
        if (Strings.isNullOrEmpty((String)presentation.getText())) {
            presentation.setText(backupText);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myDelegate.actionPerformed(e);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        AndroidActionGroupRemover.updateTextAndIcon(this.getTemplatePresentation(), this.myDelegate.getTemplatePresentation());
        this.myDelegate.update(e);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return this.myDelegate.getChildren(e);
    }

    private static void updateTextAndIcon(@NotNull Presentation source, @NotNull Presentation destination) {
        destination.setText(source.getTextWithMnemonic());
        destination.setIcon(source.getIcon());
    }

    public boolean isPopup() {
        return this.myDelegate.isPopup();
    }
}

