/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.panels.CriticalPathChartLegend;
import com.android.build.attribution.ui.panels.TimeDistributionChart;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/ui/tree/OtherChartItem;", "T", "Lcom/android/build/attribution/ui/panels/TimeDistributionChart$AggregatedChartDataItem;", "time", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "textPrefix", "", "aggregatedItems", "", "assignedColor", "Lcom/android/build/attribution/ui/panels/CriticalPathChartLegend$ChartColor;", "hasWarnings", "", "(Lcom/android/build/attribution/ui/data/TimeWithPercentage;Ljava/lang/String;Ljava/util/List;Lcom/android/build/attribution/ui/panels/CriticalPathChartLegend$ChartColor;Z)V", "chartBoxText", "getLegendColor", "getTableIcon", "Ljavax/swing/Icon;", "getUnderlyingData", "text", "intellij.android.build-attribution"})
final class OtherChartItem<T>
implements TimeDistributionChart.AggregatedChartDataItem<T> {
    private final TimeWithPercentage time;
    private final String textPrefix;
    private final List<T> aggregatedItems;
    private final CriticalPathChartLegend.ChartColor assignedColor;
    private final boolean hasWarnings;

    @Override
    @NotNull
    public TimeWithPercentage time() {
        return this.time;
    }

    @Override
    @NotNull
    public String text() {
        StringBuilder stringBuilder = new StringBuilder().append(this.textPrefix);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = " (%d)";
        Object[] objectArray = new Object[]{this.aggregatedItems.size()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return stringBuilder.append(string2).toString();
    }

    @Override
    @Nullable
    public Icon getTableIcon() {
        return this.hasWarnings ? BuildAttributionUIUtilKt.warningIcon() : null;
    }

    @Override
    @NotNull
    public CriticalPathChartLegend.ChartColor getLegendColor() {
        return this.assignedColor;
    }

    @Override
    @NotNull
    public String chartBoxText() {
        return this.textPrefix;
    }

    @Override
    @NotNull
    public List<T> getUnderlyingData() {
        return this.aggregatedItems;
    }

    public OtherChartItem(@NotNull TimeWithPercentage time2, @NotNull String textPrefix, @NotNull List<? extends T> aggregatedItems, @NotNull CriticalPathChartLegend.ChartColor assignedColor, boolean hasWarnings) {
        this.time = time2;
        this.textPrefix = textPrefix;
        this.aggregatedItems = aggregatedItems;
        this.assignedColor = assignedColor;
        this.hasWarnings = hasWarnings;
    }
}

