/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u000b"}, d2={"isAndroidGradlePlugin", "", "plugin", "Lcom/android/build/attribution/data/PluginData;", "isAndroidPlugin", "isGradlePlugin", "isJavaPlugin", "isKaptTask", "task", "Lcom/android/build/attribution/data/TaskData;", "isKotlinPlugin", "intellij.android.build-attribution"})
public final class AnalyzersUtilKt {
    public static final boolean isAndroidGradlePlugin(@NotNull PluginData plugin) {
        return Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"com.android.application");
    }

    public static final boolean isJavaPlugin(@NotNull PluginData plugin) {
        return Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"application") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"java") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"java-base") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"java-gradle-plugin") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"java-library") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"java-platform");
    }

    public static final boolean isAndroidPlugin(@NotNull PluginData plugin) {
        return Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"com.android.application") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"com.android.library") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"com.android.instantapp") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"com.android.feature") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"com.android.dynamic-feature") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"com.android.test");
    }

    public static final boolean isKotlinPlugin(@NotNull PluginData plugin) {
        return Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"kotlin") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"kotlin-android") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"kotlin-android-extensions") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"kotlin-multiplatform") || Intrinsics.areEqual((Object)plugin.getDisplayName(), (Object)"kotlin-kapt") || StringsKt.startsWith$default((String)plugin.getDisplayName(), (String)"org.jetbrains.kotlin", (boolean)false, (int)2, null);
    }

    public static final boolean isGradlePlugin(@NotNull PluginData plugin) {
        return StringsKt.startsWith$default((String)plugin.getDisplayName(), (String)"org.gradle.", (boolean)false, (int)2, null);
    }

    public static final boolean isKaptTask(@NotNull TaskData task2) {
        return Intrinsics.areEqual((Object)task2.getTaskType(), (Object)"org.jetbrains.kotlin.gradle.internal.KaptTask") || Intrinsics.areEqual((Object)task2.getTaskType(), (Object)"org.jetbrains.kotlin.gradle.internal.KaptWithKotlincTask") || Intrinsics.areEqual((Object)task2.getTaskType(), (Object)"org.jetbrains.kotlin.gradle.internal.KaptWithoutKotlincTask") || Intrinsics.areEqual((Object)task2.getTaskType(), (Object)"org.jetbrains.kotlin.gradle.internal.KaptGenerateStubsTask");
    }
}

