/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.collect.Lists;
import com.google.urlassistant.ActivityData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestUtils {
    public static final String ACTION_VIEW = "android.intent.action.VIEW";
    public static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    public static final String ORDER = "order";
    private static final String TAG_VALIDATION = "validation";
    private static final String ATTRIBUTE_TEST_URL = "testUrl";

    @NotNull
    public static List<ActivityData> getAllActivities(@NotNull Module[] modules, boolean supportsAppLinks, boolean mustHaveSourceFile) {
        ArrayList<ActivityData> result = new ArrayList<ActivityData>();
        for (Module module : modules) {
            ManifestUtils.getAllActivitiesFromModule(module, result, supportsAppLinks, mustHaveSourceFile);
        }
        return result;
    }

    private static void getAllActivitiesFromModule(@NotNull Module module, @NotNull List<ActivityData> resultList, boolean supportsAppLinks, boolean mustHaveSourceFile) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return;
        }
        Manifest manifest = Manifest.getMainManifest((AndroidFacet)facet);
        if (manifest == null || manifest.getModule() == null || manifest.getApplication() == null) {
            return;
        }
        List activityList = manifest.getApplication().getActivities();
        block0: for (Activity activity : activityList) {
            String activityName = activity.getActivityClass().getStringValue();
            if (activityName == null) continue;
            PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
            if (mustHaveSourceFile && (activityClass == null || activityClass.getContainingFile().getVirtualFile() == null)) continue;
            if (!supportsAppLinks) {
                resultList.add(new ActivityData(module, activityName, null, activityClass));
                continue;
            }
            for (IntentFilter filter : activity.getIntentFilters()) {
                XmlTag intentFilter = filter.getXmlTag();
                if (!ManifestUtils.isValidAppLink(intentFilter)) continue;
                resultList.add(new ActivityData(module, activityName, intentFilter, activityClass));
                continue block0;
            }
        }
    }

    public static boolean isValidAppLink(@NotNull XmlTag intentFilter) {
        if (!ManifestUtils.isValidDeepLink(intentFilter)) {
            return false;
        }
        int hostCnt = 0;
        boolean hasScheme = false;
        List<XmlTag> dataList = ManifestUtils.searchXmlTagsByName(intentFilter, "data");
        for (XmlTag data : dataList) {
            String scheme = data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
            if ("http".equals(scheme) || "https".equals(scheme)) {
                hasScheme = true;
            }
            if (!StringUtil.isEmpty((String)data.getAttributeValue("host", "http://schemas.android.com/apk/res/android"))) {
                ++hostCnt;
            }
            if (hostCnt <= 0 || !hasScheme) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidDeepLink(@NotNull XmlTag intentFilter) {
        List<XmlTag> actions = ManifestUtils.searchXmlTagsByName(intentFilter, "action");
        boolean hasCorrectAction = false;
        for (XmlTag action : actions) {
            if (!ACTION_VIEW.equals(action.getAttributeValue("name", "http://schemas.android.com/apk/res/android"))) continue;
            hasCorrectAction = true;
            break;
        }
        if (!hasCorrectAction) {
            return false;
        }
        List<XmlTag> categories = ManifestUtils.searchXmlTagsByName(intentFilter, "category");
        boolean hasCategoryDefault = false;
        boolean hasCategoryBrowsable = false;
        for (XmlTag category : categories) {
            String name = category.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if ("android.intent.category.DEFAULT".equals(name)) {
                hasCategoryDefault = true;
            }
            if (!CATEGORY_BROWSABLE.equals(name)) continue;
            hasCategoryBrowsable = true;
        }
        return hasCategoryDefault && hasCategoryBrowsable;
    }

    @Nullable
    public static VirtualFile getAndroidManiFest(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet == null ? null : ManifestUtils.getAndroidManiFest(facet);
    }

    @Nullable
    public static VirtualFile getAndroidManiFest(@NotNull AndroidFacet facet) {
        return SourceProviderManager.getInstance((AndroidFacet)facet).getMainManifestFile();
    }

    @Nullable
    public static XmlFile getAndroidManifestPsi(@NotNull Module module) {
        PsiFile psiFile;
        VirtualFile manifest = ManifestUtils.getAndroidManiFest(module);
        if (manifest != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(manifest)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    @NotNull
    public static List<XmlTag> searchXmlTagsByName(@NotNull XmlTag root, @NotNull String tagName) {
        return ManifestUtils.searchXmlTagsByName(root, tagName, null);
    }

    @NotNull
    public static List<XmlTag> searchXmlTagsByName(@NotNull XmlTag root, final @NotNull String tagName, final @Nullable String namespace) {
        final ArrayList tags = Lists.newArrayList();
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (namespace == null && tag.getName().equalsIgnoreCase(tagName) || tag.getLocalName().equalsIgnoreCase(tagName) && tag.getNamespace().equals(namespace)) {
                    tags.add(tag);
                }
            }
        });
        return tags;
    }

    @Nullable
    public static XmlTag addTestUrl(@NotNull ActivityData activityData, @NotNull String testUrl) {
        if (activityData.getIntentFilterTag() == null) {
            return null;
        }
        XmlTag activityTag = activityData.getIntentFilterTag().getParentTag();
        if (activityTag == null) {
            return null;
        }
        IdeResourcesUtil.ensureNamespaceImported((XmlFile)((XmlFile)activityTag.getContainingFile()), (String)"http://schemas.android.com/tools", (String)"tools");
        XmlTag validationTag = activityTag.createChildTag(TAG_VALIDATION, "http://schemas.android.com/tools", null, false);
        validationTag.setAttribute(ATTRIBUTE_TEST_URL, testUrl.trim());
        return activityTag.addSubTag(validationTag, true);
    }

    public static boolean isTestUrlAdded(@NotNull ActivityData activityData, @NotNull String testUrl) {
        if (activityData.getIntentFilterTag() == null) {
            return false;
        }
        XmlTag activityTag = activityData.getIntentFilterTag().getParentTag();
        if (activityTag == null) {
            return false;
        }
        List<XmlTag> validationTags = ManifestUtils.searchXmlTagsByName(activityTag, TAG_VALIDATION, "http://schemas.android.com/tools");
        for (XmlTag xmlTag : validationTags) {
            if (!testUrl.trim().equalsIgnoreCase(xmlTag.getAttributeValue(ATTRIBUTE_TEST_URL))) continue;
            return true;
        }
        return false;
    }
}

