/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.logcat;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.google.urlassistant.logcat.AppLinksLogLineListener;
import com.google.urlassistant.util.UrlAssistantBundle;
import org.jetbrains.annotations.NotNull;

public class AppLinksLogTask
implements LaunchTask {
    private static final String ID = "APP_LINKS_LOG";
    private AppLinksLogLineListener myLogLineListener;

    public AppLinksLogTask(@NotNull AppLinksLogLineListener listener) {
        this.myLogLineListener = listener;
    }

    @NotNull
    public String getDescription() {
        return UrlAssistantBundle.message("test.url.logcat.task.description", new Object[0]);
    }

    public int getDuration() {
        return 2;
    }

    public LaunchResult run(@NotNull LaunchContext launchContext) {
        IDevice device = launchContext.getDevice();
        if (!this.myLogLineListener.isListening()) {
            AndroidLogcatService.getInstance().removeListener(device, (AndroidLogcatService.LogcatListener)this.myLogLineListener);
        }
        AndroidLogcatService.getInstance().addListener(device, (AndroidLogcatService.LogcatListener)this.myLogLineListener);
        this.myLogLineListener.setDevice(device);
        return LaunchResult.success();
    }

    @NotNull
    public String getId() {
        return ID;
    }
}

