/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.editor.Document;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList$sam$java_util_function_Function$0;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\r\u001a\u00020\tJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/jetbrains/debugger/sourcemap/MappingList;", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "(Ljava/util/List;)V", "comparator", "Ljava/util/Comparator;", "size", "", "getSize", "()I", "get", "line", "column", "getByIndex", "index", "getEndOffset", "mapping", "lineStartOffset", "document", "Lcom/intellij/openapi/editor/Document;", "getMappingsInLine", "", "getNext", "getNextOnTheSameLine", "skipIfColumnEquals", "", "indexOf", "processMappingsInLine", "entryProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "intellij.platform.scriptDebugger.backend"})
public abstract class MappingList
implements Mappings {
    private final Comparator<MappingEntry> comparator;
    private final List<MappingEntry> mappings;

    public final int getSize() {
        return this.mappings.size();
    }

    @Override
    public int indexOf(int line, int column) {
        int middle2 = CollectionsKt.binarySearch$default(this.mappings, (int)0, (int)0, (Function1)((Function1)new Function1<MappingEntry, Integer>(this, line, column){
            final /* synthetic */ MappingList this$0;
            final /* synthetic */ int $line;
            final /* synthetic */ int $column;

            public final int invoke(@NotNull MappingEntry it) {
                int compareLines = Intrinsics.compare((int)this.this$0.getLine(it), (int)this.$line);
                return compareLines != 0 ? compareLines : Intrinsics.compare((int)this.this$0.getColumn(it), (int)this.$column);
            }
            {
                this.this$0 = mappingList;
                this.$line = n;
                this.$column = n2;
                super(1);
            }
        }), (int)3, null);
        if (middle2 == -1) {
            middle2 = 0;
        } else if (middle2 < -1) {
            middle2 = -middle2 - 2;
        }
        if (this.getLine(this.mappings.get(middle2)) < line && middle2 < this.mappings.size()) {
            int lastOfEquivalent;
            for (lastOfEquivalent = middle2; lastOfEquivalent < this.mappings.size() - 1 && this.getLine(this.mappings.get(lastOfEquivalent)) == this.getLine(this.mappings.get(lastOfEquivalent + 1)) && this.getColumn(this.mappings.get(lastOfEquivalent)) == this.getColumn(this.mappings.get(lastOfEquivalent + 1)); ++lastOfEquivalent) {
            }
            if (lastOfEquivalent == this.mappings.size() - 1) {
                return -1;
            }
            middle2 = lastOfEquivalent + 1;
        }
        while (middle2 > 0 && this.getLine(this.mappings.get(middle2)) == this.getLine(this.mappings.get(middle2 - 1)) && this.getColumn(this.mappings.get(middle2)) == this.getColumn(this.mappings.get(middle2 - 1))) {
            --middle2;
        }
        return line == this.getLine(this.mappings.get(middle2)) ? middle2 : -1;
    }

    @Override
    @Nullable
    public MappingEntry get(int line, int column) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)this.indexOf(line, column));
    }

    private final MappingEntry getNext(int index) {
        return (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)(index + 1));
    }

    @Override
    @Nullable
    public MappingEntry getNext(@NotNull MappingEntry mapping2) {
        int n;
        int index = CollectionsKt.binarySearch$default(this.mappings, (Object)mapping2, this.comparator, (int)0, (int)0, (int)12, null);
        if (index < 0) {
            return null;
        }
        MappingEntry result2 = null;
        do {
            n = ++index;
            ++index;
        } while (mapping2 == (result2 = (MappingEntry)CollectionsKt.getOrNull(this.mappings, (int)n)));
        return result2;
    }

    @Override
    @Nullable
    public MappingEntry getNextOnTheSameLine(int index, boolean skipIfColumnEquals) {
        MappingEntry mappingEntry = this.getNext(index);
        if (mappingEntry == null) {
            return null;
        }
        MappingEntry nextMapping = mappingEntry;
        MappingEntry mapping2 = this.getByIndex(index);
        if (this.getLine(nextMapping) != this.getLine(mapping2)) {
            return null;
        }
        if (skipIfColumnEquals) {
            int i2 = index;
            while (this.getColumn(nextMapping) == this.getColumn(mapping2)) {
                if (this.getNextOnTheSameLine(++i2, false) != null) continue;
                return null;
            }
        }
        return nextMapping;
    }

    public final int getEndOffset(@NotNull MappingEntry mapping2, int lineStartOffset, @NotNull Document document) {
        MappingEntry nextMapping = Mappings.DefaultImpls.getNextOnTheSameLine$default(this, Collections.binarySearch(this.mappings, mapping2, this.comparator), false, 2, null);
        return nextMapping == null ? document.getLineEndOffset(this.getLine(mapping2)) : lineStartOffset + this.getColumn(nextMapping);
    }

    @Override
    @NotNull
    public MappingEntry getByIndex(int index) {
        return this.mappings.get(index);
    }

    @NotNull
    public final Iterable<MappingEntry> getMappingsInLine(int line) {
        int lastIndex;
        int firstIndex;
        int low = 0;
        int high = this.mappings.size() - 1;
        int middle2 = -1;
        while (low <= high) {
            middle2 = low + high >>> 1;
            MappingEntry mapping2 = this.mappings.get(middle2);
            int mappingLine = this.getLine(mapping2);
            if (line == mappingLine) break;
            if (line > mappingLine) {
                low = middle2 + 1;
                continue;
            }
            high = middle2 - 1;
        }
        if (middle2 == -1) {
            return CollectionsKt.emptyList();
        }
        for (firstIndex = middle2; firstIndex > 0 && this.getLine(this.mappings.get(firstIndex - 1)) == line; --firstIndex) {
        }
        for (lastIndex = middle2; lastIndex < this.mappings.size() - 1 && this.getLine(this.mappings.get(lastIndex + 1)) == line; ++lastIndex) {
        }
        return this.mappings.subList(firstIndex, lastIndex + 1);
    }

    public final boolean processMappingsInLine(int line, @NotNull MappingsProcessorInLine entryProcessor) {
        Iterable<MappingEntry> mappingsInLine = this.getMappingsInLine(line);
        return entryProcessor.processIterable(mappingsInLine);
    }

    public MappingList(@NotNull List<? extends MappingEntry> mappings) {
        Function1 function1 = (Function1)new Function1<MappingEntry, Integer>(this){

            public final int invoke(@NotNull MappingEntry p1) {
                return ((MappingList)this.receiver).getLine(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MappingList.class);
            }

            public final String getName() {
                return "getLine";
            }

            public final String getSignature() {
                return "getLine(Lorg/jetbrains/debugger/sourcemap/MappingEntry;)I";
            }
        };
        MappingList$sam$java_util_function_Function$0 mappingList$sam$java_util_function_Function$0 = new MappingList$sam$java_util_function_Function$0(function1);
        function1 = (Function1)new Function1<MappingEntry, Integer>(this){

            public final int invoke(@NotNull MappingEntry p1) {
                return ((MappingList)this.receiver).getColumn(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MappingList.class);
            }

            public final String getName() {
                return "getColumn";
            }

            public final String getSignature() {
                return "getColumn(Lorg/jetbrains/debugger/sourcemap/MappingEntry;)I";
            }
        };
        this.comparator = Comparator.comparing(mappingList$sam$java_util_function_Function$0).thenComparing(new MappingList$sam$java_util_function_Function$0(function1));
        this.mappings = this instanceof GeneratedMappingList ? mappings : CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)mappings, this.comparator));
    }

    @Override
    @Nullable
    public MappingEntry getNextOnTheSameLine(@NotNull MappingEntry mapping2) {
        return Mappings.DefaultImpls.getNextOnTheSameLine(this, mapping2);
    }
}

