/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.NetService;

public final class ConsoleManager {
    private ConsoleView console;

    @NotNull
    public ConsoleView getConsole(@NotNull NetService netService) {
        if (this.console == null) {
            this.createConsole(netService);
        }
        return this.console;
    }

    private void createConsole(@NotNull NetService netService) {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(netService.getProject());
        netService.configureConsole(consoleBuilder);
        this.console = consoleBuilder.getConsole();
        ApplicationManager.getApplication().invokeLater(() -> {
            ActionGroup actionGroup = netService.getConsoleToolWindowActions();
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BuiltInServer", actionGroup, false);
            SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(false, true);
            toolWindowPanel.setContent(this.console.getComponent());
            toolWindowPanel.setToolbar(toolbar.getComponent());
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)netService.getProject()).registerToolWindow(netService.getConsoleToolWindowId(), false, ToolWindowAnchor.BOTTOM, (Disposable)netService.getProject(), true);
            toolWindow.setIcon(netService.getConsoleToolWindowIcon());
            Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)toolWindowPanel, "", false);
            Disposer.register((Disposable)content2, (Disposable)this.console);
            toolWindow.getContentManager().addContent(content2);
        }, netService.getProject().getDisposed());
    }
}

