/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.util.Getter;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xml.XmlBundle;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerConfigurableUi;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.BuiltInServerManagerImpl;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.CustomPortServerManagerBase;

@State(name="BuiltInServerOptions", storages={@Storage(value="other.xml")})
public class BuiltInServerOptions
implements PersistentStateComponent<BuiltInServerOptions>,
Getter<BuiltInServerOptions> {
    public static final int DEFAULT_PORT = 63342;
    @Attribute
    public int builtInServerPort = 63342;
    @Attribute
    public boolean builtInServerAvailableExternally = false;
    @Attribute
    public boolean allowUnsignedRequests = false;

    public static BuiltInServerOptions getInstance() {
        return (BuiltInServerOptions)ServiceManager.getService(BuiltInServerOptions.class);
    }

    public BuiltInServerOptions get() {
        return this;
    }

    @Nullable
    public BuiltInServerOptions getState() {
        return this;
    }

    public void loadState(@NotNull BuiltInServerOptions state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public int getEffectiveBuiltInServerPort() {
        MyCustomPortServerManager portServerManager = (MyCustomPortServerManager)((Object)CustomPortServerManager.EP_NAME.findExtensionOrFail(MyCustomPortServerManager.class));
        if (!portServerManager.isBound()) {
            return BuiltInServerManager.getInstance().getPort();
        }
        return this.builtInServerPort;
    }

    public static void onBuiltInServerPortChanged() {
        ((MyCustomPortServerManager)((Object)CustomPortServerManager.EP_NAME.findExtensionOrFail(MyCustomPortServerManager.class))).portChanged();
    }

    public static final class MyCustomPortServerManager
    extends CustomPortServerManagerBase {
        public void cannotBind(@NotNull Exception e, int port) {
            ((NotificationGroup)BuiltInServerManagerImpl.NOTIFICATION_GROUP.getValue()).createNotification(BuiltInServerBundle.message((String)"notification.content.cannot.start.built.in.http.server.on.custom.port", (Object[])new Object[]{port, ApplicationNamesInfo.getInstance().getFullProductName()}), NotificationType.ERROR).notify(null);
        }

        public int getPort() {
            int port = BuiltInServerOptions.getInstance().builtInServerPort;
            return port == 63342 ? -1 : port;
        }

        public boolean isAvailableExternally() {
            return BuiltInServerOptions.getInstance().builtInServerAvailableExternally;
        }
    }

    static final class BuiltInServerDebuggerConfigurableProvider
    extends DebuggerConfigurableProvider {
        BuiltInServerDebuggerConfigurableProvider() {
        }

        @NotNull
        public Collection<? extends Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
            if (category == DebuggerSettingsCategory.GENERAL) {
                return Collections.singletonList(SimpleConfigurable.create((String)"builtInServer", (String)XmlBundle.message((String)"setting.builtin.server.category.label", (Object[])new Object[0]), BuiltInServerConfigurableUi.class, (Getter)BuiltInServerOptions.getInstance()));
            }
            return Collections.emptyList();
        }
    }
}

