/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.surroundWith.GroupSurrounder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new GroupSurrounder(RegExpBundle.message("surrounder.capturing.group.pattern", new Object[0]), "("), new GroupSurrounder(RegExpBundle.message("surrounder.non.capturing.group.pattern", new Object[0]), "(?:"), new GroupSurrounder(RegExpBundle.message("surrounder.atomic.group.pattern", new Object[0]), "(?:"), new GroupSurrounder(RegExpBundle.message("surrounder.positive.lookbehind.pattern", new Object[0]), "(?<="), new GroupSurrounder(RegExpBundle.message("surrounder.negative.lookbehind.pattern", new Object[0]), "(?<!"), new GroupSurrounder(RegExpBundle.message("surrounder.positive.lookahead.pattern", new Object[0]), "(?="), new GroupSurrounder(RegExpBundle.message("surrounder.negative.lookahead.pattern", new Object[0]), "(?!")};

    public PsiElement @NotNull [] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        RegExpPattern pattern;
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        if ((pattern = SimpleSurroundDescriptor.findElementAtStrict(file2, startOffset, endOffset, RegExpPattern.class)) != null) {
            return new RegExpElement[]{pattern};
        }
        RegExpBranch branch = SimpleSurroundDescriptor.findElementAtStrict(file2, startOffset, endOffset, RegExpBranch.class);
        if (branch != null) {
            return new RegExpElement[]{branch};
        }
        ArrayList<PsiElement> atoms = new ArrayList<PsiElement>();
        RegExpAtom atom = (RegExpAtom)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, RegExpAtom.class);
        while (atom != null) {
            atoms.add(atom);
            startOffset = atom.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
            if (element1 instanceof PsiWhiteSpace) {
                startOffset = element1.getTextRange().getEndOffset();
                atoms.add(element1);
            }
            atom = (RegExpAtom)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, RegExpAtom.class);
        }
        if (startOffset == endOffset && atoms.size() > 0) {
            PsiElement[] elements2 = PsiUtilCore.toPsiElementArray(atoms);
            if (atoms.size() == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements2) == elements2[0].getParent()) {
                return elements2;
            }
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public Surrounder @NotNull [] getSurrounders() {
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    @Nullable
    private static <T extends RegExpElement> T findElementAtStrict(PsiFile file2, int startOffset, int endOffset, Class<T> clazz) {
        RegExpElement element2 = (RegExpElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, clazz);
        if (element2 == null || element2.getTextRange().getEndOffset() < endOffset) {
            return null;
        }
        return (T)element2;
    }
}

