/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.stream.Stream;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SingleCharAlternationInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new SingleCharAlternationVisitor(holder);
    }

    static String buildReplacementText(RegExpPattern pattern) {
        StringBuilder text = new StringBuilder("[");
        for (RegExpBranch branch : pattern.getBranches()) {
            block9: for (PsiElement child2 : branch.getChildren()) {
                int value2;
                if (!(child2 instanceof RegExpChar)) {
                    return null;
                }
                RegExpChar ch = (RegExpChar)child2;
                IElementType type = ch.getNode().getFirstChildNode().getElementType();
                if (type == RegExpTT.REDUNDANT_ESCAPE) {
                    value2 = ch.getValue();
                    if (value2 == 93) {
                        text.append(ch.getUnescapedText());
                        continue;
                    }
                    if (value2 == 45 && text.length() != 1) {
                        text.append("\\-");
                        continue;
                    }
                    text.append((char)value2);
                    continue;
                }
                if (type == RegExpTT.ESC_CHARACTER) {
                    value2 = ch.getValue();
                    switch (value2) {
                        case 36: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 46: 
                        case 63: 
                        case 123: 
                        case 124: {
                            text.append((char)value2);
                            break;
                        }
                        case 94: {
                            if (text.length() == 1) {
                                text.append(ch.getUnescapedText());
                                break;
                            }
                            text.append((char)value2);
                            break;
                        }
                        default: {
                            text.append(ch.getUnescapedText());
                            break;
                        }
                    }
                    continue;
                }
                value2 = ch.getValue();
                switch (value2) {
                    case 93: {
                        text.append("\\]");
                        continue block9;
                    }
                    case 45: {
                        if (text.length() != 1) {
                            text.append("\\-");
                            continue block9;
                        }
                    }
                    default: {
                        text.append(ch.getUnescapedText());
                    }
                }
            }
        }
        text.append("]");
        return text.toString();
    }

    private static class SingleCharAlternationVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        SingleCharAlternationVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            if (!Stream.of(branches).allMatch(SingleCharAlternationVisitor::isSingleChar)) {
                return;
            }
            String text = SingleCharAlternationInspection.buildReplacementText(pattern);
            this.myHolder.registerProblem((PsiElement)pattern, RegExpBundle.message("inspection.warning.single.character.alternation.in.regexp", new Object[0]), new LocalQuickFix[]{new SingleCharAlternationFix(text)});
        }

        private static boolean isSingleChar(RegExpBranch branch) {
            RegExpAtom[] atoms = branch.getAtoms();
            return atoms.length == 1 && atoms[0] instanceof RegExpChar;
        }

        private static class SingleCharAlternationFix
        implements LocalQuickFix {
            private final String myText;

            SingleCharAlternationFix(String text) {
                this.myText = text;
            }

            @Nls
            @NotNull
            public String getName() {
                return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myText});
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                return RegExpBundle.message("inspection.quick.fix.replace.alternation.with.character.class", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PsiElement element2 = descriptor2.getPsiElement();
                if (!(element2 instanceof RegExpPattern)) {
                    return;
                }
                RegExpPattern pattern = (RegExpPattern)element2;
                PsiElement parent = pattern.getParent();
                RegExpPattern victim = parent instanceof RegExpGroup && ((RegExpGroup)parent).getType() == RegExpGroup.Type.NON_CAPTURING ? parent : pattern;
                String replacementText = SingleCharAlternationInspection.buildReplacementText(pattern);
                if (replacementText == null) {
                    return;
                }
                RegExpReplacementUtil.replaceInContext(victim, replacementText);
            }
        }
    }
}

