/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantEscapeInspection
extends LocalInspectionTool {
    @NotNull
    public RegExpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new RedundantEscapeVisitor(holder);
    }

    private static class RemoveRedundantEscapeFix
    implements LocalQuickFix {
        private RemoveRedundantEscapeFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return RegExpBundle.message("inspection.quick.fix.remove.redundant.escape", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2 = descriptor2.getPsiElement();
            if (!(element2 instanceof RegExpChar)) {
                return;
            }
            RegExpReplacementUtil.replaceInContext(element2, RemoveRedundantEscapeFix.replacement((RegExpChar)element2));
        }

        @NotNull
        private static String replacement(RegExpChar aChar) {
            int codePoint = aChar.getValue();
            return Character.isSupplementaryCodePoint(codePoint) ? Character.toString(Character.highSurrogate(codePoint)) + Character.lowSurrogate(codePoint) : Character.toString((char)codePoint);
        }
    }

    private static class RedundantEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RedundantEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            String text = ch.getUnescapedText();
            if (!text.startsWith("\\") || !RegExpLanguageHosts.getInstance().isRedundantEscape(ch, text)) {
                return;
            }
            ASTNode astNode = ch.getNode().getFirstChildNode();
            if (astNode == null || astNode.getElementType() != RegExpTT.REDUNDANT_ESCAPE) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.redundant.character.escape.0.in.regexp", ch.getText()), new LocalQuickFix[]{new RemoveRedundantEscapeFix()});
        }
    }
}

