/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OctalEscapeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new OctalEscapeVisitor(holder);
    }

    static String buildReplacementText(RegExpChar aChar) {
        int value2 = aChar.getValue();
        String hex = Integer.toHexString(value2);
        return (hex.length() == 1 ? "\\x0" : "\\x") + hex;
    }

    private static class ReplaceWithHexEscapeFix
    implements LocalQuickFix {
        private final String myHex;

        ReplaceWithHexEscapeFix(String hex) {
            this.myHex = hex;
        }

        @Nls
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myHex});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return RegExpBundle.message("inspection.quick.fix.replace.with.hexadecimal.escape", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2 = descriptor2.getPsiElement();
            if (!(element2 instanceof RegExpChar)) {
                return;
            }
            RegExpReplacementUtil.replaceInContext(element2, OctalEscapeInspection.buildReplacementText((RegExpChar)element2));
        }
    }

    private static class OctalEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        OctalEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.OCT) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.octal.escape.code.ref.code.in.regexp", new Object[0]), new LocalQuickFix[]{new ReplaceWithHexEscapeFix(OctalEscapeInspection.buildReplacementText(ch))});
        }
    }
}

