/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;

public class DuplicateCharacterInClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new DuplicateCharacterInClassVisitor(holder);
    }

    private static class DuplicateCharacterInClassFix
    implements LocalQuickFix {
        private final String myText;

        private DuplicateCharacterInClassFix(RegExpElement predefinedCharacterClass) {
            this.myText = predefinedCharacterClass.getText();
        }

        @NotNull
        public String getName() {
            return RegExpBundle.message("inspection.quick.fix.remove.duplicate.0.from.character.class", this.myText);
        }

        @NotNull
        public String getFamilyName() {
            return RegExpBundle.message("inspection.quick.fix.remove.duplicate.element.from.character.class", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            descriptor2.getPsiElement().delete();
        }
    }

    private static class DuplicateCharacterInClassVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        DuplicateCharacterInClassVisitor(@NotNull ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            HashSet<Object> seen = new HashSet<Object>();
            for (RegExpClassElement element2 : regExpClass.getElements()) {
                this.checkForDuplicates(element2, seen);
            }
        }

        private void checkForDuplicates(RegExpClassElement element2, Set<Object> seen) {
            RegExpSimpleClass regExpSimpleClass;
            RegExpSimpleClass.Kind kind;
            if (element2 instanceof RegExpChar) {
                RegExpChar regExpChar = (RegExpChar)element2;
                int value2 = regExpChar.getValue();
                if (value2 != -1 && !seen.add(value2)) {
                    this.myHolder.registerProblem((PsiElement)regExpChar, RegExpBundle.message("warning.duplicate.character.0.inside.character.class", regExpChar.getText()), new LocalQuickFix[]{new DuplicateCharacterInClassFix(regExpChar)});
                }
            } else if (element2 instanceof RegExpSimpleClass && !seen.add((Object)(kind = (regExpSimpleClass = (RegExpSimpleClass)element2).getKind()))) {
                String text = regExpSimpleClass.getText();
                this.myHolder.registerProblem((PsiElement)regExpSimpleClass, RegExpBundle.message("warning.duplicate.predefined.character.class.0.inside.character.class", text), new LocalQuickFix[]{new DuplicateCharacterInClassFix(regExpSimpleClass)});
            }
        }
    }
}

