/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapabilitiesProvider;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpParserDefinition;
import org.jetbrains.annotations.NotNull;

public class RegExpFileElementType
extends IFileElementType {
    RegExpFileElementType() {
        super("REGEXP_FILE", (Language)RegExpLanguage.INSTANCE);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement outerPsi) {
        PsiElement psi = chameleon.getPsi();
        Project project = psi.getProject();
        Language languageForParser = this.getLanguageForParser(psi);
        RegExpParserDefinition definition = (RegExpParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(languageForParser);
        EnumSet<RegExpCapability> capabilities = RegExpFileElementType.setupCapabilities(psi, EnumSet.copyOf(definition.getDefaultCapabilities()));
        RegExpLexer lexer = definition.createLexer(project, capabilities);
        RegExpParser parser = definition.createParser(project, capabilities);
        PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)lexer, languageForParser, chameleon.getChars());
        ((LightPsiParser)parser).parseLight((IElementType)this, builder2);
        return builder2.getTreeBuilt().getFirstChildNode();
    }

    @NotNull
    private static EnumSet<RegExpCapability> setupCapabilities(PsiElement psi, @NotNull EnumSet<RegExpCapability> capabilities) {
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost(psi);
        if (host == null && !(psi instanceof PsiFile)) {
            host = psi.getParent();
        }
        Language language = host == null ? null : host.getLanguage();
        RegExpCapabilitiesProvider provider = language == null ? null : (RegExpCapabilitiesProvider)RegExpCapabilitiesProvider.EP.forLanguage(language);
        return provider == null ? capabilities : EnumSet.copyOf(provider.setup((PsiElement)host, capabilities));
    }
}

